/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.synch.cnctrs.bedework;

import org.bedework.synch.cnctrs.bedework.BedeworkConnectorConfig;
import org.bedework.synch.cnctrs.bedework.BedeworkConnectorInstance;
import org.bedework.synch.cnctrs.bedework.BedeworkSubscriptionInfo;
import org.bedework.synch.shared.Notification;
import org.bedework.synch.shared.PropertiesInfo;
import org.bedework.synch.shared.Subscription;
import org.bedework.synch.shared.SynchDefs;
import org.bedework.synch.shared.SynchEngine;
import org.bedework.synch.shared.cnctrs.AbstractConnector;
import org.bedework.synch.shared.conf.ConnectorConfigI;
import org.bedework.synch.shared.exception.SynchException;
import org.bedework.synch.wsmessages.CalProcessingType;
import org.bedework.synch.wsmessages.KeepAliveNotificationType;
import org.bedework.synch.wsmessages.KeepAliveResponseType;
import org.bedework.synch.wsmessages.StartServiceNotificationType;
import org.bedework.synch.wsmessages.StartServiceResponseType;
import org.bedework.synch.wsmessages.SynchEndType;
import org.bedework.synch.wsmessages.SynchIdTokenType;
import org.bedework.synch.wsmessages.SynchRemoteServicePortType;
import org.oasis_open.docs.ws_calendar.ns.soap.GetPropertiesResponseType;
import org.oasis_open.docs.ws_calendar.ns.soap.GetPropertiesType;
import org.oasis_open.docs.ws_calendar.ns.soap.StatusType;

public class BedeworkConnector
extends AbstractConnector<BedeworkConnector, BedeworkConnectorInstance, Notification, BedeworkConnectorConfig, BedeworkSubscriptionInfo> {
    private static PropertiesInfo bwPropInfo = new PropertiesInfo();
    private String remoteToken;
    private GetPropertiesResponseType sysInfo;
    private PingThread pinger;

    public BedeworkConnector() {
        super(bwPropInfo);
    }

    public void start(String connectorId, BedeworkConnectorConfig conf, String callbackUri, SynchEngine syncher) {
        super.start(connectorId, (ConnectorConfigI)conf, callbackUri, syncher);
        if (this.pinger == null) {
            this.pinger = new PingThread(connectorId, this);
            this.pinger.start();
        }
    }

    public SynchDefs.SynchKind getKind() {
        return SynchDefs.SynchKind.notify;
    }

    public BedeworkConnectorInstance makeInstance(Subscription sub, SynchEndType end) throws SynchException {
        BedeworkSubscriptionInfo info = end == SynchEndType.A ? new BedeworkSubscriptionInfo(sub.getEndAConnectorInfo()) : new BedeworkSubscriptionInfo(sub.getEndBConnectorInfo());
        return new BedeworkConnectorInstance((BedeworkConnectorConfig)this.config, this, sub, end, info);
    }

    public void stop() throws SynchException {
        this.stopped = true;
        if (this.pinger != null) {
            this.pinger.interrupt();
        }
        this.pinger = null;
    }

    SynchRemoteServicePortType getPort() throws SynchException {
        return this.getPort(((BedeworkConnectorConfig)this.config).getBwWSDLURI());
    }

    SynchIdTokenType getIdToken(String principal, String opaqueData) throws SynchException {
        if (this.remoteToken == null) {
            throw new SynchException(SynchException.connectorNotStarted);
        }
        SynchIdTokenType idToken = new SynchIdTokenType();
        idToken.setPrincipalHref(principal);
        idToken.setSubscribeUrl(this.callbackUri);
        idToken.setSynchToken(this.remoteToken);
        idToken.setOpaqueData(opaqueData);
        return idToken;
    }

    public void ping() throws SynchException {
        KeepAliveNotificationType kan = new KeepAliveNotificationType();
        kan.setSubscribeUrl(this.callbackUri);
        kan.setToken(this.remoteToken);
        KeepAliveResponseType kar = this.getPort().pingService(kan);
        if (kar.getStatus() != StatusType.OK) {
            this.warn("Received status " + kar.getStatus() + " for ping");
            this.remoteToken = null;
            this.running = false;
        }
    }

    private void initConnection() throws SynchException {
        StartServiceNotificationType ssn = new StartServiceNotificationType();
        ssn.setConnectorId(this.getConnectorId());
        ssn.setSubscribeUrl(this.callbackUri);
        StartServiceResponseType ssr = this.getPort().startService(ssn);
        if (ssr == null) {
            this.warn("Received null response to start notification");
            return;
        }
        if (ssr.getStatus() != StatusType.OK) {
            this.warn("Received status " + ssr.getStatus() + " to start notification");
            return;
        }
        this.remoteToken = ssr.getToken();
        if (this.sysInfo == null) {
            GetPropertiesType gp = new GetPropertiesType();
            gp.setHref("/");
            this.sysInfo = this.getPort().getProperties(this.getIdToken(null, null), gp);
        }
    }

    static {
        bwPropInfo.requiredUri(null);
        bwPropInfo.requiredPrincipal(null);
        bwPropInfo.optionCalProcessing("alarm-processing", "", CalProcessingType.REMOVE.toString());
        bwPropInfo.optionCalProcessing("scheduling-processing", "", CalProcessingType.REMOVE.toString());
    }

    private class PingThread
    extends Thread {
        boolean showedTrace;
        BedeworkConnector conn;

        public PingThread(String name, BedeworkConnector conn) {
            super(name);
            this.conn = conn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.conn.isStopped()) {
                if (BedeworkConnector.this.debug()) {
                    BedeworkConnector.this.debug("About to call service - token = " + BedeworkConnector.this.remoteToken);
                }
                try {
                    if (BedeworkConnector.this.remoteToken == null) {
                        BedeworkConnector.this.initConnection();
                        if (BedeworkConnector.this.remoteToken != null) {
                            BedeworkConnector.this.running = true;
                        }
                    } else {
                        BedeworkConnector.this.ping();
                    }
                }
                catch (Throwable t) {
                    if (!this.showedTrace) {
                        BedeworkConnector.this.error(t);
                        this.showedTrace = true;
                    }
                    BedeworkConnector.this.error(t.getMessage());
                }
                if (BedeworkConnector.this.debug()) {
                    BedeworkConnector.this.debug("About to pause - token = " + BedeworkConnector.this.remoteToken);
                }
                try {
                    Object o = new Object();
                    long waitTime = BedeworkConnector.this.remoteToken == null ? (long)(((BedeworkConnectorConfig)BedeworkConnector.this.config).getRetryInterval() * 1000) : (long)(((BedeworkConnectorConfig)BedeworkConnector.this.config).getKeepAliveInterval() * 1000);
                    Object object = o;
                    synchronized (object) {
                        o.wait(waitTime);
                    }
                }
                catch (InterruptedException ie) {
                    break;
                }
                catch (Throwable t) {
                    BedeworkConnector.this.error(t.getMessage());
                }
            }
        }
    }
}

