/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.synch.cnctrs.bedework;

import ietf.params.xml.ns.icalendar_2.ArrayOfComponents;
import ietf.params.xml.ns.icalendar_2.ArrayOfProperties;
import ietf.params.xml.ns.icalendar_2.BaseComponentType;
import ietf.params.xml.ns.icalendar_2.IcalendarType;
import ietf.params.xml.ns.icalendar_2.LastModifiedPropType;
import ietf.params.xml.ns.icalendar_2.ObjectFactory;
import ietf.params.xml.ns.icalendar_2.UidPropType;
import ietf.params.xml.ns.icalendar_2.VcalendarType;
import ietf.params.xml.ns.icalendar_2.VeventType;
import ietf.params.xml.ns.icalendar_2.VtodoType;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.bedework.synch.cnctrs.bedework.BedeworkConnector;
import org.bedework.synch.cnctrs.bedework.BedeworkConnectorConfig;
import org.bedework.synch.cnctrs.bedework.BedeworkSubscriptionInfo;
import org.bedework.synch.shared.BaseSubscriptionInfo;
import org.bedework.synch.shared.Subscription;
import org.bedework.synch.shared.cnctrs.AbstractConnector;
import org.bedework.synch.shared.cnctrs.AbstractConnectorInstance;
import org.bedework.synch.shared.cnctrs.ConnectorInstance;
import org.bedework.synch.shared.conf.ConnectorConfigI;
import org.bedework.synch.shared.exception.SynchException;
import org.bedework.synch.wsmessages.SynchEndType;
import org.bedework.synch.wsmessages.SynchIdTokenType;
import org.bedework.util.calendar.XcalUtil;
import org.bedework.util.xml.tagdefs.XcalTags;
import org.oasis_open.docs.ws_calendar.ns.soap.AddItemResponseType;
import org.oasis_open.docs.ws_calendar.ns.soap.AddItemType;
import org.oasis_open.docs.ws_calendar.ns.soap.AllpropType;
import org.oasis_open.docs.ws_calendar.ns.soap.CalendarDataResponseType;
import org.oasis_open.docs.ws_calendar.ns.soap.CalendarQueryResponseType;
import org.oasis_open.docs.ws_calendar.ns.soap.CalendarQueryType;
import org.oasis_open.docs.ws_calendar.ns.soap.CompFilterType;
import org.oasis_open.docs.ws_calendar.ns.soap.DeleteItemResponseType;
import org.oasis_open.docs.ws_calendar.ns.soap.DeleteItemType;
import org.oasis_open.docs.ws_calendar.ns.soap.FetchItemResponseType;
import org.oasis_open.docs.ws_calendar.ns.soap.FilterType;
import org.oasis_open.docs.ws_calendar.ns.soap.MultistatResponseElementType;
import org.oasis_open.docs.ws_calendar.ns.soap.MultistatusPropElementType;
import org.oasis_open.docs.ws_calendar.ns.soap.PropFilterType;
import org.oasis_open.docs.ws_calendar.ns.soap.PropstatType;
import org.oasis_open.docs.ws_calendar.ns.soap.StatusType;
import org.oasis_open.docs.ws_calendar.ns.soap.TextMatchType;
import org.oasis_open.docs.ws_calendar.ns.soap.UpdateItemResponseType;
import org.oasis_open.docs.ws_calendar.ns.soap.UpdateItemType;

public class BedeworkConnectorInstance
extends AbstractConnectorInstance<BedeworkConnector, BedeworkSubscriptionInfo, BedeworkConnectorConfig> {
    BedeworkConnectorInstance(BedeworkConnectorConfig config, BedeworkConnector cnctr, Subscription sub, SynchEndType end, BedeworkSubscriptionInfo info) {
        super(sub, end, (BaseSubscriptionInfo)info, (AbstractConnector)cnctr, (ConnectorConfigI)config);
    }

    public boolean changed() throws SynchException {
        return false;
    }

    public ConnectorInstance.SynchItemsInfo getItemsInfo() throws SynchException {
        CalendarQueryType cq = new CalendarQueryType();
        ObjectFactory of = ((BedeworkConnector)this.cnctr).getIcalObjectFactory();
        cq.setHref(((BedeworkSubscriptionInfo)this.info).getUri());
        cq.setIcalendar(new IcalendarType());
        VcalendarType vcal = new VcalendarType();
        cq.getIcalendar().getVcalendar().add(vcal);
        ArrayOfComponents aovcc = new ArrayOfComponents();
        vcal.setComponents(aovcc);
        ArrayOfProperties aop = new ArrayOfProperties();
        UidPropType propUid = new UidPropType();
        aop.getBasePropertyOrTzid().add(of.createUid(propUid));
        LastModifiedPropType propLastMod = new LastModifiedPropType();
        aop.getBasePropertyOrTzid().add(of.createLastModified(propLastMod));
        VeventType comp = new VeventType();
        comp.setProperties(aop);
        aovcc.getBaseComponent().add(of.createVevent(comp));
        comp = new VtodoType();
        comp.setProperties(aop);
        aovcc.getBaseComponent().add(of.createVtodo((VtodoType)comp));
        FilterType fltr = new FilterType();
        cq.setFilter(fltr);
        CompFilterType cf = new CompFilterType();
        cf.setVcalendar(new VcalendarType());
        cf.setTest("anyof");
        fltr.setCompFilter(cf);
        CompFilterType cfent = new CompFilterType();
        cf.getCompFilter().add(cfent);
        cfent.setBaseComponent(of.createVevent(new VeventType()));
        cfent = new CompFilterType();
        cf.getCompFilter().add(cfent);
        cfent.setBaseComponent(of.createVtodo(new VtodoType()));
        CalendarQueryResponseType cqr = ((BedeworkConnector)this.cnctr).getPort().calendarQuery(this.getIdToken(), cq);
        ConnectorInstance.SynchItemsInfo sii = new ConnectorInstance.SynchItemsInfo();
        sii.items = new ArrayList();
        sii.setStatus(StatusType.OK);
        if (cqr.getStatus() != StatusType.OK) {
            sii.setStatus(cqr.getStatus());
            sii.setErrorResponse(cqr.getErrorResponse());
            sii.setMessage(cqr.getMessage());
            return sii;
        }
        List responses = cqr.getResponse();
        for (MultistatResponseElementType mre : responses) {
            List pss = mre.getPropstat();
            for (PropstatType ps : pss) {
                if (ps.getStatus() != StatusType.OK) continue;
                for (MultistatusPropElementType prop : ps.getProp()) {
                    CalendarDataResponseType cd;
                    if (prop.getCalendarData() == null || (cd = prop.getCalendarData()).getIcalendar() == null) continue;
                    sii.items.add(this.getItem(cd.getIcalendar()));
                }
            }
        }
        return sii;
    }

    private ConnectorInstance.ItemInfo getItem(IcalendarType ical) {
        VcalendarType vcal = (VcalendarType)ical.getVcalendar().get(0);
        List comps = vcal.getComponents().getBaseComponent();
        BaseComponentType comp = (BaseComponentType)((JAXBElement)comps.get(0)).getValue();
        UidPropType uid = (UidPropType)XcalUtil.findProperty((BaseComponentType)comp, (QName)XcalTags.uid);
        LastModifiedPropType lastmod = (LastModifiedPropType)XcalUtil.findProperty((BaseComponentType)comp, (QName)XcalTags.lastModified);
        return new ConnectorInstance.ItemInfo(uid.getText(), lastmod.getUtcDateTime().toXMLFormat(), null);
    }

    public AddItemResponseType addItem(IcalendarType val) throws SynchException {
        AddItemType ai = new AddItemType();
        ai.setHref(((BedeworkSubscriptionInfo)this.info).getUri());
        ai.setIcalendar(val);
        return ((BedeworkConnector)this.cnctr).getPort().addItem(this.getIdToken(), ai);
    }

    public FetchItemResponseType fetchItem(String uid) throws SynchException {
        CalendarQueryType cq = new CalendarQueryType();
        ObjectFactory of = ((BedeworkConnector)this.cnctr).getIcalObjectFactory();
        cq.setHref(((BedeworkSubscriptionInfo)this.info).getUri());
        cq.setAllprop(new AllpropType());
        FilterType fltr = new FilterType();
        cq.setFilter(fltr);
        CompFilterType cf = new CompFilterType();
        cf.setVcalendar(new VcalendarType());
        fltr.setCompFilter(cf);
        CompFilterType cfev = new CompFilterType();
        cf.getCompFilter().add(cfev);
        cfev.setBaseComponent(of.createVevent(new VeventType()));
        PropFilterType pr = new PropFilterType();
        pr.setBaseProperty(of.createUid(new UidPropType()));
        TextMatchType tm = new TextMatchType();
        tm.setValue(uid);
        pr.setTextMatch(tm);
        cfev.getPropFilter().add(pr);
        CalendarQueryResponseType cqr = ((BedeworkConnector)this.cnctr).getPort().calendarQuery(this.getIdToken(), cq);
        FetchItemResponseType fir = new FetchItemResponseType();
        fir.setStatus(cqr.getStatus());
        if (fir.getStatus() != StatusType.OK) {
            fir.setErrorResponse(cqr.getErrorResponse());
            fir.setMessage(cqr.getMessage());
            return fir;
        }
        List mres = cqr.getResponse();
        if (mres.size() == 0) {
            fir.setStatus(StatusType.NOT_FOUND);
            return fir;
        }
        if (mres.size() > 1) {
            fir.setStatus(StatusType.ERROR);
            fir.setMessage("More than one response");
            return fir;
        }
        MultistatResponseElementType mre = (MultistatResponseElementType)mres.get(0);
        fir.setHref(mre.getHref());
        fir.setChangeToken(mre.getChangeToken());
        if (mre.getPropstat().size() != 1) {
            fir.setStatus(StatusType.ERROR);
            fir.setMessage("More than one propstat in response");
            return fir;
        }
        PropstatType pstat = (PropstatType)mre.getPropstat().get(0);
        if (pstat.getStatus() != StatusType.OK) {
            fir.setStatus(pstat.getStatus());
            fir.setErrorResponse(pstat.getErrorResponse());
            fir.setMessage(pstat.getMessage());
            return fir;
        }
        if (pstat.getProp().size() != 1) {
            fir.setStatus(StatusType.ERROR);
            fir.setMessage("More than one prop in propstat");
            return fir;
        }
        CalendarDataResponseType cdr = ((MultistatusPropElementType)pstat.getProp().get(0)).getCalendarData();
        if (cdr == null || cdr.getIcalendar() == null) {
            fir.setStatus(StatusType.NOT_FOUND);
            return fir;
        }
        fir.setIcalendar(cdr.getIcalendar());
        return fir;
    }

    public List<FetchItemResponseType> fetchItems(List<String> uids) throws SynchException {
        ArrayList<FetchItemResponseType> firs = new ArrayList<FetchItemResponseType>();
        for (String uid : uids) {
            firs.add(this.fetchItem(uid));
        }
        return firs;
    }

    public UpdateItemResponseType updateItem(UpdateItemType updates) throws SynchException {
        return ((BedeworkConnector)this.cnctr).getPort().updateItem(this.getIdToken(), updates);
    }

    public DeleteItemResponseType deleteItem(String uid) throws SynchException {
        FetchItemResponseType fresp = this.fetchItem(uid);
        if (this.debug()) {
            this.debug("deleteItem: status=" + fresp.getStatus() + " msg=" + fresp.getMessage());
        }
        if (fresp.getStatus() != StatusType.OK) {
            DeleteItemResponseType dirt = new DeleteItemResponseType();
            dirt.setStatus(fresp.getStatus());
            return dirt;
        }
        DeleteItemType dit = new DeleteItemType();
        dit.setHref(fresp.getHref());
        return ((BedeworkConnector)this.cnctr).getPort().deleteItem(this.getIdToken(), dit);
    }

    SynchIdTokenType getIdToken() throws SynchException {
        return ((BedeworkConnector)this.cnctr).getIdToken(((BedeworkSubscriptionInfo)this.info).getPrincipalHref(), ((BedeworkSubscriptionInfo)this.info).getOpaqueData());
    }
}

