/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.synch.cnctrs.exchange;

import com.microsoft.schemas.exchange.services._2006.messages.ObjectFactory;
import com.microsoft.schemas.exchange.services._2006.messages.SendNotificationResponseMessageType;
import com.microsoft.schemas.exchange.services._2006.messages.SendNotificationResponseType;
import com.microsoft.schemas.exchange.services._2006.messages.SendNotificationResultType;
import com.microsoft.schemas.exchange.services._2006.types.BaseItemIdType;
import com.microsoft.schemas.exchange.services._2006.types.SubscriptionStatusType;
import ietf.params.xml.ns.icalendar_2.IcalendarType;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import org.bedework.synch.cnctrs.exchange.ExchangeConnectorConfig;
import org.bedework.synch.cnctrs.exchange.ExchangeConnectorInstance;
import org.bedework.synch.cnctrs.exchange.ExchangeNotification;
import org.bedework.synch.cnctrs.exchange.ExchangeNotificationMessage;
import org.bedework.synch.cnctrs.exchange.ExchangeSubscriptionInfo;
import org.bedework.synch.shared.PropertiesInfo;
import org.bedework.synch.shared.Subscription;
import org.bedework.synch.shared.SynchDefs;
import org.bedework.synch.shared.SynchEngine;
import org.bedework.synch.shared.SynchPropertyInfo;
import org.bedework.synch.shared.cnctrs.AbstractConnector;
import org.bedework.synch.shared.cnctrs.Connector;
import org.bedework.synch.shared.cnctrs.ConnectorInstanceMap;
import org.bedework.synch.shared.conf.ConnectorConfigI;
import org.bedework.synch.shared.exception.SynchException;
import org.bedework.synch.wsmessages.SynchEndType;
import org.oasis_open.docs.ws_calendar.ns.soap.StatusType;

public class ExchangeConnector
extends AbstractConnector<ExchangeConnector, ExchangeConnectorInstance, ExchangeNotification, ExchangeConnectorConfig, ExchangeSubscriptionInfo> {
    public static final String propnameFolderId = "exchange-folder-id";
    private static PropertiesInfo exPropInfo = new PropertiesInfo();
    private ConnectorInstanceMap<ExchangeConnectorInstance> cinstMap = new ConnectorInstanceMap();
    private JAXBContext ewsjc;

    public ExchangeConnector() {
        super(exPropInfo);
    }

    public void start(String connectorId, ExchangeConnectorConfig conf, String callbackUri, SynchEngine syncher) {
        super.start(connectorId, (ConnectorConfigI)conf, callbackUri, syncher);
        this.info("**************************************************");
        this.info("Starting exchange connector " + connectorId);
        this.info(" Exchange WSDL URI: " + ((ExchangeConnectorConfig)this.config).getExchangeWSDLURI());
        this.info("      callback URI: " + callbackUri);
        this.info("**************************************************");
        this.stopped = false;
        this.running = true;
    }

    public SynchDefs.SynchKind getKind() {
        return SynchDefs.SynchKind.notify;
    }

    public ExchangeConnectorInstance makeInstance(Subscription sub, SynchEndType end) throws SynchException {
        ExchangeSubscriptionInfo info = end == SynchEndType.A ? new ExchangeSubscriptionInfo(sub.getEndAConnectorInfo()) : new ExchangeSubscriptionInfo(sub.getEndBConnectorInfo());
        return new ExchangeConnectorInstance((ExchangeConnectorConfig)this.config, this, sub, end, info);
    }

    public ExchangeNotificationBatch handleCallback(HttpServletRequest req, HttpServletResponse resp, List<String> resourceUri) throws SynchException {
        SynchEndType end;
        ExchangeNotificationBatch enb = new ExchangeNotificationBatch();
        if (resourceUri.size() != 1) {
            enb.setStatus(StatusType.ERROR);
            return enb;
        }
        String id = resourceUri.get(0);
        try {
            String endFlag = id.substring(0, 1);
            end = SynchEndType.valueOf((String)endFlag);
        }
        catch (Throwable t) {
            enb.setStatus(StatusType.ERROR);
            enb.setMessage("Id not starting with end flag");
            return enb;
        }
        id = id.substring(1);
        Subscription sub = this.syncher.getSubscription(id);
        ExchangeConnectorInstance cinst = (ExchangeConnectorInstance)this.getConnectorInstance(sub, end);
        if (cinst == null) {
            enb.setStatus(StatusType.ERROR);
            enb.setMessage("Unable to get instance for " + sub + " and " + end);
            return enb;
        }
        SendNotificationResponseType snr = (SendNotificationResponseType)this.unmarshalBody(req);
        List responseMessages = snr.getResponseMessages().getCreateItemResponseMessageOrDeleteItemResponseMessageOrGetItemResponseMessage();
        for (JAXBElement el : responseMessages) {
            ExchangeNotificationMessage enm = new ExchangeNotificationMessage((SendNotificationResponseMessageType)el.getValue());
            ExchangeNotification en = new ExchangeNotification(sub, end, enm);
            for (ExchangeNotificationMessage.NotificationItem ni : enm.getNotifications()) {
                IcalendarType ical = cinst.fetchItem((BaseItemIdType)ni.getItemId());
                en.addNotificationItem(new ExchangeNotification.NotificationItem(ni, ical));
            }
            enb.addNotification(en);
        }
        enb.setStatus(StatusType.OK);
        return enb;
    }

    public void respondCallback(HttpServletResponse resp, Connector.NotificationBatch<ExchangeNotification> notifications) throws SynchException {
        try {
            ObjectFactory of = new ObjectFactory();
            SendNotificationResultType snr = of.createSendNotificationResultType();
            if (notifications.getStatus() == StatusType.OK) {
                snr.setSubscriptionStatus(SubscriptionStatusType.OK);
            } else {
                snr.setSubscriptionStatus(SubscriptionStatusType.UNSUBSCRIBE);
            }
        }
        catch (Throwable t) {
            throw new SynchException(t);
        }
    }

    JAXBContext getEwsJAXBContext() throws SynchException {
        try {
            if (this.ewsjc == null) {
                this.ewsjc = JAXBContext.newInstance((String)"com.microsoft.schemas.exchange.services._2006.messages:com.microsoft.schemas.exchange.services._2006.types");
            }
            return this.ewsjc;
        }
        catch (Throwable t) {
            throw new SynchException(t);
        }
    }

    static {
        exPropInfo.add(propnameFolderId, false, SynchPropertyInfo.typeString, "", true);
        exPropInfo.requiredPrincipal(null);
        exPropInfo.requiredPassword(null);
    }

    class ExchangeNotificationBatch
    extends Connector.NotificationBatch<ExchangeNotification> {
        ExchangeNotificationBatch() {
        }
    }
}

