/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.synch.cnctrs.exchange;

import com.microsoft.schemas.exchange.services._2006.messages.ExchangeServicePortType;
import com.microsoft.schemas.exchange.services._2006.messages.ExchangeWebService;
import com.microsoft.schemas.exchange.services._2006.messages.FindItemResponseMessageType;
import com.microsoft.schemas.exchange.services._2006.messages.FindItemResponseType;
import com.microsoft.schemas.exchange.services._2006.messages.FindItemType;
import com.microsoft.schemas.exchange.services._2006.messages.GetItemResponseType;
import com.microsoft.schemas.exchange.services._2006.messages.GetItemType;
import com.microsoft.schemas.exchange.services._2006.messages.ItemInfoResponseMessageType;
import com.microsoft.schemas.exchange.services._2006.messages.ResponseMessageType;
import com.microsoft.schemas.exchange.services._2006.messages.SubscribeResponseMessageType;
import com.microsoft.schemas.exchange.services._2006.messages.SubscribeResponseType;
import com.microsoft.schemas.exchange.services._2006.messages.SubscribeType;
import com.microsoft.schemas.exchange.services._2006.types.BaseFolderIdType;
import com.microsoft.schemas.exchange.services._2006.types.BaseItemIdType;
import com.microsoft.schemas.exchange.services._2006.types.CalendarItemType;
import com.microsoft.schemas.exchange.services._2006.types.DistinguishedFolderIdNameType;
import com.microsoft.schemas.exchange.services._2006.types.DistinguishedFolderIdType;
import com.microsoft.schemas.exchange.services._2006.types.ExchangeVersionType;
import com.microsoft.schemas.exchange.services._2006.types.ItemIdType;
import com.microsoft.schemas.exchange.services._2006.types.ItemType;
import com.microsoft.schemas.exchange.services._2006.types.MailboxCultureType;
import com.microsoft.schemas.exchange.services._2006.types.RequestServerVersion;
import com.microsoft.schemas.exchange.services._2006.types.ServerVersionInfo;
import ietf.params.xml.ns.icalendar_2.IcalendarType;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import org.bedework.synch.cnctrs.exchange.ExchangeConnector;
import org.bedework.synch.cnctrs.exchange.ExchangeConnectorConfig;
import org.bedework.synch.cnctrs.exchange.ExchangeSubscriptionInfo;
import org.bedework.synch.cnctrs.exchange.XmlIcalConvert;
import org.bedework.synch.cnctrs.exchange.messages.FindItemsRequest;
import org.bedework.synch.cnctrs.exchange.messages.GetItemsRequest;
import org.bedework.synch.cnctrs.exchange.messages.SubscribeRequest;
import org.bedework.synch.cnctrs.exchange.responses.ExchangeResponse;
import org.bedework.synch.cnctrs.exchange.responses.FinditemsResponse;
import org.bedework.synch.shared.BaseSubscriptionInfo;
import org.bedework.synch.shared.Subscription;
import org.bedework.synch.shared.cnctrs.AbstractConnector;
import org.bedework.synch.shared.cnctrs.AbstractConnectorInstance;
import org.bedework.synch.shared.cnctrs.ConnectorInstance;
import org.bedework.synch.shared.conf.ConnectorConfigI;
import org.bedework.synch.shared.exception.SynchException;
import org.bedework.synch.wsmessages.SynchEndType;
import org.oasis_open.docs.ws_calendar.ns.soap.AddItemResponseType;
import org.oasis_open.docs.ws_calendar.ns.soap.BaseResponseType;
import org.oasis_open.docs.ws_calendar.ns.soap.DeleteItemResponseType;
import org.oasis_open.docs.ws_calendar.ns.soap.FetchItemResponseType;
import org.oasis_open.docs.ws_calendar.ns.soap.UpdateItemResponseType;
import org.oasis_open.docs.ws_calendar.ns.soap.UpdateItemType;

public class ExchangeConnectorInstance
extends AbstractConnectorInstance<ExchangeConnector, ExchangeSubscriptionInfo, ExchangeConnectorConfig> {
    private final XmlIcalConvert icalConverter;

    ExchangeConnectorInstance(ExchangeConnectorConfig config, ExchangeConnector cnctr, Subscription sub, SynchEndType end, ExchangeSubscriptionInfo info) {
        super(sub, end, (BaseSubscriptionInfo)info, (AbstractConnector)cnctr, (ConnectorConfigI)config);
        this.icalConverter = new XmlIcalConvert(cnctr.getSyncher().getTzGetter());
    }

    public BaseResponseType open() throws SynchException {
        try {
            List rms;
            SubscribeRequest s = new SubscribeRequest(this.sub.getSubscriptionId(), this.end, ((ExchangeSubscriptionInfo)this.info).getExchangeWatermark(), ((ExchangeConnector)this.cnctr).getCallbackUri());
            s.setFolderId(((ExchangeSubscriptionInfo)this.info).getExchangeCalendar());
            Holder subscribeResult = new Holder();
            this.getPort((ExchangeSubscriptionInfo)this.info).subscribe((SubscribeType)s.getRequest(), this.getMailboxCulture(), this.getRequestServerVersion(), subscribeResult, this.getServerVersionInfoHolder());
            if (this.debug()) {
                this.debug(subscribeResult.toString());
            }
            if ((rms = ((SubscribeResponseType)subscribeResult.value).getResponseMessages().getCreateItemResponseMessageOrDeleteItemResponseMessageOrGetItemResponseMessage()).size() != 1) {
                return null;
            }
            SubscribeResponseMessageType srm = (SubscribeResponseMessageType)((JAXBElement)rms.iterator().next()).getValue();
            ExchangeResponse br = new ExchangeResponse((ResponseMessageType)srm);
            if (this.debug()) {
                this.debug(((Object)((Object)br)).toString());
            }
            return br;
        }
        catch (SynchException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new SynchException(t);
        }
    }

    public boolean changed() throws SynchException {
        return false;
    }

    public ConnectorInstance.SynchItemsInfo getItemsInfo() throws SynchException {
        DistinguishedFolderIdType fid = new DistinguishedFolderIdType();
        fid.setId(DistinguishedFolderIdNameType.fromValue((String)((ExchangeSubscriptionInfo)this.info).getExchangeCalendar()));
        FindItemsRequest fir = FindItemsRequest.getSynchInfo((BaseFolderIdType)fid);
        Holder fiResult = new Holder();
        this.getPort((ExchangeSubscriptionInfo)this.info).findItem((FindItemType)fir.getRequest(), this.getMailboxCulture(), this.getRequestServerVersion(), fiResult, this.getServerVersionInfoHolder());
        List rms = ((FindItemResponseType)fiResult.value).getResponseMessages().getCreateItemResponseMessageOrDeleteItemResponseMessageOrGetItemResponseMessage();
        ConnectorInstance.SynchItemsInfo sii = new ConnectorInstance.SynchItemsInfo();
        sii.items = new ArrayList();
        for (JAXBElement jaxbrm : rms) {
            FindItemResponseMessageType firm = (FindItemResponseMessageType)jaxbrm.getValue();
            FinditemsResponse resp = new FinditemsResponse(firm, true, ((ExchangeConnector)this.cnctr).getSyncher().getTzGetter());
            if (this.debug()) {
                this.debug(resp.toString());
            }
            for (FinditemsResponse.SynchInfo si : resp.getSynchInfo()) {
                ExchangeItemInfo eii = new ExchangeItemInfo(si.uid, si.lastMod, si.itemId);
                sii.items.add(eii);
            }
        }
        return sii;
    }

    public AddItemResponseType addItem(IcalendarType val) throws SynchException {
        return null;
    }

    public FetchItemResponseType fetchItem(String href) throws SynchException {
        return null;
    }

    public List<FetchItemResponseType> fetchItems(List<String> uids) throws SynchException {
        return null;
    }

    public UpdateItemResponseType updateItem(UpdateItemType updates) throws SynchException {
        return null;
    }

    public DeleteItemResponseType deleteItem(String uid) throws SynchException {
        return null;
    }

    private MailboxCultureType getMailboxCulture() {
        MailboxCultureType mbc = new MailboxCultureType();
        mbc.setValue("en-US");
        return mbc;
    }

    ExchangeServicePortType getPort(ExchangeSubscriptionInfo sub) throws SynchException {
        try {
            return this.getExchangeServicePort(sub.getPrincipalHref(), ((ExchangeConnector)this.cnctr).getSyncher().decrypt(sub.getPassword()).toCharArray());
        }
        catch (SynchException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new SynchException(t);
        }
    }

    public int hashCode() {
        return this.sub.hashCode() * this.end.hashCode();
    }

    public boolean equals(Object o) {
        ExchangeConnectorInstance that = (ExchangeConnectorInstance)((Object)o);
        if (that.end != this.end) {
            return false;
        }
        return this.sub.equals(that.sub);
    }

    private ExchangeServicePortType getExchangeServicePort(final String user, final char[] pw) throws SynchException {
        try {
            URL wsdlURL = new URL(((ExchangeConnectorConfig)this.config).getExchangeWSDLURI());
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(user, pw);
                }
            });
            ExchangeWebService ews = new ExchangeWebService(wsdlURL, new QName("http://schemas.microsoft.com/exchange/services/2006/messages", "ExchangeWebService"));
            ExchangeServicePortType port = ews.getExchangeWebPort();
            return port;
        }
        catch (Throwable t) {
            throw new SynchException(t);
        }
    }

    IcalendarType fetchItem(BaseItemIdType id) throws SynchException {
        ArrayList<BaseItemIdType> toFetch = new ArrayList<BaseItemIdType>();
        toFetch.add(id);
        List<IcalendarType> items = this.fetchExItems(toFetch);
        if (items.size() != 1) {
            return null;
        }
        return items.get(0);
    }

    private List<IcalendarType> fetchExItems(List<BaseItemIdType> toFetch) throws SynchException {
        GetItemsRequest gir = new GetItemsRequest(toFetch);
        Holder giResult = new Holder();
        this.getPort((ExchangeSubscriptionInfo)this.info).getItem((GetItemType)gir.getRequest(), this.getMailboxCulture(), this.getRequestServerVersion(), giResult, this.getServerVersionInfoHolder());
        List girms = ((GetItemResponseType)giResult.value).getResponseMessages().getCreateItemResponseMessageOrDeleteItemResponseMessageOrGetItemResponseMessage();
        ArrayList<IcalendarType> items = new ArrayList<IcalendarType>();
        for (JAXBElement jaxbgirm : girms) {
            ItemInfoResponseMessageType iirm;
            Object o = jaxbgirm.getValue();
            if (!(o instanceof ItemInfoResponseMessageType) || (iirm = (ItemInfoResponseMessageType)o).getItems() == null) continue;
            for (ItemType item : iirm.getItems().getItemOrMessageOrCalendarItem()) {
                if (!(item instanceof CalendarItemType)) continue;
                IcalendarType ical = this.icalConverter.toXml((CalendarItemType)item);
                if (this.debug()) {
                    // empty if block
                }
                items.add(ical);
            }
        }
        return items;
    }

    private Holder<ServerVersionInfo> getServerVersionInfoHolder() {
        ServerVersionInfo serverVersionInfo = new ServerVersionInfo();
        Holder serverVersion = new Holder((Object)serverVersionInfo);
        return serverVersion;
    }

    private RequestServerVersion getRequestServerVersion() {
        RequestServerVersion requestVersion = new RequestServerVersion();
        requestVersion.setVersion(ExchangeVersionType.EXCHANGE_2010);
        return requestVersion;
    }

    class ExchangeItemInfo
    extends ConnectorInstance.ItemInfo {
        private final ItemIdType itemId;

        public ExchangeItemInfo(String uid, String lastMod, ItemIdType itemId) {
            super(uid, lastMod, null);
            this.itemId = itemId;
        }

        ItemIdType getItemId() {
            return this.itemId;
        }
    }
}

