/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.synch.cnctrs.exchange;

import com.microsoft.schemas.exchange.services._2006.messages.ResponseMessageType;
import com.microsoft.schemas.exchange.services._2006.messages.SendNotificationResponseMessageType;
import com.microsoft.schemas.exchange.services._2006.types.BaseNotificationEventType;
import com.microsoft.schemas.exchange.services._2006.types.BaseObjectChangedEventType;
import com.microsoft.schemas.exchange.services._2006.types.FolderIdType;
import com.microsoft.schemas.exchange.services._2006.types.ItemIdType;
import com.microsoft.schemas.exchange.services._2006.types.ModifiedEventType;
import com.microsoft.schemas.exchange.services._2006.types.MovedCopiedEventType;
import com.microsoft.schemas.exchange.services._2006.types.NotificationType;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.bedework.synch.cnctrs.exchange.responses.ExchangeResponse;
import org.bedework.synch.shared.Notification;
import org.bedework.synch.shared.exception.SynchException;
import org.bedework.util.misc.ToString;

public class ExchangeNotificationMessage
extends ExchangeResponse {
    private final String subscriptionId;
    private final String previousWatermark;
    private final List<NotificationItem> notifications = new ArrayList<NotificationItem>();

    public ExchangeNotificationMessage(SendNotificationResponseMessageType snrm) throws SynchException {
        super((ResponseMessageType)snrm);
        NotificationType nt = snrm.getNotification();
        this.subscriptionId = nt.getSubscriptionId();
        this.previousWatermark = nt.getPreviousWatermark();
        List bnes = nt.getCopiedEventOrCreatedEventOrDeletedEvent();
        for (JAXBElement el1 : bnes) {
            this.notifications.add(new NotificationItem(el1.getName().getLocalPart(), (BaseNotificationEventType)el1.getValue()));
        }
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getPreviousWatermark() {
        return this.previousWatermark;
    }

    public List<NotificationItem> getNotifications() {
        return this.notifications;
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        super.toStringSegment(ts);
        ts.append("subscriptionId", (Object)this.getSubscriptionId());
        ts.append("previousWatermark", (Object)this.getPreviousWatermark());
        ts.append("notification items", this.getNotifications());
        return ts.toString();
    }

    public static class NotificationItem
    extends BaseObjectChangedEventType {
        private Notification.NotificationItem.ActionType action;
        private FolderIdType oldFolderId;
        private ItemIdType oldItemId;
        private FolderIdType oldParentFolderId;
        private Integer unreadCount;

        private NotificationItem(String actionStr, BaseNotificationEventType bne) {
            MovedCopiedEventType mce;
            this.setWatermark(bne.getWatermark());
            if (actionStr.equals("StatusEvent")) {
                this.action = Notification.NotificationItem.ActionType.StatusEvent;
                return;
            }
            if (bne instanceof BaseObjectChangedEventType) {
                BaseObjectChangedEventType boce = (BaseObjectChangedEventType)bne;
                this.setTimeStamp(boce.getTimeStamp());
                this.setFolderId(boce.getFolderId());
                this.setItemId(boce.getItemId());
                this.setParentFolderId(boce.getParentFolderId());
            }
            if (actionStr.equals("CopiedEvent")) {
                this.action = Notification.NotificationItem.ActionType.CopiedEvent;
                mce = (MovedCopiedEventType)bne;
                this.oldFolderId = mce.getOldFolderId();
                this.oldItemId = mce.getOldItemId();
                this.oldParentFolderId = mce.getOldParentFolderId();
                return;
            }
            if (actionStr.equals("CreatedEvent")) {
                this.action = Notification.NotificationItem.ActionType.CreatedEvent;
                return;
            }
            if (actionStr.equals("DeletedEvent")) {
                this.action = Notification.NotificationItem.ActionType.DeletedEvent;
                return;
            }
            if (actionStr.equals("ModifiedEvent")) {
                this.action = Notification.NotificationItem.ActionType.ModifiedEvent;
                ModifiedEventType met = (ModifiedEventType)bne;
                this.unreadCount = met.getUnreadCount();
                return;
            }
            if (actionStr.equals("MovedEvent")) {
                this.action = Notification.NotificationItem.ActionType.MovedEvent;
                mce = (MovedCopiedEventType)bne;
                this.oldFolderId = mce.getOldFolderId();
                this.oldItemId = mce.getOldItemId();
                this.oldParentFolderId = mce.getOldParentFolderId();
                return;
            }
            if (actionStr.equals("NewMailEvent")) {
                this.action = Notification.NotificationItem.ActionType.NewMailEvent;
                return;
            }
        }

        public String getWatermark() {
            return this.watermark;
        }

        public Notification.NotificationItem.ActionType getAction() {
            return this.action;
        }

        public FolderIdType getOldFolderId() {
            return this.oldFolderId;
        }

        public ItemIdType getOldItemId() {
            return this.oldItemId;
        }

        public FolderIdType getOldParentFolderId() {
            return this.oldParentFolderId;
        }

        public Integer getUnreadCount() {
            return this.unreadCount;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("NotificationItem{");
            sb.append("watermark=");
            sb.append(this.getWatermark());
            sb.append(",\n      action=");
            sb.append(this.getAction());
            sb.append(", timeStamp=");
            sb.append(this.getTimeStamp());
            sb.append(",\n      folderId=");
            sb.append(this.getFolderId());
            sb.append(",\n      itemId=");
            sb.append(this.getItemId());
            sb.append(",\n      parentFolderId=");
            sb.append(this.getParentFolderId());
            if (this.getOldFolderId() != null) {
                sb.append(",\n      oldFolderId=");
                sb.append(this.getOldFolderId());
            }
            if (this.getOldItemId() != null) {
                sb.append(",\n       oldItemId=");
                sb.append(this.getOldItemId());
            }
            if (this.getOldParentFolderId() != null) {
                sb.append(",\n       oldParentFolderId=");
                sb.append(this.getOldParentFolderId());
            }
            if (this.getUnreadCount() != null) {
                sb.append(",\n       unreadCount=");
                sb.append(this.getUnreadCount());
            }
            sb.append("}");
            return sb.toString();
        }
    }
}

