/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.synch.cnctrs.exchange;

import com.microsoft.schemas.exchange.services._2006.types.AttendeeType;
import com.microsoft.schemas.exchange.services._2006.types.BodyType;
import com.microsoft.schemas.exchange.services._2006.types.CalendarItemType;
import com.microsoft.schemas.exchange.services._2006.types.EmailAddressType;
import com.microsoft.schemas.exchange.services._2006.types.NonEmptyArrayOfAttendeesType;
import com.microsoft.schemas.exchange.services._2006.types.ResponseTypeType;
import com.microsoft.schemas.exchange.services._2006.types.SingleRecipientType;
import com.microsoft.schemas.exchange.services._2006.types.TimeZoneDefinitionType;
import ietf.params.xml.ns.icalendar_2.ActionPropType;
import ietf.params.xml.ns.icalendar_2.ArrayOfComponents;
import ietf.params.xml.ns.icalendar_2.ArrayOfParameters;
import ietf.params.xml.ns.icalendar_2.ArrayOfProperties;
import ietf.params.xml.ns.icalendar_2.AttendeePropType;
import ietf.params.xml.ns.icalendar_2.BaseComponentType;
import ietf.params.xml.ns.icalendar_2.BasePropertyType;
import ietf.params.xml.ns.icalendar_2.CalAddressPropertyType;
import ietf.params.xml.ns.icalendar_2.CategoriesPropType;
import ietf.params.xml.ns.icalendar_2.ClassPropType;
import ietf.params.xml.ns.icalendar_2.CnParamType;
import ietf.params.xml.ns.icalendar_2.DescriptionPropType;
import ietf.params.xml.ns.icalendar_2.DtendPropType;
import ietf.params.xml.ns.icalendar_2.DtstartPropType;
import ietf.params.xml.ns.icalendar_2.DuePropType;
import ietf.params.xml.ns.icalendar_2.IcalendarType;
import ietf.params.xml.ns.icalendar_2.LocationPropType;
import ietf.params.xml.ns.icalendar_2.ObjectFactory;
import ietf.params.xml.ns.icalendar_2.OrganizerPropType;
import ietf.params.xml.ns.icalendar_2.PartstatParamType;
import ietf.params.xml.ns.icalendar_2.RoleParamType;
import ietf.params.xml.ns.icalendar_2.StatusPropType;
import ietf.params.xml.ns.icalendar_2.SummaryPropType;
import ietf.params.xml.ns.icalendar_2.TranspPropType;
import ietf.params.xml.ns.icalendar_2.TriggerPropType;
import ietf.params.xml.ns.icalendar_2.TzidParamType;
import ietf.params.xml.ns.icalendar_2.UidPropType;
import ietf.params.xml.ns.icalendar_2.ValarmType;
import ietf.params.xml.ns.icalendar_2.VcalendarType;
import ietf.params.xml.ns.icalendar_2.VeventType;
import ietf.params.xml.ns.icalendar_2.VjournalType;
import ietf.params.xml.ns.icalendar_2.VtodoType;
import ietf.params.xml.ns.icalendar_2.XBedeworkExsynchLastmodPropType;
import ietf.params.xml.ns.icalendar_2.XMicrosoftCdoBusystatusPropType;
import java.util.List;
import java.util.TimeZone;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.XMLGregorianCalendar;
import org.bedework.synch.intf.Defs;
import org.bedework.synch.shared.exception.SynchException;
import org.bedework.util.calendar.XcalUtil;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;

public class XmlIcalConvert
implements Logged,
Defs {
    private final ObjectFactory xcalOF = new ObjectFactory();
    private final XcalUtil.TzGetter tzGetter;
    private BwLogger logger = new BwLogger();

    public XmlIcalConvert(XcalUtil.TzGetter tzGetter) {
        this.tzGetter = tzGetter;
    }

    public IcalendarType toXml(CalendarItemType cal) throws SynchException {
        JAXBElement jaxb;
        JAXBElement el;
        String transpVal = null;
        String statusVal = null;
        IcalendarType ical = new IcalendarType();
        VcalendarType vcal = new VcalendarType();
        ical.getVcalendar().add(vcal);
        vcal.setComponents(new ArrayOfComponents());
        ItemType itemType = this.makeItemType(cal.getItemClass());
        if (itemType == ItemType.Event) {
            el = this.xcalOF.createVevent(new VeventType());
        } else if (itemType == ItemType.Task) {
            el = this.xcalOF.createVtodo(new VtodoType());
        } else if (itemType == ItemType.Journal) {
            el = this.xcalOF.createVjournal(new VjournalType());
        } else {
            throw new SynchException(SynchException.unknownCalendarItemType);
        }
        BaseComponentType comp = (BaseComponentType)el.getValue();
        ArrayOfProperties aop = new ArrayOfProperties();
        List pl = aop.getBasePropertyOrTzid();
        comp.setProperties(aop);
        vcal.getComponents().getBaseComponent().add(el);
        UidPropType uid = new UidPropType();
        uid.setText(cal.getUID());
        JAXBElement jaxbUid = this.xcalOF.createUid(uid);
        pl.add(jaxbUid);
        String extzid = cal.getTimeZone();
        if (this.debug()) {
            this.debug("exchange tzid=" + extzid);
        }
        TzStuff startTz = this.getTz(cal.getStartTimeZone(), extzid);
        TzStuff endTz = this.getTz(cal.getEndTimeZone(), extzid);
        JAXBElement<? extends BasePropertyType> ddp = this.makeDateProp(startTz.tz, cal.getStart(), cal.isIsAllDayEvent(), Dtype.start);
        if (ddp != null) {
            pl.add(ddp);
        }
        Dtype dtype = itemType == ItemType.Task ? Dtype.due : Dtype.end;
        ddp = this.makeDateProp(endTz.tz, cal.getEnd(), cal.isIsAllDayEvent(), dtype);
        if (ddp != null) {
            pl.add(ddp);
        }
        if (this.debug()) {
            this.debug("dtstamp=" + cal.getDateTimeStamp().toXMLFormat());
        }
        if (cal.getLegacyFreeBusyStatus() != null) {
            XMicrosoftCdoBusystatusPropType bsp = new XMicrosoftCdoBusystatusPropType();
            bsp.setText(cal.getLegacyFreeBusyStatus().value());
            JAXBElement jaxb1 = this.xcalOF.createXMicrosoftCdoBusystatus(bsp);
            pl.add(jaxb1);
        }
        if (cal.getLocation() != null && cal.getLocation().length() > 0) {
            LocationPropType loc = new LocationPropType();
            loc.setText(cal.getLocation());
            JAXBElement jaxb2 = this.xcalOF.createLocation(loc);
            pl.add(jaxb2);
        }
        if (cal.isIsCancelled().booleanValue()) {
            statusVal = "CANCELLED";
            transpVal = "TRANSPARENT";
        }
        NonEmptyArrayOfAttendeesType optAtts = cal.getOptionalAttendees();
        NonEmptyArrayOfAttendeesType reqAtts = cal.getRequiredAttendees();
        if (optAtts != null && !optAtts.getAttendee().isEmpty() || reqAtts != null && !reqAtts.getAttendee().isEmpty()) {
            pl.add(this.makeOrganizer(cal.getOrganizer(), true));
            if (optAtts != null) {
                for (AttendeeType att : optAtts.getAttendee()) {
                    pl.add(this.makeAttendee(att, true));
                }
            }
            if (reqAtts != null) {
                for (AttendeeType att : optAtts.getAttendee()) {
                    pl.add(this.makeAttendee(att, false));
                }
            }
        } else {
            pl.add(this.makeOrganizer(cal.getOrganizer(), false));
        }
        if (cal.isIsRecurring().booleanValue()) {
            // empty if block
        }
        if (this.debug()) {
            this.debug("id: id=" + cal.getItemId().getId() + " ckey=" + cal.getItemId().getChangeKey());
        }
        if (cal.getItemClass() != null & !"PUBLIC".equalsIgnoreCase(cal.getItemClass())) {
            ClassPropType cl = new ClassPropType();
            cl.setText(cal.getItemClass());
            JAXBElement jaxb3 = this.xcalOF.createClass(cl);
            pl.add(jaxb3);
        }
        SummaryPropType sum = new SummaryPropType();
        sum.setText(cal.getSubject());
        JAXBElement jaxbSum = this.xcalOF.createSummary(sum);
        pl.add(jaxbSum);
        BodyType body = cal.getBody();
        if (body != null && body.getValue() != null) {
            DescriptionPropType desc = new DescriptionPropType();
            desc.setText(body.getValue());
            JAXBElement jaxbDesc = this.xcalOF.createDescription(desc);
            pl.add(jaxbDesc);
        }
        if (cal.getCategories() != null && cal.getCategories().getString().size() > 0) {
            CategoriesPropType cp = new CategoriesPropType();
            for (String s : cal.getCategories().getString()) {
                cp.getText().add(s);
            }
            JAXBElement jaxbCat = this.xcalOF.createCategories(cp);
            pl.add(jaxbCat);
        }
        if (cal.isReminderIsSet().booleanValue()) {
            ValarmType al = new ValarmType();
            ArrayOfProperties alAop = new ArrayOfProperties();
            List props = alAop.getBasePropertyOrTzid();
            al.setProperties(alAop);
            ActionPropType act = new ActionPropType();
            act.setText("DISPLAY");
            JAXBElement jaxbAction = this.xcalOF.createAction(act);
            props.add(jaxbAction);
            DescriptionPropType d = new DescriptionPropType();
            d.setText("REMINDER");
            JAXBElement jaxbDesc = this.xcalOF.createDescription(d);
            props.add(jaxbDesc);
            TriggerPropType t = new TriggerPropType();
            t.setDuration("-PT" + cal.getReminderMinutesBeforeStart() + "M");
            JAXBElement jaxbTrig = this.xcalOF.createTrigger(t);
            props.add(jaxbTrig);
            ArrayOfComponents comps = new ArrayOfComponents();
            comps.getBaseComponent().add(this.xcalOF.createValarm(al));
            if (itemType == ItemType.Event || itemType == ItemType.Task) {
                comp.setComponents(comps);
            }
        }
        XBedeworkExsynchLastmodPropType lm = new XBedeworkExsynchLastmodPropType();
        lm.setText(cal.getLastModifiedTime().toXMLFormat());
        JAXBElement jaxblm = this.xcalOF.createXBedeworkExsynchLastmod(lm);
        pl.add(jaxblm);
        if (statusVal != null) {
            StatusPropType st = new StatusPropType();
            st.setText(statusVal);
            jaxb = this.xcalOF.createStatus(st);
            pl.add(jaxb);
        }
        if (transpVal != null) {
            TranspPropType tr = new TranspPropType();
            tr.setText(transpVal);
            jaxb = this.xcalOF.createTransp(tr);
            pl.add(jaxb);
        }
        return ical;
    }

    private ItemType makeItemType(String val) throws SynchException {
        String uval = val.toUpperCase();
        if (uval.equals("IPM.NOTE")) {
            return ItemType.Note;
        }
        if (uval.equals("IPM.POST")) {
            return ItemType.Post;
        }
        if (uval.equals("IPM.APPOINTMENT")) {
            return ItemType.Event;
        }
        if (uval.equals("IPM.TASK")) {
            return ItemType.Task;
        }
        if (uval.equals("IPM.CONTACT")) {
            return ItemType.Contact;
        }
        if (uval.equals("IPM.ACTIVITY")) {
            return ItemType.Journal;
        }
        if (uval.equals("IPM.DISTLIST")) {
            return ItemType.DistList;
        }
        if (uval.equals("IPM.STICKYNOTE")) {
            return ItemType.StickyNote;
        }
        throw new SynchException(SynchException.unknownCalendarItemType);
    }

    public TzStuff getTz(TimeZoneDefinitionType tzdef, String extzid) throws SynchException {
        try {
            TzStuff t = new TzStuff();
            if (tzdef != null) {
                t.id = tzdef.getId();
                if (extzid != null && extzid.equals(t.id)) {
                    t.id = null;
                } else {
                    t.tz = this.tzGetter.getTz(t.id);
                    return t;
                }
            }
            if (extzid != null) {
                t.tz = this.tzGetter.getTz(extzid);
            }
            return t;
        }
        catch (Throwable t) {
            throw new SynchException(t);
        }
    }

    private JAXBElement<? extends OrganizerPropType> makeOrganizer(SingleRecipientType org, boolean realOrg) throws SynchException {
        OrganizerPropType prop = new OrganizerPropType();
        this.setNameAndAddress((CalAddressPropertyType)prop, org.getMailbox());
        if (realOrg) {
            return this.xcalOF.createOrganizer(prop);
        }
        return this.xcalOF.createXBedeworkExsynchOrganizer(prop);
    }

    private JAXBElement<? extends AttendeePropType> makeAttendee(AttendeeType att, boolean optional) throws SynchException {
        AttendeePropType prop = new AttendeePropType();
        this.setNameAndAddress((CalAddressPropertyType)prop, att.getMailbox());
        String partStat = null;
        if (att.getResponseType() == ResponseTypeType.TENTATIVE) {
            partStat = "TENTATIVE";
        } else if (att.getResponseType() == ResponseTypeType.ACCEPT) {
            partStat = "ACCEPTED";
        } else if (att.getResponseType() == ResponseTypeType.DECLINE) {
            partStat = "DECLINED";
        }
        if (partStat != null) {
            PartstatParamType p = new PartstatParamType();
            p.setText(partStat);
            this.getParameters((BasePropertyType)prop).getBaseParameter().add(this.xcalOF.createPartstat(p));
        }
        if (optional) {
            RoleParamType r = new RoleParamType();
            r.setText("OPT-PARTICIPANT");
            this.getParameters((BasePropertyType)prop).getBaseParameter().add(this.xcalOF.createRole(r));
        }
        return this.xcalOF.createAttendee(prop);
    }

    private void setNameAndAddress(CalAddressPropertyType prop, EmailAddressType ea) {
        Object email;
        String name = ea.getName();
        if (name != null) {
            CnParamType c = new CnParamType();
            c.setText(name);
            this.getParameters((BasePropertyType)prop).getBaseParameter().add(this.xcalOF.createCn(c));
        }
        if (!((String)(email = ea.getEmailAddress())).toLowerCase().startsWith("mailto:")) {
            email = "mailto:" + (String)email;
        }
        prop.setCalAddress((String)email);
    }

    private ArrayOfParameters getParameters(BasePropertyType prop) {
        ArrayOfParameters aop = prop.getParameters();
        if (aop == null) {
            aop = new ArrayOfParameters();
            prop.setParameters(aop);
        }
        return aop;
    }

    private JAXBElement<? extends BasePropertyType> makeDateProp(TimeZone tz, XMLGregorianCalendar dt, boolean allDay, Dtype dtype) throws SynchException {
        try {
            JAXBElement jaxbProp;
            DtstartPropType prop;
            if (dt == null) {
                return null;
            }
            if (dtype == Dtype.start) {
                prop = new DtstartPropType();
                jaxbProp = this.xcalOF.createDtstart(prop);
            } else if (dtype == Dtype.due) {
                prop = new DuePropType();
                jaxbProp = this.xcalOF.createDue((DuePropType)prop);
            } else {
                prop = new DtendPropType();
                jaxbProp = this.xcalOF.createDtend((DtendPropType)prop);
            }
            if (allDay) {
                prop.setDate(dt);
            } else {
                prop.setDateTime(dt);
            }
            if (!allDay && tz != null) {
                ArrayOfParameters aop = new ArrayOfParameters();
                TzidParamType t = new TzidParamType();
                t.setText(tz.getID());
                aop.getBaseParameter().add(this.xcalOF.createTzid(t));
                prop.setParameters(aop);
            }
            return jaxbProp;
        }
        catch (Throwable t) {
            throw new SynchException(t);
        }
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }

    private static enum Dtype {
        start,
        end,
        due;

    }

    public static class TzStuff {
        String id;
        TimeZone tz;
    }

    public static enum ItemType {
        Note,
        Post,
        Event,
        Task,
        Contact,
        Journal,
        DistList,
        StickyNote;

    }
}

