/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.synch.cnctrs.exchange.messages;

import com.microsoft.schemas.exchange.services._2006.messages.SubscribeType;
import com.microsoft.schemas.exchange.services._2006.types.DistinguishedFolderIdNameType;
import com.microsoft.schemas.exchange.services._2006.types.DistinguishedFolderIdType;
import com.microsoft.schemas.exchange.services._2006.types.NonEmptyArrayOfBaseFolderIdsType;
import com.microsoft.schemas.exchange.services._2006.types.NonEmptyArrayOfNotificationEventTypesType;
import com.microsoft.schemas.exchange.services._2006.types.NotificationEventTypeType;
import com.microsoft.schemas.exchange.services._2006.types.PushSubscriptionRequestType;
import org.bedework.synch.cnctrs.exchange.messages.BaseRequest;
import org.bedework.synch.wsmessages.SynchEndType;

public class SubscribeRequest
extends BaseRequest<SubscribeType> {
    private NonEmptyArrayOfBaseFolderIdsType folders;
    private DistinguishedFolderIdType fid;

    public SubscribeRequest(String subId, SynchEndType end, String watermark, String callBackUri) {
        this.request = super.createSubscribeType();
        PushSubscriptionRequestType psr = this.types.createPushSubscriptionRequestType();
        ((SubscribeType)this.request).setPushSubscriptionRequest(psr);
        this.folders = this.types.createNonEmptyArrayOfBaseFolderIdsType();
        psr.setFolderIds(this.folders);
        this.fid = this.types.createDistinguishedFolderIdType();
        NonEmptyArrayOfNotificationEventTypesType etypes = this.types.createNonEmptyArrayOfNotificationEventTypesType();
        psr.setEventTypes(etypes);
        etypes.getEventType().add(NotificationEventTypeType.COPIED_EVENT);
        etypes.getEventType().add(NotificationEventTypeType.CREATED_EVENT);
        etypes.getEventType().add(NotificationEventTypeType.DELETED_EVENT);
        etypes.getEventType().add(NotificationEventTypeType.MODIFIED_EVENT);
        etypes.getEventType().add(NotificationEventTypeType.MOVED_EVENT);
        psr.setStatusFrequency(1);
        psr.setWatermark(watermark);
        StringBuilder uri = new StringBuilder(callBackUri);
        if (!callBackUri.endsWith("/")) {
            uri.append("/");
        }
        uri.append(end.name());
        uri.append(subId);
        uri.append("/");
        psr.setURL(uri.toString());
    }

    public void setFolderId(String val) {
        this.fid.setId(DistinguishedFolderIdNameType.fromValue((String)val));
        this.folders.getFolderIdOrDistinguishedFolderId().add(this.fid);
    }
}

