/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.synch.cnctrs.exchange.responses;

import com.microsoft.schemas.exchange.services._2006.messages.ResponseMessageType;
import com.microsoft.schemas.exchange.services._2006.types.ResponseClassType;
import org.bedework.synch.shared.exception.SynchException;
import org.bedework.util.misc.ToString;
import org.oasis_open.docs.ws_calendar.ns.soap.BaseResponseType;
import org.oasis_open.docs.ws_calendar.ns.soap.StatusType;

public class ExchangeResponse
extends BaseResponseType {
    private String responseCode;
    private Integer descriptiveLinkKey;
    private ResponseMessageType.MessageXml messageXml;

    public ExchangeResponse(ResponseMessageType resp) throws SynchException {
        this.message = resp.getMessageText();
        this.responseCode = resp.getResponseCode();
        this.descriptiveLinkKey = resp.getDescriptiveLinkKey();
        this.messageXml = resp.getMessageXml();
        ResponseClassType rcl = resp.getResponseClass();
        if (rcl.equals((Object)ResponseClassType.ERROR)) {
            this.status = StatusType.ERROR;
            return;
        }
        if (rcl.equals((Object)ResponseClassType.WARNING)) {
            this.status = StatusType.WARNING;
            return;
        }
        this.status = StatusType.OK;
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public Integer getDescriptiveLinkKey() {
        return this.descriptiveLinkKey;
    }

    public ResponseMessageType.MessageXml getMessageXml() {
        return this.messageXml;
    }

    public void toStringSegment(ToString ts) {
        ts.append("status", (Object)this.getStatus());
        ts.append("responseCode", (Object)this.getResponseCode());
        if (this.getMessage() != null) {
            ts.append("message", (Object)this.getMessage());
        }
        if (this.getDescriptiveLinkKey() != null) {
            ts.append("descriptiveLinkKey", (Object)this.getDescriptiveLinkKey());
        }
    }
}

