/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.synch.cnctrs.exchange.responses;

import com.microsoft.schemas.exchange.services._2006.messages.FindItemResponseMessageType;
import com.microsoft.schemas.exchange.services._2006.messages.ResponseMessageType;
import com.microsoft.schemas.exchange.services._2006.types.CalendarItemType;
import com.microsoft.schemas.exchange.services._2006.types.FindItemParentType;
import com.microsoft.schemas.exchange.services._2006.types.FolderIdType;
import com.microsoft.schemas.exchange.services._2006.types.ItemIdType;
import com.microsoft.schemas.exchange.services._2006.types.ItemType;
import ietf.params.xml.ns.icalendar_2.IcalendarType;
import java.util.ArrayList;
import java.util.List;
import org.bedework.synch.cnctrs.exchange.XmlIcalConvert;
import org.bedework.synch.cnctrs.exchange.responses.ExchangeResponse;
import org.bedework.synch.shared.exception.SynchException;
import org.bedework.util.calendar.XcalUtil;
import org.bedework.util.misc.ToString;

public class FinditemsResponse
extends ExchangeResponse {
    private final Boolean includesLastItemInRange;
    private List<IcalendarType> icals;
    private List<SynchInfo> synchInfo;

    public FinditemsResponse(FindItemResponseMessageType firm, boolean synchInfoOnly, XcalUtil.TzGetter tzGetter) throws SynchException {
        super((ResponseMessageType)firm);
        FindItemParentType rf = firm.getRootFolder();
        this.includesLastItemInRange = rf.isIncludesLastItemInRange();
        XmlIcalConvert cnv = new XmlIcalConvert(tzGetter);
        for (ItemType item : rf.getItems().getItemOrMessageOrCalendarItem()) {
            if (!(item instanceof CalendarItemType)) continue;
            CalendarItemType ci = (CalendarItemType)item;
            if (!synchInfoOnly) {
                IcalendarType ical = cnv.toXml(ci);
                if (this.icals == null) {
                    this.icals = new ArrayList<IcalendarType>();
                }
                this.icals.add(ical);
                continue;
            }
            SynchInfo si = new SynchInfo(ci.getItemId(), ci.getParentFolderId(), ci.getUID(), ci.getLastModifiedTime().toXMLFormat());
            if (this.synchInfo == null) {
                this.synchInfo = new ArrayList<SynchInfo>();
            }
            this.synchInfo.add(si);
        }
    }

    public Boolean getIncludesLastItemInRange() {
        return this.includesLastItemInRange;
    }

    public List<IcalendarType> getIcals() {
        return this.icals;
    }

    public List<SynchInfo> getSynchInfo() {
        return this.synchInfo;
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        super.toStringSegment(ts);
        ts.append("includesLastItemInRange", (Object)this.getIncludesLastItemInRange());
        ts.append("synchInfo", this.synchInfo);
        return ts.toString();
    }

    public static class SynchInfo {
        public ItemIdType itemId;
        public FolderIdType parentFolderId;
        public String uid;
        public String lastMod;

        public SynchInfo(ItemIdType itemId, FolderIdType parentFolderId, String uid, String lastMod) {
            this.itemId = itemId;
            this.parentFolderId = parentFolderId;
            this.uid = uid;
            this.lastMod = lastMod;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("SynchInfo{");
            this.folderIdToString(sb, "itemId", this.itemId);
            sb.append(",\n      ");
            this.folderIdToString(sb, "parentFolderId", this.parentFolderId);
            sb.append(",\n      uid=");
            sb.append(this.uid);
            sb.append(",\n      lastMod=");
            sb.append(this.lastMod);
            sb.append("}");
            return sb.toString();
        }

        private void folderIdToString(StringBuilder sb, String name, Object id) {
            Object ckey;
            Object iid;
            sb.append(name);
            sb.append("={id=");
            if (id instanceof FolderIdType) {
                FolderIdType fid = (FolderIdType)id;
                iid = fid.getId();
                ckey = fid.getChangeKey();
            } else if (id instanceof ItemIdType) {
                ItemIdType fid = (ItemIdType)id;
                iid = fid.getId();
                ckey = fid.getChangeKey();
            } else {
                ckey = iid = "Unhandled class: " + id.getClass();
            }
            sb.append((String)iid);
            sb.append(",\n        changeKey=");
            sb.append((String)ckey);
            sb.append("}");
        }
    }
}

