/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.synch.cnctrs.exchange.responses;

import com.microsoft.schemas.exchange.services._2006.messages.ResponseMessageType;
import com.microsoft.schemas.exchange.services._2006.messages.SyncFolderItemsResponseMessageType;
import com.microsoft.schemas.exchange.services._2006.types.BaseNotificationEventType;
import com.microsoft.schemas.exchange.services._2006.types.BaseObjectChangedEventType;
import com.microsoft.schemas.exchange.services._2006.types.FolderIdType;
import com.microsoft.schemas.exchange.services._2006.types.ItemIdType;
import com.microsoft.schemas.exchange.services._2006.types.ModifiedEventType;
import com.microsoft.schemas.exchange.services._2006.types.MovedCopiedEventType;
import com.microsoft.schemas.exchange.services._2006.types.SyncFolderItemsChangesType;
import com.microsoft.schemas.exchange.services._2006.types.SyncFolderItemsCreateOrUpdateType;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.bedework.synch.cnctrs.exchange.responses.ExchangeResponse;
import org.bedework.synch.shared.exception.SynchException;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.bedework.util.misc.ToString;

public class SyncFolderitemsResponse
extends ExchangeResponse
implements Logged {
    private String syncState;
    private Boolean includesLastItemInRange;
    private SyncFolderItemsChangesType changes;
    private BwLogger logger = new BwLogger();

    public SyncFolderitemsResponse(SyncFolderItemsResponseMessageType sfirm) throws SynchException {
        super((ResponseMessageType)sfirm);
        this.syncState = sfirm.getSyncState();
        this.includesLastItemInRange = sfirm.isIncludesLastItemInRange();
        List syncitems = sfirm.getChanges().getCreateOrUpdateOrDelete();
        for (JAXBElement el1 : syncitems) {
            String chgType = el1.getName().getLocalPart();
            SyncFolderItemsCreateOrUpdateType s = (SyncFolderItemsCreateOrUpdateType)el1.getValue();
            if (!this.debug()) continue;
            this.debug("chgType =" + chgType);
        }
    }

    public String getSyncState() {
        return this.syncState;
    }

    public Boolean getIncludesLastItemInRange() {
        return this.includesLastItemInRange;
    }

    public SyncFolderItemsChangesType getChanges() {
        return this.changes;
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        super.toStringSegment(ts);
        ts.append("syncState", (Object)this.getSyncState());
        ts.append("includesLastItemInRange", (Object)this.getIncludesLastItemInRange());
        return ts.toString();
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(((Object)((Object)this)).getClass());
        }
        return this.logger;
    }

    public static class NotificationItem
    extends BaseObjectChangedEventType {
        private ActionType action;
        private FolderIdType oldFolderId;
        private ItemIdType oldItemId;
        private FolderIdType oldParentFolderId;
        private Integer unreadCount;

        private NotificationItem(String actionStr, BaseNotificationEventType bne) {
            MovedCopiedEventType mce;
            this.setWatermark(bne.getWatermark());
            if (actionStr.equals("StatusEvent")) {
                this.action = ActionType.StatusEvent;
                return;
            }
            if (bne instanceof BaseObjectChangedEventType) {
                BaseObjectChangedEventType boce = (BaseObjectChangedEventType)bne;
                this.setTimeStamp(boce.getTimeStamp());
                this.setFolderId(boce.getFolderId());
                this.setItemId(boce.getItemId());
                this.setParentFolderId(boce.getParentFolderId());
            }
            if (actionStr.equals("CopiedEvent")) {
                this.action = ActionType.CopiedEvent;
                mce = (MovedCopiedEventType)bne;
                this.oldFolderId = mce.getOldFolderId();
                this.oldItemId = mce.getOldItemId();
                this.oldParentFolderId = mce.getOldParentFolderId();
                return;
            }
            if (actionStr.equals("CreatedEvent")) {
                this.action = ActionType.CreatedEvent;
                return;
            }
            if (actionStr.equals("DeletedEvent")) {
                this.action = ActionType.DeletedEvent;
                return;
            }
            if (actionStr.equals("ModifiedEvent")) {
                this.action = ActionType.ModifiedEvent;
                ModifiedEventType met = (ModifiedEventType)bne;
                this.unreadCount = met.getUnreadCount();
                return;
            }
            if (actionStr.equals("MovedEvent")) {
                this.action = ActionType.MovedEvent;
                mce = (MovedCopiedEventType)bne;
                this.oldFolderId = mce.getOldFolderId();
                this.oldItemId = mce.getOldItemId();
                this.oldParentFolderId = mce.getOldParentFolderId();
                return;
            }
            if (actionStr.equals("NewMailEvent")) {
                this.action = ActionType.NewMailEvent;
                return;
            }
        }

        public String getWatermark() {
            return this.watermark;
        }

        public ActionType getAction() {
            return this.action;
        }

        public FolderIdType getOldFolderId() {
            return this.oldFolderId;
        }

        public ItemIdType getOldItemId() {
            return this.oldItemId;
        }

        public FolderIdType getOldParentFolderId() {
            return this.oldParentFolderId;
        }

        public Integer getUnreadCount() {
            return this.unreadCount;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("NotificationItem{");
            sb.append("watermark=");
            sb.append(this.getWatermark());
            sb.append(",\n      action=");
            sb.append((Object)this.getAction());
            sb.append(", timeStamp=");
            sb.append(this.getTimeStamp());
            sb.append(",\n      folderId=");
            sb.append(this.getFolderId());
            sb.append(",\n      itemId=");
            sb.append(this.getItemId());
            sb.append(",\n      parentFolderId=");
            sb.append(this.getParentFolderId());
            if (this.getOldFolderId() != null) {
                sb.append(",\n      oldFolderId=");
                sb.append(this.getOldFolderId());
            }
            if (this.getOldItemId() != null) {
                sb.append(",\n       oldItemId=");
                sb.append(this.getOldItemId());
            }
            if (this.getOldParentFolderId() != null) {
                sb.append(",\n       oldParentFolderId=");
                sb.append(this.getOldParentFolderId());
            }
            if (this.getUnreadCount() != null) {
                sb.append(",\n       unreadCount=");
                sb.append(this.getUnreadCount());
            }
            sb.append("}");
            return sb.toString();
        }

        public static enum ActionType {
            CopiedEvent,
            CreatedEvent,
            DeletedEvent,
            ModifiedEvent,
            MovedEvent,
            NewMailEvent,
            StatusEvent;

        }
    }
}

