/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.synch.cnctrs.file;

import ietf.params.xml.ns.icalendar_2.IcalendarType;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.UnfoldingReader;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.util.CompatibilityHints;
import org.apache.http.client.utils.URIBuilder;
import org.bedework.synch.cnctrs.file.FileConnector;
import org.bedework.synch.cnctrs.file.FileConnectorConfig;
import org.bedework.synch.cnctrs.file.FileSubscriptionInfo;
import org.bedework.synch.shared.BaseSubscriptionInfo;
import org.bedework.synch.shared.Subscription;
import org.bedework.synch.shared.cnctrs.AbstractConnector;
import org.bedework.synch.shared.cnctrs.BaseConnectorInstance;
import org.bedework.synch.shared.conf.ConnectorConfigI;
import org.bedework.synch.shared.exception.SynchException;
import org.bedework.synch.wsmessages.SynchEndType;
import org.bedework.util.calendar.IcalToXcal;

public class FileConnectorInstance
extends BaseConnectorInstance<FileConnector, FileSubscriptionInfo, FileConnectorConfig> {
    FileConnectorInstance(FileConnectorConfig config, FileConnector cnctr, Subscription sub, SynchEndType end, FileSubscriptionInfo info) {
        super(sub, end, (BaseSubscriptionInfo)info, (AbstractConnector)cnctr, (ConnectorConfigI)config);
    }

    public boolean changed() throws SynchException {
        return this.changed(true, "calendar/text");
    }

    public URI getUri() throws SynchException {
        try {
            LocalDate yesterday = LocalDate.now().minus(1L, ChronoUnit.DAYS);
            String yesterdayStr = yesterday.format(DateTimeFormatter.ISO_LOCAL_DATE);
            URI infoUri = new URI(((FileSubscriptionInfo)this.info).getUri());
            return new URIBuilder().setScheme(infoUri.getScheme()).setHost(infoUri.getHost()).setPort(infoUri.getPort()).setPath(infoUri.getPath()).build();
        }
        catch (SynchException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new SynchException(t);
        }
    }

    public IcalendarType makeXcal(InputStream is) throws SynchException {
        try {
            CalendarBuilder builder = new CalendarBuilder();
            CompatibilityHints.setHintEnabled((String)"ical4j.unfolding.relaxed", (boolean)true);
            CompatibilityHints.setHintEnabled((String)"ical4j.parsing.relaxed", (boolean)true);
            UnfoldingReader ufrdr = new UnfoldingReader((Reader)new InputStreamReader(is), true);
            Calendar ical = builder.build(ufrdr);
            return IcalToXcal.fromIcal((Calendar)ical, null, (boolean)true);
        }
        catch (SynchException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new SynchException(t);
        }
    }

    public boolean getIcal() throws SynchException {
        return this.getIcal("text/calendar");
    }
}

