/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.synch.cnctrs.manager;

import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBElement;
import org.bedework.synch.SubscriptionConnectorInfoImpl;
import org.bedework.synch.SubscriptionInfoImpl;
import org.bedework.synch.cnctrs.manager.SynchConnectorInstance;
import org.bedework.synch.db.SubscriptionImpl;
import org.bedework.synch.shared.BaseSubscriptionInfo;
import org.bedework.synch.shared.Notification;
import org.bedework.synch.shared.Subscription;
import org.bedework.synch.shared.SubscriptionConnectorInfo;
import org.bedework.synch.shared.SynchDefs;
import org.bedework.synch.shared.SynchEngine;
import org.bedework.synch.shared.cnctrs.AbstractConnector;
import org.bedework.synch.shared.cnctrs.Connector;
import org.bedework.synch.shared.conf.ConnectorConfig;
import org.bedework.synch.shared.conf.ConnectorConfigI;
import org.bedework.synch.shared.exception.SynchException;
import org.bedework.synch.wsmessages.ActiveSubscriptionRequestType;
import org.bedework.synch.wsmessages.AlreadySubscribedType;
import org.bedework.synch.wsmessages.ArrayOfSynchConnectorInfo;
import org.bedework.synch.wsmessages.ArrayOfSynchProperties;
import org.bedework.synch.wsmessages.ArrayOfSynchPropertyInfo;
import org.bedework.synch.wsmessages.ConnectorInfoType;
import org.bedework.synch.wsmessages.GetInfoRequestType;
import org.bedework.synch.wsmessages.GetInfoResponseType;
import org.bedework.synch.wsmessages.SubscribeRequestType;
import org.bedework.synch.wsmessages.SubscribeResponseType;
import org.bedework.synch.wsmessages.SubscriptionStatusRequestType;
import org.bedework.synch.wsmessages.SubscriptionStatusResponseType;
import org.bedework.synch.wsmessages.SynchConnectorInfoType;
import org.bedework.synch.wsmessages.SynchEndType;
import org.bedework.synch.wsmessages.SynchInfoType;
import org.bedework.synch.wsmessages.SynchPropertyType;
import org.bedework.synch.wsmessages.UnknownSubscriptionType;
import org.bedework.synch.wsmessages.UnsubscribeRequestType;
import org.bedework.synch.wsmessages.UnsubscribeResponseType;
import org.oasis_open.docs.ws_calendar.ns.soap.ErrorResponseType;
import org.oasis_open.docs.ws_calendar.ns.soap.StatusType;

public class SynchConnector
extends AbstractConnector<SynchConnector, SynchConnectorInstance, Notification, ConnectorConfig, BaseSubscriptionInfo> {
    public SynchConnector() {
        super(null);
    }

    public void start(String connectorId, ConnectorConfig conf, String callbackUri, SynchEngine syncher) {
        super.start(connectorId, (ConnectorConfigI)conf, callbackUri, syncher);
        this.stopped = false;
        this.running = true;
    }

    public boolean isManager() {
        return true;
    }

    public SynchDefs.SynchKind getKind() {
        return SynchDefs.SynchKind.notify;
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean getTrustLastmod() {
        return false;
    }

    public SynchConnectorInstance makeInstance(Subscription sub, SynchEndType end) throws SynchException {
        return null;
    }

    public Connector.NotificationBatch handleCallback(HttpServletRequest req, HttpServletResponse resp, List<String> resourceUri) throws SynchException {
        try {
            if (resourceUri.size() > 0) {
                resp.setStatus(400);
                return null;
            }
            Object o = this.unmarshalBody(req);
            if (o instanceof GetInfoRequestType) {
                return new Connector.NotificationBatch(new Notification(Notification.NotificationItem.ActionType.GetInfo));
            }
            if (o instanceof SubscribeRequestType) {
                return new Connector.NotificationBatch(this.subscribe(resp, (SubscribeRequestType)o));
            }
            if (o instanceof UnsubscribeRequestType) {
                return new Connector.NotificationBatch(this.unsubscribe(resp, (UnsubscribeRequestType)o));
            }
            if (o instanceof SubscriptionStatusRequestType) {
                return new Connector.NotificationBatch(this.subStatus(resp, (SubscriptionStatusRequestType)o));
            }
            resp.setStatus(400);
            return null;
        }
        catch (SynchException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new SynchException(t);
        }
    }

    public void respondCallback(HttpServletResponse resp, Connector.NotificationBatch<Notification> notifications) throws SynchException {
        try {
            JAXBElement jax;
            if (notifications.getNotifications().size() != 1) {
                return;
            }
            Notification note = (Notification)notifications.getNotifications().get(0);
            if (note.getNotifications().size() != 1) {
                return;
            }
            Notification.NotificationItem ni = (Notification.NotificationItem)note.getNotifications().get(0);
            if (ni.getAction() == Notification.NotificationItem.ActionType.GetInfo) {
                GetInfoResponseType giresp = new GetInfoResponseType();
                SynchInfoType sit = new SynchInfoType();
                giresp.setInfo(sit);
                ArrayOfSynchConnectorInfo asci = new ArrayOfSynchConnectorInfo();
                sit.setConnectors(asci);
                for (String id : this.syncher.getConnectorIds()) {
                    Connector c = this.syncher.getConnector(id);
                    if (c == null) continue;
                    SynchConnectorInfoType scit = new SynchConnectorInfoType();
                    scit.setName(id);
                    scit.setManager(c.isManager());
                    scit.setReadOnly(c.isReadOnly());
                    ArrayOfSynchPropertyInfo aspi = new ArrayOfSynchPropertyInfo();
                    scit.setProperties(aspi);
                    c.getPropertyInfo().addAllToList(aspi.getProperty());
                    asci.getConnector().add(scit);
                }
                JAXBElement jax2 = this.of.createGetInfoResponse(giresp);
                this.marshal(jax2, (OutputStream)resp.getOutputStream());
                return;
            }
            if (ni.getAction() == Notification.NotificationItem.ActionType.NewSubscription) {
                SubscribeResponseType sresp = ni.getSubResponse();
                jax = this.of.createSubscribeResponse(sresp);
                this.marshal(jax, (OutputStream)resp.getOutputStream());
            }
            if (ni.getAction() == Notification.NotificationItem.ActionType.Unsubscribe) {
                UnsubscribeResponseType usresp = ni.getUnsubResponse();
                jax = this.of.createUnsubscribeResponse(usresp);
                this.marshal(jax, (OutputStream)resp.getOutputStream());
            }
            if (ni.getAction() == Notification.NotificationItem.ActionType.SubscriptionStatus) {
                SubscriptionStatusResponseType ssresp = ni.getSubStatusResponse();
                jax = this.of.createSubscriptionStatusResponse(ssresp);
                this.marshal(jax, (OutputStream)resp.getOutputStream());
            }
        }
        catch (SynchException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new SynchException(t);
        }
    }

    private Notification subscribe(HttpServletResponse resp, SubscribeRequestType sr) throws SynchException {
        SubscriptionImpl sub = new SubscriptionImpl(null);
        sub.setOwner(sr.getPrincipalHref());
        sub.setDirection(sr.getDirection());
        sub.setMaster(sr.getMaster());
        sub.setEndAConnectorInfo(this.makeConnInfo(sr.getEndAConnector()));
        sub.setEndBConnectorInfo(this.makeConnInfo(sr.getEndBConnector()));
        ArrayOfSynchProperties info = sr.getInfo();
        if (info != null) {
            SubscriptionInfoImpl sinfo = new SubscriptionInfoImpl();
            for (SynchPropertyType sp : info.getProperty()) {
                sinfo.setProperty(sp.getName(), sp.getValue());
            }
            sub.setInfo(sinfo);
        }
        if (this.debug()) {
            this.debug("Handle subscribe " + sub);
        }
        Subscription s = this.syncher.find((Subscription)sub);
        SubscribeResponseType sresp = this.of.createSubscribeResponseType();
        if (s != null) {
            sresp.setStatus(StatusType.ERROR);
            sresp.setErrorResponse(new ErrorResponseType());
            sresp.getErrorResponse().setError(this.of.createAlreadySubscribed(new AlreadySubscribedType()));
        } else {
            sresp.setStatus(StatusType.OK);
            sresp.setSubscriptionId(sub.getSubscriptionId());
        }
        return new Notification((Subscription)sub, sresp);
    }

    private Notification unsubscribe(HttpServletResponse resp, UnsubscribeRequestType u) throws SynchException {
        if (this.debug()) {
            this.debug("Handle unsubscribe " + u.getSubscriptionId());
        }
        UnsubscribeResponseType usr = this.of.createUnsubscribeResponseType();
        Subscription sub = this.checkAsr((ActiveSubscriptionRequestType)u);
        if (sub == null) {
            if (this.debug()) {
                this.warn("No subscription found for " + u.getSubscriptionId());
            }
            usr.setStatus(StatusType.ERROR);
            usr.setErrorResponse(new ErrorResponseType());
            usr.getErrorResponse().setError(this.of.createUnknownSubscription(new UnknownSubscriptionType()));
            return new Notification(null, u, usr);
        }
        return new Notification(sub, u, usr);
    }

    private Notification subStatus(HttpServletResponse resp, SubscriptionStatusRequestType ss) throws SynchException {
        if (this.debug()) {
            this.debug("Handle status " + ss.getSubscriptionId());
        }
        SubscriptionStatusResponseType ssr = this.of.createSubscriptionStatusResponseType();
        Subscription sub = this.checkAsr((ActiveSubscriptionRequestType)ss);
        if (sub == null) {
            ssr.setStatus(StatusType.NOT_FOUND);
            ssr.setErrorResponse(new ErrorResponseType());
            ssr.getErrorResponse().setError(this.of.createUnknownSubscription(new UnknownSubscriptionType()));
            return new Notification(null, ss, ssr);
        }
        return new Notification(sub, ss, ssr);
    }

    private Subscription checkAsr(ActiveSubscriptionRequestType asr) throws SynchException {
        Subscription sub = this.syncher.getSubscription(asr.getSubscriptionId());
        if (sub == null) {
            return null;
        }
        if (!sub.getOwner().equals(asr.getPrincipalHref())) {
            return null;
        }
        return sub;
    }

    private SubscriptionConnectorInfo makeConnInfo(ConnectorInfoType cinfo) throws SynchException {
        SubscriptionConnectorInfoImpl subCinfo = new SubscriptionConnectorInfoImpl();
        subCinfo.setConnectorId(cinfo.getConnectorId());
        if (cinfo.getProperties() == null) {
            return subCinfo;
        }
        for (SynchPropertyType sp : cinfo.getProperties().getProperty()) {
            subCinfo.setProperty(sp.getName(), sp.getValue());
        }
        return subCinfo;
    }
}

