/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.synch.cnctrs.orgSyncV2;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import ietf.params.xml.ns.icalendar_2.ArrayOfComponents;
import ietf.params.xml.ns.icalendar_2.ArrayOfParameters;
import ietf.params.xml.ns.icalendar_2.ArrayOfProperties;
import ietf.params.xml.ns.icalendar_2.CategoriesPropType;
import ietf.params.xml.ns.icalendar_2.CreatedPropType;
import ietf.params.xml.ns.icalendar_2.DateDatetimePropertyType;
import ietf.params.xml.ns.icalendar_2.DescriptionPropType;
import ietf.params.xml.ns.icalendar_2.DtendPropType;
import ietf.params.xml.ns.icalendar_2.DtstampPropType;
import ietf.params.xml.ns.icalendar_2.DtstartPropType;
import ietf.params.xml.ns.icalendar_2.IcalendarType;
import ietf.params.xml.ns.icalendar_2.LocationPropType;
import ietf.params.xml.ns.icalendar_2.ProdidPropType;
import ietf.params.xml.ns.icalendar_2.RdatePropType;
import ietf.params.xml.ns.icalendar_2.SummaryPropType;
import ietf.params.xml.ns.icalendar_2.UidPropType;
import ietf.params.xml.ns.icalendar_2.VcalendarType;
import ietf.params.xml.ns.icalendar_2.VersionPropType;
import ietf.params.xml.ns.icalendar_2.VeventType;
import ietf.params.xml.ns.icalendar_2.XBedeworkLocKeyParamType;
import java.io.InputStream;
import java.net.URI;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.http.client.utils.URIBuilder;
import org.bedework.synch.cnctrs.orgSyncV2.OrgSyncV2Connector;
import org.bedework.synch.cnctrs.orgSyncV2.OrgSyncV2ConnectorConfig;
import org.bedework.synch.cnctrs.orgSyncV2.OrgSyncV2Event;
import org.bedework.synch.cnctrs.orgSyncV2.OrgSyncV2Occurrence;
import org.bedework.synch.cnctrs.orgSyncV2.OrgSyncV2SubscriptionInfo;
import org.bedework.synch.shared.BaseSubscriptionInfo;
import org.bedework.synch.shared.Subscription;
import org.bedework.synch.shared.cnctrs.AbstractConnector;
import org.bedework.synch.shared.cnctrs.BaseConnectorInstance;
import org.bedework.synch.shared.conf.ConnectorConfigI;
import org.bedework.synch.shared.exception.SynchException;
import org.bedework.synch.wsmessages.SynchEndType;
import org.bedework.util.calendar.XcalUtil;
import org.bedework.util.misc.Util;

public class OrgSyncV2ConnectorInstance
extends BaseConnectorInstance<OrgSyncV2Connector, OrgSyncV2SubscriptionInfo, OrgSyncV2ConnectorConfig> {
    private final ObjectMapper om = new ObjectMapper();

    OrgSyncV2ConnectorInstance(OrgSyncV2ConnectorConfig config, OrgSyncV2Connector cnctr, Subscription sub, SynchEndType end, OrgSyncV2SubscriptionInfo info) {
        super(sub, end, (BaseSubscriptionInfo)info, (AbstractConnector)cnctr, (ConnectorConfigI)config);
    }

    public boolean changed() throws SynchException {
        return this.changed(false, "application/json");
    }

    public URI getUri() throws SynchException {
        try {
            LocalDate yesterday = LocalDate.now().minus(1L, ChronoUnit.DAYS);
            String yesterdayStr = yesterday.format(DateTimeFormatter.ISO_LOCAL_DATE);
            URI infoUri = new URI(((OrgSyncV2SubscriptionInfo)this.info).getUri());
            return new URIBuilder().setScheme(infoUri.getScheme()).setHost(infoUri.getHost()).setPort(infoUri.getPort()).setPath(infoUri.getPath()).setParameter("key", ((OrgSyncV2Connector)this.cnctr).getSyncher().decrypt(((OrgSyncV2SubscriptionInfo)this.info).getPassword())).setParameter("start_date", yesterdayStr).build();
        }
        catch (SynchException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new SynchException(t);
        }
    }

    public IcalendarType makeXcal(InputStream is) throws SynchException {
        try {
            List osEvents = (List)this.om.readValue(is, (TypeReference)new TypeReference<List<OrgSyncV2Event>>(){});
            return this.toXcal(osEvents, ((OrgSyncV2SubscriptionInfo)this.info).getOrgSyncPublicOnly());
        }
        catch (SynchException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new SynchException(t);
        }
    }

    public boolean getIcal() throws SynchException {
        return this.getIcal("application/json");
    }

    private IcalendarType toXcal(List<OrgSyncV2Event> osEvents, boolean onlyPublic) {
        IcalendarType ical = new IcalendarType();
        VcalendarType vcal = new VcalendarType();
        ical.getVcalendar().add(vcal);
        vcal.setProperties(new ArrayOfProperties());
        List vcalProps = vcal.getProperties().getBasePropertyOrTzid();
        VersionPropType vers = new VersionPropType();
        vers.setText("2.0");
        vcalProps.add(this.of.createVersion(vers));
        ProdidPropType prod = new ProdidPropType();
        prod.setText("//Bedework.org//BedeWork V3.11.1//EN");
        vcalProps.add(this.of.createProdid(prod));
        ArrayOfComponents aoc = new ArrayOfComponents();
        vcal.setComponents(aoc);
        for (OrgSyncV2Event osev : osEvents) {
            List evProps;
            block6: {
                if (onlyPublic && !osev.getIsPublic()) continue;
                VeventType ev = new VeventType();
                aoc.getBaseComponent().add(this.of.createVevent(ev));
                ev.setProperties(new ArrayOfProperties());
                evProps = ev.getProperties().getBasePropertyOrTzid();
                UidPropType uid = new UidPropType();
                uid.setText(((OrgSyncV2ConnectorConfig)this.config).getUidPrefix() + "-" + osev.getId());
                evProps.add(this.of.createUid(uid));
                DtstampPropType dtstamp = new DtstampPropType();
                try {
                    ZonedDateTime today = ZonedDateTime.now(ZoneOffset.UTC);
                    String todayStr = today.format(DateTimeFormatter.ISO_INSTANT);
                    dtstamp.setUtcDateTime(XcalUtil.getXMlUTCCal((String)todayStr));
                    evProps.add(this.of.createDtstamp(dtstamp));
                    CreatedPropType created = new CreatedPropType();
                    created.setUtcDateTime(XcalUtil.getXMlUTCCal((String)todayStr));
                    evProps.add(this.of.createCreated(created));
                    SummaryPropType sum = new SummaryPropType();
                    sum.setText(osev.getName());
                    evProps.add(this.of.createSummary(sum));
                    DescriptionPropType desc = new DescriptionPropType();
                    desc.setText(osev.getDescription());
                    evProps.add(this.of.createDescription(desc));
                    LocationPropType l = new LocationPropType();
                    l.setText(osev.getLocation());
                    evProps.add(this.of.createLocation(l));
                    if (((OrgSyncV2SubscriptionInfo)this.info).getLocationKey() == null) break block6;
                    XBedeworkLocKeyParamType par = this.of.createXBedeworkLocKeyParamType();
                    par.setText(((OrgSyncV2SubscriptionInfo)this.info).getLocationKey());
                    l.setParameters(new ArrayOfParameters());
                    l.getParameters().getBaseParameter().add(this.of.createXBedeworkLocKey(par));
                }
                catch (Throwable t) {
                    this.error(t);
                    continue;
                }
            }
            if (osev.getCategory() != null) {
                CategoriesPropType cat = new CategoriesPropType();
                cat.getText().add(osev.getCategory().getName());
                evProps.add(this.of.createCategories(cat));
            }
            if (Util.isEmpty(osev.getOccurrences())) continue;
            boolean first = true;
            for (OrgSyncV2Occurrence occ : osev.getOccurrences()) {
                if (first) {
                    DtstartPropType dtstart = (DtstartPropType)this.makeDt((DateDatetimePropertyType)new DtstartPropType(), occ.getStartsAt());
                    evProps.add(this.of.createDtstart(dtstart));
                    DtendPropType dtend = (DtendPropType)this.makeDt((DateDatetimePropertyType)new DtendPropType(), occ.getEndsAt());
                    evProps.add(this.of.createDtend(dtend));
                    first = false;
                    continue;
                }
                RdatePropType rdate = (RdatePropType)this.makeDt((DateDatetimePropertyType)new RdatePropType(), occ.getStartsAt());
                evProps.add(this.of.createRdate(rdate));
            }
        }
        return ical;
    }

    private DateDatetimePropertyType makeDt(DateDatetimePropertyType dt, String val) {
        try {
            DatatypeFactory dtf = DatatypeFactory.newInstance();
            XMLGregorianCalendar xgc = dtf.newXMLGregorianCalendar(val);
            if (val.length() == 10) {
                dt.setDate(xgc);
                return dt;
            }
            dt.setDateTime(xgc);
            return dt;
        }
        catch (DatatypeConfigurationException dce) {
            this.error(dce);
            return null;
        }
    }
}

