/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.synch.db;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import java.util.Properties;
import org.bedework.synch.shared.SerializableProperties;
import org.bedework.synch.shared.exception.SynchException;
import org.bedework.synch.wsmessages.ArrayOfSynchProperties;
import org.bedework.synch.wsmessages.SynchPropertyType;
import org.bedework.util.misc.ToString;
import org.bedework.util.misc.Util;

public abstract class SerializablePropertiesImpl<T>
implements SerializableProperties<T> {
    private String synchProperties;
    private Properties properties;
    private boolean changed;

    public SerializablePropertiesImpl() {
    }

    public SerializablePropertiesImpl(ArrayOfSynchProperties props) throws SynchException {
        if (props == null) {
            return;
        }
        for (SynchPropertyType prop : props.getProperty()) {
            this.setProperty(prop.getName(), prop.getValue());
        }
    }

    public ArrayOfSynchProperties getAllSynchProperties() throws SynchException {
        this.loadProperties();
        ArrayOfSynchProperties asp = new ArrayOfSynchProperties();
        List l = asp.getProperty();
        for (String s : this.properties.stringPropertyNames()) {
            SynchPropertyType prop = new SynchPropertyType();
            prop.setName(s);
            prop.setValue(this.properties.getProperty(s));
            l.add(prop);
        }
        return asp;
    }

    public void setSynchProperties(String val) {
        this.synchProperties = val;
    }

    public String getSynchProperties() throws SynchException {
        if (this.changed) {
            try {
                StringWriter wtr = new StringWriter();
                this.properties.store(wtr, null);
                this.synchProperties = ((Object)wtr).toString();
            }
            catch (Throwable t) {
                throw new SynchException(t);
            }
        }
        return this.synchProperties;
    }

    public void setChanged(boolean val) {
        this.changed = val;
    }

    public boolean getChanged() {
        return this.changed;
    }

    public void resetChanged() {
        if (!this.changed) {
            return;
        }
        this.properties = null;
        this.changed = false;
    }

    public synchronized void loadProperties() throws SynchException {
        try {
            if (this.properties == null) {
                this.properties = new Properties();
            }
            if (this.getSynchProperties() != null) {
                this.properties.load(new StringReader(this.getSynchProperties()));
            }
        }
        catch (Throwable t) {
            throw new SynchException(t);
        }
    }

    public void setProperty(String name, String val) throws SynchException {
        if (this.properties == null) {
            this.loadProperties();
        }
        if (val == null) {
            this.properties.remove(name);
        } else {
            this.properties.setProperty(name, val);
        }
        this.changed = true;
    }

    public synchronized String getProperty(String name) throws SynchException {
        if (this.properties == null) {
            this.loadProperties();
        }
        return this.properties.getProperty(name);
    }

    protected void toStringSegment(ToString ts) {
        try {
            if (this.getSynchProperties() != null) {
                ts.append("synchProperties", (Object)this.getSynchProperties());
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public int hashCode() {
        try {
            int res = 1;
            if (this.getSynchProperties() != null) {
                res *= this.getSynchProperties().hashCode();
            }
            return res;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public int doCompare(SerializablePropertiesImpl that) {
        if (this == that) {
            return 0;
        }
        try {
            return Util.compareStrings((String)this.getSynchProperties(), (String)that.getSynchProperties());
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public String toString() {
        try {
            ToString ts = new ToString((Object)this);
            this.toStringSegment(ts);
            return ts.toString();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

