/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.synch.db;

import java.util.Date;
import java.util.UUID;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.property.DtStamp;
import org.bedework.synch.db.DbItem;
import org.bedework.synch.shared.BaseSubscriptionInfo;
import org.bedework.synch.shared.Subscription;
import org.bedework.synch.shared.SubscriptionConnectorInfo;
import org.bedework.synch.shared.SubscriptionInfo;
import org.bedework.synch.shared.SynchDefs;
import org.bedework.synch.shared.cnctrs.Connector;
import org.bedework.synch.shared.cnctrs.ConnectorInstance;
import org.bedework.synch.shared.exception.SynchException;
import org.bedework.synch.wsmessages.SynchDirectionType;
import org.bedework.synch.wsmessages.SynchMasterType;
import org.bedework.util.misc.ToString;

public class SubscriptionImpl
extends DbItem<SubscriptionImpl>
implements Subscription {
    private String subscriptionId;
    private String owner;
    private String lastRefresh;
    private int errorCt;
    private boolean missingTarget;
    private SubscriptionConnectorInfo endAConnectorInfo;
    private SubscriptionConnectorInfo endBConnectorInfo;
    private SubscriptionInfo info;
    private SynchDirectionType direction;
    private SynchMasterType master;
    private Subscription outstandingSubscription;
    private boolean deleted;
    private Connector endAConn;
    private Connector endBConn;
    private ConnectorInstance endAConnInst;
    private ConnectorInstance endBConnInst;

    public SubscriptionImpl() {
    }

    public SubscriptionImpl(String subscriptionId) {
        this.subscriptionId = subscriptionId == null ? UUID.randomUUID().toString() : subscriptionId;
    }

    public void setSubscriptionId(String val) {
        this.subscriptionId = val;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setLastRefresh(String val) {
        this.lastRefresh = val;
    }

    public String getLastRefresh() {
        return this.lastRefresh;
    }

    public void setErrorCt(int val) {
        this.errorCt = val;
    }

    public int getErrorCt() {
        return this.errorCt;
    }

    public void setMissingTarget(boolean val) {
        this.missingTarget = val;
    }

    public boolean getMissingTarget() {
        return this.missingTarget;
    }

    public void setOwner(String val) {
        this.owner = val;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setEndAConnectorInfo(SubscriptionConnectorInfo val) {
        this.endAConnectorInfo = val;
    }

    public SubscriptionConnectorInfo getEndAConnectorInfo() {
        return this.endAConnectorInfo;
    }

    public void setEndBConnectorInfo(SubscriptionConnectorInfo val) {
        this.endBConnectorInfo = val;
    }

    public SubscriptionConnectorInfo getEndBConnectorInfo() {
        return this.endBConnectorInfo;
    }

    public void setInfo(SubscriptionInfo val) {
        this.info = val;
    }

    public SubscriptionInfo getInfo() {
        return this.info;
    }

    public void setDirection(SynchDirectionType val) {
        this.direction = val;
    }

    public SynchDirectionType getDirection() {
        return this.direction;
    }

    public void setMaster(SynchMasterType val) {
        this.master = val;
    }

    public SynchMasterType getMaster() {
        return this.master;
    }

    public void setOutstandingSubscription(Subscription val) {
        this.outstandingSubscription = val;
    }

    public Subscription getOutstandingSubscription() {
        return this.outstandingSubscription;
    }

    public void setDeleted(boolean val) {
        this.deleted = val;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public void setEndAConn(Connector val) {
        this.endAConn = val;
    }

    public Connector getEndAConn() {
        return this.endAConn;
    }

    public void setEndBConn(Connector val) {
        this.endBConn = val;
    }

    public Connector getEndBConn() {
        return this.endBConn;
    }

    public void setEndAConnInst(ConnectorInstance val) {
        this.endAConnInst = val;
    }

    public ConnectorInstance getEndAConnInst() {
        return this.endAConnInst;
    }

    public void setEndBConnInst(ConnectorInstance val) {
        this.endBConnInst = val;
    }

    public ConnectorInstance getEndBConnInst() {
        return this.endBConnInst;
    }

    public boolean changed() {
        return this.getEndAConnectorInfo().getChanged() || this.getEndBConnectorInfo().getChanged();
    }

    public synchronized void resetChanged() {
        if (!this.changed()) {
            return;
        }
        this.getEndAConnectorInfo().resetChanged();
        this.getEndBConnectorInfo().resetChanged();
    }

    public boolean polling() {
        if (this.getDirection() == SynchDirectionType.A_TO_B) {
            return this.getEndAConn().getKind() == SynchDefs.SynchKind.poll;
        }
        if (this.getDirection() == SynchDirectionType.B_TO_A) {
            return this.getEndBConn().getKind() == SynchDefs.SynchKind.poll;
        }
        return this.getEndAConn().getKind() == SynchDefs.SynchKind.poll || this.getEndBConn().getKind() == SynchDefs.SynchKind.poll;
    }

    public long refreshDelay() throws SynchException {
        String delay = "31536000000";
        delay = this.getDirection() == SynchDirectionType.A_TO_B ? new BaseSubscriptionInfo(this.getEndAConnectorInfo()).getRefreshDelay() : new BaseSubscriptionInfo(this.getEndBConnectorInfo()).getRefreshDelay();
        return Long.valueOf(delay);
    }

    public void updateLastRefresh() {
        this.setLastRefresh(new DtStamp(new DateTime(true)).getValue());
    }

    public Date nextRefresh() throws SynchException {
        if (this.getLastRefresh() == null) {
            return new Date();
        }
        try {
            Object dt = new DtStamp(this.getLastRefresh()).getDate();
            if (dt.before(new Date())) {
                dt = new Date();
            }
            return new Date(dt.getTime() + (long)(this.getErrorCt() + 1) * this.refreshDelay());
        }
        catch (Throwable t) {
            throw new SynchException(t);
        }
    }

    @Override
    protected ToString toStringSegment(ToString ts) {
        return super.toStringSegment(ts).newLine().append("subscriptionId", (Object)this.getSubscriptionId()).append("lastRefresh", (Object)this.getLastRefresh()).newLine().append("errorCt", this.getErrorCt()).append("missingTarget", this.getMissingTarget()).newLine().append("endAConnectorInfo", (Object)this.getEndAConnectorInfo()).newLine().append("endBConnectorInfo", (Object)this.getEndBConnectorInfo()).newLine().append("info", (Object)this.getInfo()).newLine().append("direction", (Object)this.getDirection()).append("master", (Object)this.getMaster());
    }

    @Override
    public int hashCode() {
        return this.getSubscriptionId().hashCode();
    }

    @Override
    public int compareTo(SubscriptionImpl that) {
        if (this == that) {
            return 0;
        }
        return this.getSubscriptionId().compareTo(that.getSubscriptionId());
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        this.toStringSegment(ts);
        if (this.getOutstandingSubscription() != null) {
            ts.append("OustandingSubscription", (Object)this.getOutstandingSubscription());
        }
        return ts.toString();
    }
}

