/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.synch.db;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;
import org.bedework.synch.conf.SynchConfig;
import org.bedework.synch.db.SubscriptionImpl;
import org.bedework.synch.shared.Subscription;
import org.bedework.synch.shared.exception.SynchException;
import org.bedework.util.hibernate.HibException;
import org.bedework.util.hibernate.HibSession;
import org.bedework.util.hibernate.HibSessionFactory;
import org.bedework.util.hibernate.HibSessionImpl;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;

public class SynchDb
implements Logged,
Serializable {
    private final SynchConfig config;
    protected boolean open;
    protected Timestamp objTimestamp;
    protected HibSession sess;
    private static final String getAllQuery = "from " + SubscriptionImpl.class.getName();
    private static final String getSubQuery = "from " + SubscriptionImpl.class.getName() + " sub where sub.subscriptionId=:subid";
    private static final String findSubQuery = "from " + SubscriptionImpl.class.getName() + " sub where sub.endAConnectorInfo.connectorId=:aconnid and sub.endAConnectorInfo.synchProperties=:aconnprops and sub.endBConnectorInfo.connectorId=:bconnid and sub.endBConnectorInfo.synchProperties=:bconnprops and sub.direction=:dir and sub.master=:mstr";
    private BwLogger logger = new BwLogger();

    public SynchDb(SynchConfig config) {
        this.config = config;
    }

    public boolean open() throws SynchException {
        if (this.isOpen()) {
            return false;
        }
        this.openSession();
        this.open = true;
        return true;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void close() throws SynchException {
        try {
            this.endTransaction();
        }
        catch (SynchException wde) {
            try {
                this.rollbackTransaction();
            }
            catch (SynchException synchException) {
                // empty catch block
            }
            throw wde;
        }
        finally {
            try {
                this.closeSession();
            }
            catch (SynchException synchException) {}
            this.open = false;
        }
    }

    public List<Subscription> getAll() throws SynchException {
        try {
            this.sess.createQuery(getAllQuery);
            return this.sess.getList();
        }
        catch (HibException he) {
            throw new SynchException((Throwable)he);
        }
    }

    public Subscription get(String id) throws SynchException {
        try {
            this.sess.createQuery(getSubQuery);
            this.sess.setString("subid", id);
            return (Subscription)this.sess.getUnique();
        }
        catch (HibException he) {
            throw new SynchException((Throwable)he);
        }
    }

    public Subscription find(Subscription sub) throws SynchException {
        try {
            this.sess.createQuery(findSubQuery);
            this.sess.setString("aconnid", sub.getEndAConnectorInfo().getConnectorId());
            this.sess.setString("aconnprops", sub.getEndAConnectorInfo().getSynchProperties());
            this.sess.setString("bconnid", sub.getEndBConnectorInfo().getConnectorId());
            this.sess.setString("bconnprops", sub.getEndBConnectorInfo().getSynchProperties());
            this.sess.setString("dir", sub.getDirection().name());
            this.sess.setString("mstr", sub.getMaster().name());
            return (Subscription)this.sess.getUnique();
        }
        catch (HibException he) {
            throw new SynchException((Throwable)he);
        }
    }

    public void add(Subscription sub) throws SynchException {
        try {
            this.sess.save((Object)sub);
        }
        catch (HibException he) {
            throw new SynchException((Throwable)he);
        }
    }

    public void update(Subscription sub) throws SynchException {
        try {
            this.sess.update((Object)sub);
        }
        catch (HibException he) {
            throw new SynchException((Throwable)he);
        }
    }

    public void delete(Subscription sub) throws SynchException {
        boolean opened = this.open();
        try {
            this.sess.delete((Object)sub);
        }
        catch (HibException he) {
            throw new SynchException((Throwable)he);
        }
        finally {
            if (opened) {
                this.close();
            }
        }
    }

    protected void checkOpen() throws SynchException {
        if (!this.isOpen()) {
            throw new SynchException("Session call when closed");
        }
    }

    protected synchronized void openSession() throws SynchException {
        if (this.isOpen()) {
            throw new SynchException("Already open");
        }
        this.open = true;
        if (this.sess != null) {
            this.warn("Session is not null. Will close");
            this.close();
        }
        if (this.sess == null) {
            if (this.debug()) {
                this.debug("New hibernate session for " + this.objTimestamp);
            }
            this.sess = new HibSessionImpl();
            try {
                this.sess.init(HibSessionFactory.getSessionFactory((List)this.config.getHibernateProperties()));
            }
            catch (HibException he) {
                throw new SynchException((Throwable)he);
            }
            this.debug("Open session for " + this.objTimestamp);
        }
        this.beginTransaction();
    }

    protected synchronized void closeSession() throws SynchException {
        if (!this.isOpen()) {
            if (this.debug()) {
                this.debug("Close for " + this.objTimestamp + " closed session");
            }
            return;
        }
        if (this.debug()) {
            this.debug("Close for " + this.objTimestamp);
        }
        try {
            if (this.sess != null) {
                if (this.sess.rolledback()) {
                    this.sess = null;
                    return;
                }
                if (this.sess.transactionStarted()) {
                    this.sess.rollback();
                }
                this.sess.close();
                this.sess = null;
            }
        }
        catch (Throwable t) {
            try {
                this.sess.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.sess = null;
        }
        finally {
            this.open = false;
        }
    }

    protected void beginTransaction() throws SynchException {
        this.checkOpen();
        if (this.debug()) {
            this.debug("Begin transaction for " + this.objTimestamp);
        }
        try {
            this.sess.beginTransaction();
        }
        catch (HibException he) {
            throw new SynchException((Throwable)he);
        }
    }

    protected void endTransaction() throws SynchException {
        this.checkOpen();
        if (this.debug()) {
            this.debug("End transaction for " + this.objTimestamp);
        }
        try {
            if (!this.sess.rolledback()) {
                this.sess.commit();
            }
        }
        catch (HibException he) {
            throw new SynchException((Throwable)he);
        }
    }

    protected void rollbackTransaction() throws SynchException {
        try {
            this.checkOpen();
            this.sess.rollback();
        }
        catch (HibException he) {
            throw new SynchException((Throwable)he);
        }
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }
}

