/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.synch.filters;

import ietf.params.xml.ns.icalendar_2.ArrayOfComponents;
import ietf.params.xml.ns.icalendar_2.ArrayOfProperties;
import ietf.params.xml.ns.icalendar_2.BaseComponentType;
import ietf.params.xml.ns.icalendar_2.BasePropertyType;
import ietf.params.xml.ns.icalendar_2.IcalendarType;
import ietf.params.xml.ns.icalendar_2.VcalendarType;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.bedework.synch.shared.exception.SynchException;
import org.bedework.synch.shared.filters.AbstractFilter;

public abstract class PropRenameFilter
extends AbstractFilter {
    protected abstract List<RenameElement> getRenameList();

    protected abstract BasePropertyType getNewProperty(RenameElement var1, JAXBElement<? extends BasePropertyType> var2);

    public IcalendarType doFilter(IcalendarType val) throws SynchException {
        for (VcalendarType vcal : val.getVcalendar()) {
            this.doRename((BaseComponentType)vcal);
        }
        return val;
    }

    private void doRename(BaseComponentType val) throws SynchException {
        try {
            ArrayOfComponents comps = val.getComponents();
            if (comps == null) {
                return;
            }
            for (JAXBElement jaxbCcomp : comps.getBaseComponent()) {
                BaseComponentType jcomp = (BaseComponentType)jaxbCcomp.getValue();
                this.doRenameProps(jcomp);
            }
        }
        catch (SynchException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new SynchException(t);
        }
    }

    private void doRenameProps(BaseComponentType val) throws SynchException {
        ArrayOfProperties props = val.getProperties();
        if (props == null) {
            return;
        }
        ArrayList<JAXBElement> renameProps = new ArrayList<JAXBElement>();
        int i = 0;
        List jprops = props.getBasePropertyOrTzid();
        block0: while (i < jprops.size()) {
            JAXBElement jprop = (JAXBElement)jprops.get(i);
            for (RenameElement rl : this.getRenameList()) {
                if (!jprop.getName().equals(rl.getFrom())) continue;
                renameProps.add(jprop);
                jprops.remove(i);
                continue block0;
            }
            ++i;
        }
        block2: for (JAXBElement el : renameProps) {
            for (RenameElement rl : this.getRenameList()) {
                if (!el.getName().equals(rl.getFrom())) continue;
                jprops.add(new JAXBElement(rl.getTo(), rl.getToClass(), el.getScope(), (Object)this.getNewProperty(rl, (JAXBElement<? extends BasePropertyType>)el)));
                continue block2;
            }
        }
        this.doRename(val);
    }

    protected static class RenameElement {
        private final QName from;
        private final QName to;
        private final Class<? extends BasePropertyType> toClass;

        public RenameElement(QName from, QName to, Class<? extends BasePropertyType> toClass) {
            this.from = from;
            this.to = to;
            this.toClass = toClass;
        }

        public QName getFrom() {
            return this.from;
        }

        public QName getTo() {
            return this.to;
        }

        public Class<? extends BasePropertyType> getToClass() {
            return this.toClass;
        }
    }
}

