/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.synch.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.management.ObjectName;
import org.bedework.synch.SynchEngineImpl;
import org.bedework.synch.conf.SynchConfig;
import org.bedework.synch.service.SynchConfMBean;
import org.bedework.synch.shared.Stat;
import org.bedework.synch.shared.SynchEngine;
import org.bedework.synch.shared.conf.ConnectorConfig;
import org.bedework.synch.shared.service.SynchConnConf;
import org.bedework.util.config.ConfigurationStore;
import org.bedework.util.config.HibernateConfigBase;
import org.bedework.util.hibernate.HibConfig;
import org.bedework.util.hibernate.SchemaThread;
import org.bedework.util.jmx.ConfBase;
import org.bedework.util.jmx.ConfigHolder;
import org.bedework.util.jmx.InfoLines;
import org.hibernate.cfg.Configuration;

public class SynchConf
extends ConfBase<SynchConfig>
implements SynchConfMBean,
ConfigHolder<SynchConfig> {
    private static final String confuriPname = "org.bedework.synch.confuri";
    List<String> connectorNames;
    private boolean running;
    private SynchEngine syncher;
    private boolean export;
    private String schemaOutFile;
    private Configuration hibCfg;
    private SchemaBuilder buildSchema;
    private ProcessorThread processor;

    public SynchConf() {
        super("org.bedework.synch:service=SynchConf");
        this.setConfigPname(confuriPname);
        this.setPathSuffix("conf");
        SynchEngineImpl.setConfigHolder(this);
    }

    @Override
    public void setExport(boolean val) {
        this.export = val;
    }

    @Override
    public boolean getExport() {
        return this.export;
    }

    @Override
    public void setSchemaOutFile(String val) {
        this.schemaOutFile = val;
    }

    @Override
    public String getSchemaOutFile() {
        return this.schemaOutFile;
    }

    @Override
    public void setSynchlingPoolSize(int val) {
        this.getConfig().setSynchlingPoolSize(val);
    }

    @Override
    public int getSynchlingPoolSize() {
        return this.getConfig().getSynchlingPoolSize();
    }

    @Override
    public void setSynchlingPoolTimeout(long val) {
        this.getConfig().setSynchlingPoolTimeout(val);
    }

    @Override
    public long getSynchlingPoolTimeout() {
        return this.getConfig().getSynchlingPoolTimeout();
    }

    @Override
    public void setMissingTargetRetries(int val) {
        this.getConfig().setMissingTargetRetries(val);
    }

    @Override
    public int getMissingTargetRetries() {
        return this.getConfig().getMissingTargetRetries();
    }

    @Override
    public void setCallbackURI(String val) {
        this.getConfig().setCallbackURI(val);
    }

    @Override
    public String getCallbackURI() {
        return this.getConfig().getCallbackURI();
    }

    @Override
    public void setTimezonesURI(String val) {
        this.getConfig().setTimezonesURI(val);
    }

    @Override
    public String getTimezonesURI() {
        return this.getConfig().getTimezonesURI();
    }

    @Override
    public void setKeystore(String val) {
        this.getConfig().setKeystore(val);
    }

    @Override
    public String getKeystore() {
        return this.getConfig().getKeystore();
    }

    @Override
    public void setPrivKeys(String val) {
        this.getConfig().setPrivKeys(val);
    }

    @Override
    public String getPrivKeys() {
        return this.getConfig().getPrivKeys();
    }

    @Override
    public void setPubKeys(String val) {
        this.getConfig().setPubKeys(val);
    }

    @Override
    public String getPubKeys() {
        return this.getConfig().getPubKeys();
    }

    @Override
    public List<String> getConnectorNames() {
        return this.connectorNames;
    }

    @Override
    public void setSubscriptionsOnly(boolean val) {
        this.getConfig().setSubscriptionsOnly(val);
    }

    @Override
    public boolean getSubscriptionsOnly() {
        return this.getConfig().getSubscriptionsOnly();
    }

    @Override
    public List<Stat> getStats() {
        if (this.syncher == null) {
            return new ArrayList<Stat>();
        }
        return this.syncher.getStats();
    }

    @Override
    public String schema() {
        try {
            HibConfig hc = new HibConfig((HibernateConfigBase)this.getConfig());
            this.buildSchema = new SchemaBuilder(this.getSchemaOutFile(), this.getExport(), hc.getHibConfiguration().getProperties());
            this.setStatus("Stopped");
            this.buildSchema.start();
            return "OK";
        }
        catch (Throwable t) {
            this.error(t);
            return "Exception: " + t.getLocalizedMessage();
        }
    }

    @Override
    public synchronized List<String> schemaStatus() {
        if (this.buildSchema == null) {
            InfoLines infoLines = new InfoLines();
            infoLines.addLn("Schema build has not been started");
            return infoLines;
        }
        return this.buildSchema.infoLines;
    }

    @Override
    public String rescheduleNow(String id) {
        try {
            this.syncher.rescheduleNow(id);
            return "ok";
        }
        catch (Throwable t) {
            this.error(t);
            return "error";
        }
    }

    @Override
    public void setHibernateDialect(String value) {
        this.getConfig().setHibernateDialect(value);
    }

    @Override
    public String getHibernateDialect() {
        return this.getConfig().getHibernateDialect();
    }

    @Override
    public String listHibernateProperties() {
        StringBuilder res = new StringBuilder();
        List ps = this.getConfig().getHibernateProperties();
        for (String p : ps) {
            res.append(p);
            res.append("\n");
        }
        return res.toString();
    }

    @Override
    public String displayHibernateProperty(String name) {
        String val = this.getConfig().getHibernateProperty(name);
        if (val != null) {
            return val;
        }
        return "Not found";
    }

    @Override
    public void removeHibernateProperty(String name) {
        this.getConfig().removeHibernateProperty(name);
    }

    @Override
    public void addHibernateProperty(String name, String value) {
        this.getConfig().addHibernateProperty(name, value);
    }

    @Override
    public void setHibernateProperty(String name, String value) {
        this.getConfig().setHibernateProperty(name, value);
    }

    @Override
    public void start() {
        if (this.processor != null) {
            this.error("Already started");
            return;
        }
        this.info("************************************************************");
        this.info(" * Starting syncher");
        this.info("************************************************************");
        this.running = true;
        this.processor = new ProcessorThread(this.getServiceName());
        this.processor.start();
    }

    @Override
    public void stop() {
        if (this.processor == null) {
            this.error("Already stopped");
            return;
        }
        this.info("************************************************************");
        this.info(" * Stopping syncher");
        this.info("************************************************************");
        this.running = false;
        this.syncher.stop();
        this.processor.interrupt();
        try {
            this.processor.join(20000L);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Throwable t) {
            this.error("Error waiting for processor termination");
            this.error(t);
        }
        this.processor = null;
        this.syncher = null;
        this.info("************************************************************");
        this.info(" * Syncher terminated");
        this.info("************************************************************");
    }

    @Override
    public boolean isStarted() {
        return true;
    }

    @Override
    public String loadConfig() {
        try {
            String res = this.loadOnlyConfig(SynchConfig.class);
            if (res != null) {
                return res;
            }
            ConfigurationStore cs = this.getStore().getStore("connectors");
            this.connectorNames = cs.getConfigs();
            ArrayList<SynchConnConf> sccs = new ArrayList<SynchConnConf>();
            ((SynchConfig)this.cfg).setConnectorConfs(sccs);
            for (String cn : this.connectorNames) {
                SynchConnConf scc;
                ObjectName objectName = this.createObjectName("connector", cn);
                ConnectorConfig connCfg = (ConnectorConfig)cs.getConfig(cn);
                if (connCfg == null) {
                    this.error("Unable to read connector configuration " + cn);
                    continue;
                }
                String mbeanClassName = connCfg.getMbeanClassName();
                if (connCfg.getMbeanClassName() == null) {
                    this.error("Must set the mbean class name for connector " + cn);
                    this.error("Falling back to base class for " + cn);
                    mbeanClassName = SynchConnConf.class.getCanonicalName();
                }
                if ((scc = (SynchConnConf)SynchConf.makeObject((String)mbeanClassName)) == null) {
                    this.error("Unable to create mbean class: " + mbeanClassName);
                    this.error("Skipping");
                    continue;
                }
                scc.init(cs, objectName.toString(), connCfg);
                sccs.add(scc);
                this.register("connector", cn, scc);
            }
            return "OK";
        }
        catch (Throwable t) {
            this.error("Failed to start management context: " + t.getLocalizedMessage());
            this.error(t);
            return "failed";
        }
    }

    public SynchConfig getConfig() {
        return (SynchConfig)this.cfg;
    }

    public void putConfig() {
        this.saveConfig();
    }

    private class ProcessorThread
    extends Thread {
        boolean showedTrace;

        public ProcessorThread(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (SynchConf.this.running) {
                try {
                    if (SynchConf.this.syncher == null) {
                        SynchConf.this.syncher = SynchEngineImpl.getSyncher();
                        SynchConf.this.syncher.start();
                    }
                }
                catch (Throwable t) {
                    if (!this.showedTrace) {
                        SynchConf.this.error(t);
                        this.showedTrace = true;
                    }
                    SynchConf.this.error(t.getMessage());
                }
                if (!SynchConf.this.running) continue;
                try {
                    Object o;
                    Object object = o = new Object();
                    synchronized (object) {
                        o.wait(10000L);
                    }
                }
                catch (Throwable t) {
                    SynchConf.this.error(t.getMessage());
                }
            }
        }
    }

    private class SchemaBuilder
    extends SchemaThread {
        SchemaBuilder(String outFile, boolean export, Properties hibConfig) {
            super(outFile, export, hibConfig);
        }

        public void completed(String status) {
            if (status.equals("Done")) {
                SynchConf.this.setStatus("Done");
            } else {
                SynchConf.this.setStatus("Failed");
            }
            SynchConf.this.setExport(false);
            SynchConf.this.info("Schema build completed with status " + status);
        }
    }
}

