/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.synch.shared;

import java.util.List;
import org.bedework.synch.shared.SubscriptionConnectorInfo;
import org.bedework.synch.shared.exception.SynchException;
import org.bedework.util.misc.ToString;
import org.bedework.util.misc.Util;

public class BaseSubscriptionInfo {
    private final SubscriptionConnectorInfo info;
    public static final String propnameUri = "uri";
    public static final String propnameChangeToken = "ctoken";
    public static final String propnameOpaqueData = "opaque-data";
    public static final String propnamePrincipal = "principal";
    public static final String propnamePassword = "password";
    public static final String propnameRefreshDelay = "refreshDelay";
    public static final String propnameOrgSyncPublicOnly = "orgsync-publicOnly";
    public static final String propnameLocKey = "locKey";
    public static final String propnameLastRefreshStatus = "last-refresh-status";
    public static final String propnameLastCrudCts = "lastCrudCt";
    public static final String propnameTotalCrudCts = "totalCrudCt";
    public static final String propnameInputFilterClasses = "inFilterClasses";
    public static final String propnameOutputFilterClasses = "outFilterClasses";

    public BaseSubscriptionInfo(SubscriptionConnectorInfo info) throws SynchException {
        this.info = info;
        info.loadProperties();
    }

    public void setUri(String val) throws SynchException {
        this.info.setProperty(propnameUri, val);
    }

    public String getUri() throws SynchException {
        return this.info.getProperty(propnameUri);
    }

    public void setPrincipalHref(String val) throws SynchException {
        this.info.setProperty(propnamePrincipal, val);
    }

    public String getPrincipalHref() throws SynchException {
        return this.info.getProperty(propnamePrincipal);
    }

    public void setPassword(String val) throws SynchException {
        this.info.setProperty(propnamePassword, val);
    }

    public String getPassword() throws SynchException {
        return this.info.getProperty(propnamePassword);
    }

    public void setOpaqueData(String val) throws SynchException {
        this.info.setProperty(propnameOpaqueData, val);
    }

    public String getOpaqueData() throws SynchException {
        return this.info.getProperty(propnameOpaqueData);
    }

    public void setChangeToken(String val) throws SynchException {
        this.info.setProperty(propnameChangeToken, val);
    }

    public String getChangeToken() throws SynchException {
        return this.info.getProperty(propnameChangeToken);
    }

    public void setLastRefreshStatus(String val) throws SynchException {
        this.info.setProperty(propnameLastRefreshStatus, val);
    }

    public String getLastRefreshStatus() throws SynchException {
        return this.info.getProperty(propnameLastRefreshStatus);
    }

    public void setLastCrudCts(CrudCts val) throws SynchException {
        this.info.setProperty(propnameLastCrudCts, val.toString());
    }

    public CrudCts getLastCrudCts() throws SynchException {
        String s = this.info.getProperty(propnameLastCrudCts);
        CrudCts cc = CrudCts.fromString(s);
        if (s == null) {
            this.setLastCrudCts(cc);
        }
        return cc;
    }

    public void setTotalCrudCts(CrudCts val) throws SynchException {
        this.info.setProperty(propnameTotalCrudCts, val.toString());
    }

    public CrudCts getTotalCrudCts() throws SynchException {
        String s = this.info.getProperty(propnameTotalCrudCts);
        CrudCts cc = CrudCts.fromString(s);
        if (s == null) {
            this.setTotalCrudCts(cc);
        }
        return cc;
    }

    public void setRefreshDelay(String val) throws SynchException {
        this.info.setProperty(propnameRefreshDelay, val);
    }

    public String getRefreshDelay() throws SynchException {
        return this.info.getProperty(propnameRefreshDelay);
    }

    public void setProperty(String name, String val) throws SynchException {
        this.info.setProperty(name, val);
    }

    public String getProperty(String name) throws SynchException {
        return this.info.getProperty(name);
    }

    public void setInFilterClasses(List<String> classes) throws SynchException {
        this.info.setProperty(propnameInputFilterClasses, this.asString(classes));
    }

    public List<String> getInFilterClasses() throws SynchException {
        try {
            return Util.getList((String)this.info.getProperty(propnameInputFilterClasses), (boolean)false);
        }
        catch (Throwable t) {
            throw new SynchException(t);
        }
    }

    public void setOutFilterClasses(List<String> classes) throws SynchException {
        this.info.setProperty(propnameOutputFilterClasses, this.asString(classes));
    }

    public List<String> getOutFilterClasses() throws SynchException {
        try {
            return Util.getList((String)this.info.getProperty(propnameOutputFilterClasses), (boolean)false);
        }
        catch (Throwable t) {
            throw new SynchException(t);
        }
    }

    private String asString(List<String> vals) {
        StringBuilder sb = new StringBuilder();
        String delim = "";
        for (String s : vals) {
            sb.append(delim);
            sb.append(s);
            delim = ",";
        }
        return sb.toString();
    }

    protected void toStringSegment(ToString ts) {
        try {
            ts.append(propnameUri, (Object)this.getUri());
            ts.newLine();
            ts.append("principalHref", (Object)this.getPrincipalHref());
            ts.append(propnamePassword, (Object)this.getPassword());
            ts.append("etag", (Object)this.getChangeToken());
            ts.newLine();
            ts.append("lastRefreshStatus", (Object)this.getLastRefreshStatus());
            ts.newLine();
            ts.append("lastCrudCts", (Object)this.getLastCrudCts());
            ts.append("totalCrudCts", (Object)this.getTotalCrudCts());
            ts.append(propnameRefreshDelay, (Object)this.getRefreshDelay());
        }
        catch (Throwable t) {
            ts.append(t.getMessage());
        }
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        this.toStringSegment(ts);
        return ts.toString();
    }

    public static class CrudCts {
        public long created;
        public long updated;
        public long deleted;

        public static CrudCts fromString(String val) {
            CrudCts cc = new CrudCts();
            if (val == null) {
                return cc;
            }
            String[] cts = val.split(",");
            if (cts.length != 3) {
                return cc;
            }
            try {
                cc.created = Long.valueOf(cts[0]);
                cc.updated = Long.valueOf(cts[1]);
                cc.deleted = Long.valueOf(cts[2]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return cc;
        }

        public String toString() {
            return String.valueOf(this.created) + "," + this.deleted + "," + this.updated;
        }
    }
}

