/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.synch.shared;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.bedework.synch.shared.BaseSubscriptionInfo;
import org.bedework.synch.shared.SynchPropertyInfo;
import org.bedework.synch.shared.exception.SynchException;
import org.bedework.synch.wsmessages.ArrayOfSynchProperties;
import org.bedework.synch.wsmessages.SynchPropertyInfoType;
import org.bedework.synch.wsmessages.SynchPropertyType;
import org.bedework.util.misc.ToString;

public class PropertiesInfo {
    private List<SynchPropertyInfo> propInfo = new ArrayList<SynchPropertyInfo>();

    public void requiredUri(String description) {
        this.prop("uri", SynchPropertyInfo.typeUri, description, true);
    }

    public void optionalUri(String description) {
        this.prop("uri", SynchPropertyInfo.typeUri, description, false);
    }

    public void requiredPrincipal(String description) {
        this.prop("principal", SynchPropertyInfo.typeString, description, true);
    }

    public void optionalPrincipal(String description) {
        this.prop("principal", SynchPropertyInfo.typeString, description, false);
    }

    public void requiredPassword(String description) {
        this.prop("password", SynchPropertyInfo.typePassword, description, true);
    }

    public void optionalPassword(String description) {
        this.prop("password", SynchPropertyInfo.typePassword, description, false);
    }

    public void add(String name, boolean secure, String type, String description, boolean required) {
        this.propInfo.add(new SynchPropertyInfo(name, secure, type, description, required));
    }

    public void add(String name, boolean secure, String type, String description, boolean required, String value) {
        this.propInfo.add(new SynchPropertyInfo(name, secure, type, description, required, value));
    }

    public void optionCalProcessing(String name, String description) {
        this.propInfo.add(new SynchPropertyInfo(name, false, SynchPropertyInfo.typeCalProcessing, description, false));
    }

    public void optionCalProcessing(String name, String description, String value) {
        this.propInfo.add(new SynchPropertyInfo(name, false, SynchPropertyInfo.typeCalProcessing, description, false, value));
    }

    public boolean validSubscribeInfoProperties(BaseSubscriptionInfo info) throws SynchException {
        for (SynchPropertyInfo spi : this.propInfo) {
            if (!spi.isRequired() || info.getProperty(spi.getName()) != null) continue;
            return false;
        }
        return true;
    }

    public boolean validRequestProperties(BaseSubscriptionInfo info, ArrayOfSynchProperties propsArray) throws SynchException {
        Properties props = new Properties();
        if (propsArray != null) {
            for (SynchPropertyType prop : propsArray.getProperty()) {
                props.setProperty(prop.getName(), prop.getValue());
            }
        }
        for (SynchPropertyInfo spi : this.propInfo) {
            String unsubVal;
            String propName;
            String subVal;
            if (!spi.isRequired() || (subVal = info.getProperty(propName = spi.getName())) == null || (unsubVal = props.getProperty(propName)) != null && unsubVal.equals(subVal)) continue;
            return false;
        }
        return true;
    }

    public void addAllToList(List<SynchPropertyInfoType> l) {
        l.addAll(this.propInfo);
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        ts.append("propInfo", this.propInfo);
        return ts.toString();
    }

    private void prop(String name, String type, String description, boolean required) {
        String desc = description;
        if (desc == null) {
            desc = "A valid principal - usually of current user";
        }
        this.add(name, false, type, desc, required);
    }
}

