/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.synch.shared.cnctrs;

import ietf.params.xml.ns.icalendar_2.ObjectFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPMessage;
import org.bedework.synch.shared.BaseSubscriptionInfo;
import org.bedework.synch.shared.Notification;
import org.bedework.synch.shared.PropertiesInfo;
import org.bedework.synch.shared.Subscription;
import org.bedework.synch.shared.SynchEngine;
import org.bedework.synch.shared.cnctrs.AbstractConnectorInstance;
import org.bedework.synch.shared.cnctrs.Connector;
import org.bedework.synch.shared.cnctrs.ConnectorInstanceMap;
import org.bedework.synch.shared.conf.ConnectorConfigI;
import org.bedework.synch.shared.exception.SynchException;
import org.bedework.synch.wsmessages.SynchEndType;
import org.bedework.synch.wsmessages.SynchRemoteService;
import org.bedework.synch.wsmessages.SynchRemoteServicePortType;
import org.bedework.util.misc.Logged;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class AbstractConnector<T, TI extends AbstractConnectorInstance, TN extends Notification, Tconf extends ConnectorConfigI, InfoT extends BaseSubscriptionInfo>
extends Logged
implements Connector<TI, TN, Tconf> {
    protected Tconf config;
    protected String callbackUri;
    private String connectorId;
    private static final ObjectFactory icalOf = new ObjectFactory();
    protected SynchEngine syncher;
    protected boolean running;
    protected boolean stopped;
    protected boolean failed;
    protected org.bedework.synch.wsmessages.ObjectFactory of = new org.bedework.synch.wsmessages.ObjectFactory();
    protected MessageFactory soapMsgFactory;
    protected JAXBContext jc;
    protected PropertiesInfo propInfo;
    private final ConnectorInstanceMap<TI> cinstMap = new ConnectorInstanceMap();

    protected AbstractConnector(PropertiesInfo propInfo) {
        this.propInfo = propInfo == null ? new PropertiesInfo() : propInfo;
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    @Override
    public void start(String connectorId, Tconf conf, String callbackUri, SynchEngine syncher) {
        this.connectorId = connectorId;
        this.syncher = syncher;
        this.callbackUri = callbackUri;
        this.config = conf;
        this.stopped = false;
        this.running = true;
    }

    @Override
    public String getStatus() {
        StringBuilder sb = new StringBuilder();
        if (this.isManager()) {
            sb.append("(Manager): ");
        }
        if (this.isStarted()) {
            sb.append("Started: ");
        }
        if (this.isFailed()) {
            sb.append("Failed: ");
        }
        if (this.isStopped()) {
            sb.append("Stopped: ");
        }
        return sb.toString();
    }

    @Override
    public boolean isStarted() {
        return this.running;
    }

    @Override
    public boolean isFailed() {
        return this.failed;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public boolean isManager() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return this.config.getReadOnly();
    }

    @Override
    public boolean getTrustLastmod() {
        return this.config.getTrustLastmod();
    }

    @Override
    public String getId() {
        return this.connectorId;
    }

    @Override
    public String getCallbackUri() {
        return this.callbackUri;
    }

    @Override
    public SynchEngine getSyncher() {
        return this.syncher;
    }

    @Override
    public ObjectFactory getIcalObjectFactory() {
        return icalOf;
    }

    @Override
    public PropertiesInfo getPropertyInfo() {
        return this.propInfo;
    }

    @Override
    public List<Object> getSkipList() {
        return null;
    }

    @Override
    public void stop() throws SynchException {
        this.running = false;
    }

    public abstract TI makeInstance(Subscription var1, SynchEndType var2) throws SynchException;

    @Override
    public TI getConnectorInstance(Subscription sub, SynchEndType end) throws SynchException {
        if (!this.running) {
            return null;
        }
        AbstractConnectorInstance inst = (AbstractConnectorInstance)this.cinstMap.find(sub, end);
        if (inst != null) {
            return (TI)inst;
        }
        inst = this.makeInstance(sub, end);
        this.cinstMap.add(sub, end, inst);
        return (TI)inst;
    }

    @Override
    public Connector.NotificationBatch<TN> handleCallback(HttpServletRequest req, HttpServletResponse resp, List<String> resourceUri) throws SynchException {
        return null;
    }

    @Override
    public void respondCallback(HttpServletResponse resp, Connector.NotificationBatch<TN> notifications) throws SynchException {
    }

    protected SynchRemoteServicePortType getPort(String uri) throws SynchException {
        try {
            URL wsURL = new URL(uri);
            SynchRemoteService ers = new SynchRemoteService(wsURL, new QName("http://www.bedework.org/synch/wsmessages", "SynchRemoteService"));
            SynchRemoteServicePortType port = ers.getSynchRSPort();
            return port;
        }
        catch (Throwable t) {
            throw new SynchException(t);
        }
    }

    protected Object unmarshalBody(HttpServletRequest req) throws SynchException {
        try {
            SOAPMessage msg = this.getSoapMsgFactory().createMessage(null, (InputStream)req.getInputStream());
            SOAPBody body = msg.getSOAPBody();
            Unmarshaller u = this.getSynchJAXBContext().createUnmarshaller();
            Object o = u.unmarshal(body.getFirstChild());
            if (o instanceof JAXBElement) {
                o = ((JAXBElement)o).getValue();
            }
            return o;
        }
        catch (SynchException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new SynchException(t);
        }
    }

    protected void marshal(Object o, OutputStream out) throws SynchException {
        try {
            Marshaller marshaller = this.jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document doc = dbf.newDocumentBuilder().newDocument();
            SOAPMessage msg = this.soapMsgFactory.createMessage();
            msg.getSOAPBody().addDocument(doc);
            marshaller.marshal(o, (Node)msg.getSOAPBody());
            msg.writeTo(out);
        }
        catch (Throwable t) {
            throw new SynchException(t);
        }
    }

    protected MessageFactory getSoapMsgFactory() throws SynchException {
        try {
            if (this.soapMsgFactory == null) {
                this.soapMsgFactory = MessageFactory.newInstance();
            }
            return this.soapMsgFactory;
        }
        catch (Throwable t) {
            throw new SynchException(t);
        }
    }

    JAXBContext getSynchJAXBContext() throws SynchException {
        try {
            if (this.jc == null) {
                this.jc = JAXBContext.newInstance((String)"org.bedework.synch.wsmessages:ietf.params.xml.ns.icalendar_2");
            }
            return this.jc;
        }
        catch (Throwable t) {
            throw new SynchException(t);
        }
    }

    class BedeworkNotificationBatch
    extends Connector.NotificationBatch<Notification> {
        BedeworkNotificationBatch() {
        }
    }
}

