/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.synch.shared.cnctrs;

import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.bedework.synch.shared.BaseSubscriptionInfo;
import org.bedework.synch.shared.Subscription;
import org.bedework.synch.shared.cnctrs.AbstractConnector;
import org.bedework.synch.shared.cnctrs.Connector;
import org.bedework.synch.shared.cnctrs.ConnectorInstance;
import org.bedework.synch.shared.conf.ConnectorConfigI;
import org.bedework.synch.shared.exception.SynchException;
import org.bedework.synch.wsmessages.ActiveSubscriptionRequestType;
import org.bedework.synch.wsmessages.SubscribeResponseType;
import org.bedework.synch.wsmessages.SynchEndType;
import org.bedework.synch.wsmessages.UnsubscribeRequestType;
import org.bedework.synch.wsmessages.UnsubscribeResponseType;
import org.bedework.util.misc.Logged;
import org.oasis_open.docs.ws_calendar.ns.soap.BaseResponseType;
import org.oasis_open.docs.ws_calendar.ns.soap.StatusType;

public abstract class AbstractConnectorInstance<CnctrT extends AbstractConnector, InfoT extends BaseSubscriptionInfo, ConfigT extends ConnectorConfigI>
extends Logged
implements ConnectorInstance<InfoT> {
    protected Subscription sub;
    protected SynchEndType end;
    protected InfoT info;
    protected final CnctrT cnctr;
    protected final ConfigT config;
    private CloseableHttpClient client;

    protected AbstractConnectorInstance(Subscription sub, SynchEndType end, InfoT info, CnctrT cnctr, ConfigT config) {
        this.sub = sub;
        this.end = end;
        this.info = info;
        this.cnctr = cnctr;
        this.config = config;
    }

    @Override
    public Connector getConnector() {
        return this.cnctr;
    }

    @Override
    public InfoT getSubInfo() {
        return this.info;
    }

    @Override
    public BaseResponseType open() throws SynchException {
        return null;
    }

    @Override
    public boolean subscribe(SubscribeResponseType sr) throws SynchException {
        return this.validateSubInfo(sr, this.getConnector(), (BaseSubscriptionInfo)this.getSubInfo());
    }

    @Override
    public boolean unsubscribe(UnsubscribeRequestType usreq, UnsubscribeResponseType usresp) throws SynchException {
        return this.validateActiveSubInfo((ActiveSubscriptionRequestType)usreq, (BaseResponseType)usresp, this.getConnector(), (BaseSubscriptionInfo)this.getSubInfo());
    }

    @Override
    public boolean validateActiveSubInfo(ActiveSubscriptionRequestType req, BaseResponseType resp, Connector cnctr, BaseSubscriptionInfo info) throws SynchException {
        resp.setStatus(StatusType.OK);
        if (req.getEnd() != this.end) {
            return true;
        }
        if (!cnctr.getPropertyInfo().validRequestProperties(info, req.getConnectorInfo().getProperties())) {
            resp.setStatus(StatusType.ERROR);
            return false;
        }
        return true;
    }

    @Override
    public void setLastCrudCts(BaseSubscriptionInfo.CrudCts val) throws SynchException {
        ((BaseSubscriptionInfo)this.info).setLastCrudCts(val);
    }

    @Override
    public BaseSubscriptionInfo.CrudCts getLastCrudCts() throws SynchException {
        return ((BaseSubscriptionInfo)this.info).getLastCrudCts();
    }

    @Override
    public void setTotalCrudCts(BaseSubscriptionInfo.CrudCts val) throws SynchException {
        ((BaseSubscriptionInfo)this.info).setTotalCrudCts(val);
    }

    @Override
    public BaseSubscriptionInfo.CrudCts getTotalCrudCts() throws SynchException {
        return ((BaseSubscriptionInfo)this.info).getTotalCrudCts();
    }

    protected boolean validateSubInfo(SubscribeResponseType sr, Connector cnctr, BaseSubscriptionInfo info) throws SynchException {
        if (!cnctr.getPropertyInfo().validSubscribeInfoProperties(info)) {
            sr.setStatus(StatusType.ERROR);
            return false;
        }
        return true;
    }

    protected CloseableHttpClient getClient() throws SynchException {
        if (this.client != null) {
            return this.client;
        }
        CloseableHttpClient cl = HttpClients.createDefault();
        HttpClientContext context = HttpClientContext.create();
        if (((BaseSubscriptionInfo)this.info).getPrincipalHref() != null) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(((BaseSubscriptionInfo)this.info).getPrincipalHref(), ((AbstractConnector)this.cnctr).getSyncher().decrypt(((BaseSubscriptionInfo)this.info).getPassword())));
            context.setCredentialsProvider((CredentialsProvider)credsProvider);
        }
        this.client = cl;
        return cl;
    }
}

