/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.synch.shared.cnctrs;

import ietf.params.xml.ns.icalendar_2.ArrayOfComponents;
import ietf.params.xml.ns.icalendar_2.ArrayOfProperties;
import ietf.params.xml.ns.icalendar_2.BaseComponentType;
import ietf.params.xml.ns.icalendar_2.IcalendarType;
import ietf.params.xml.ns.icalendar_2.LastModifiedPropType;
import ietf.params.xml.ns.icalendar_2.ObjectFactory;
import ietf.params.xml.ns.icalendar_2.ProdidPropType;
import ietf.params.xml.ns.icalendar_2.TextPropertyType;
import ietf.params.xml.ns.icalendar_2.UidPropType;
import ietf.params.xml.ns.icalendar_2.VcalendarType;
import ietf.params.xml.ns.icalendar_2.VersionPropType;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.client.CloseableHttpClient;
import org.bedework.synch.shared.BaseSubscriptionInfo;
import org.bedework.synch.shared.Subscription;
import org.bedework.synch.shared.cnctrs.AbstractConnector;
import org.bedework.synch.shared.cnctrs.AbstractConnectorInstance;
import org.bedework.synch.shared.cnctrs.ConnectorInstance;
import org.bedework.synch.shared.conf.ConnectorConfigI;
import org.bedework.synch.shared.exception.SynchException;
import org.bedework.synch.wsmessages.SynchEndType;
import org.bedework.util.calendar.XcalUtil;
import org.bedework.util.http.Headers;
import org.bedework.util.http.HttpUtil;
import org.bedework.util.misc.Util;
import org.bedework.util.xml.tagdefs.XcalTags;
import org.oasis_open.docs.ws_calendar.ns.soap.AddItemResponseType;
import org.oasis_open.docs.ws_calendar.ns.soap.DeleteItemResponseType;
import org.oasis_open.docs.ws_calendar.ns.soap.FetchItemResponseType;
import org.oasis_open.docs.ws_calendar.ns.soap.StatusType;
import org.oasis_open.docs.ws_calendar.ns.soap.UpdateItemResponseType;
import org.oasis_open.docs.ws_calendar.ns.soap.UpdateItemType;

public abstract class BaseConnectorInstance<CnctrT extends AbstractConnector, InfoT extends BaseSubscriptionInfo, ConfigT extends ConnectorConfigI>
extends AbstractConnectorInstance<CnctrT, InfoT, ConfigT> {
    protected IcalendarType fetchedIcal;
    protected String prodid;
    protected final ObjectFactory of = new ObjectFactory();
    protected Map<String, MapEntry> uidMap;

    protected BaseConnectorInstance(Subscription sub, SynchEndType end, InfoT info, CnctrT cnctr, ConfigT config) {
        super(sub, end, info, cnctr, config);
    }

    public abstract URI getUri() throws SynchException;

    public abstract IcalendarType makeXcal(InputStream var1) throws SynchException;

    public abstract boolean getIcal() throws SynchException;

    @Override
    public AddItemResponseType addItem(IcalendarType val) throws SynchException {
        if (this.config.getReadOnly()) {
            throw new SynchException("Immutable");
        }
        throw new SynchException("Unimplemented");
    }

    @Override
    public UpdateItemResponseType updateItem(UpdateItemType updates) throws SynchException {
        if (this.config.getReadOnly()) {
            throw new SynchException("Immutable");
        }
        throw new SynchException("Unimplemented");
    }

    @Override
    public DeleteItemResponseType deleteItem(String uid) throws SynchException {
        return null;
    }

    @Override
    public FetchItemResponseType fetchItem(String uid) throws SynchException {
        MapEntry me;
        FetchItemResponseType fir = new FetchItemResponseType();
        if (!this.getIcal()) {
            fir.setStatus(StatusType.ERROR);
            return fir;
        }
        if (this.sub.changed()) {
            this.cnctr.getSyncher().updateSubscription(this.sub);
        }
        if ((me = this.uidMap.get(uid)) == null) {
            fir.setStatus(StatusType.NOT_FOUND);
            return fir;
        }
        fir.setHref(this.info.getUri() + "#" + uid);
        fir.setChangeToken(this.info.getChangeToken());
        IcalendarType ical = new IcalendarType();
        VcalendarType vcal = new VcalendarType();
        ical.getVcalendar().add(vcal);
        vcal.setProperties(new ArrayOfProperties());
        List pl = vcal.getProperties().getBasePropertyOrTzid();
        ProdidPropType prod = new ProdidPropType();
        prod.setText(this.prodid);
        pl.add(this.of.createProdid(prod));
        VersionPropType vers = new VersionPropType();
        vers.setText("2.0");
        pl.add(this.of.createVersion(vers));
        ArrayOfComponents aoc = new ArrayOfComponents();
        vcal.setComponents(aoc);
        aoc.getBaseComponent().addAll(me.comps);
        fir.setIcalendar(ical);
        return fir;
    }

    @Override
    public List<FetchItemResponseType> fetchItems(List<String> uids) throws SynchException {
        ArrayList<FetchItemResponseType> firs = new ArrayList<FetchItemResponseType>();
        for (String uid : uids) {
            firs.add(this.fetchItem(uid));
        }
        return firs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean changed(boolean headSupported, String contentType) throws SynchException {
        if (this.info.getChangeToken() == null) {
            this.fetchedIcal = null;
            return true;
        }
        try (CloseableHttpResponse hresp = this.getChangedResponse(headSupported, contentType);){
            int rc = HttpUtil.getStatus((HttpResponse)hresp);
            if (rc != 200) {
                this.info.setLastRefreshStatus(String.valueOf(rc));
                if (this.debug) {
                    this.debug("Unsuccessful response from server was " + rc);
                }
                this.info.setChangeToken(null);
                this.fetchedIcal = null;
                boolean bl = true;
                return bl;
            }
            String etag = HttpUtil.getFirstHeaderValue((HttpResponse)hresp, (String)"Etag");
            if (etag == null) {
                if (this.debug) {
                    this.debug("Received null etag");
                }
                boolean bl = false;
                return bl;
            }
            if (this.debug) {
                this.debug("Received etag:" + etag + ", ours=" + this.info.getChangeToken());
            }
            if (this.info.getChangeToken().equals(etag)) {
                boolean bl = false;
                return bl;
            }
            this.fetchedIcal = null;
            boolean bl = true;
            return bl;
        }
        catch (SynchException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new SynchException(t);
        }
    }

    @Override
    public ConnectorInstance.SynchItemsInfo getItemsInfo() throws SynchException {
        ConnectorInstance.SynchItemsInfo sii = new ConnectorInstance.SynchItemsInfo();
        sii.items = new ArrayList<ConnectorInstance.ItemInfo>();
        sii.setStatus(StatusType.OK);
        if (!this.getIcal()) {
            sii.setStatus(StatusType.ERROR);
            return sii;
        }
        if (this.sub.changed()) {
            this.cnctr.getSyncher().updateSubscription(this.sub);
        }
        if (this.uidMap == null) {
            return sii;
        }
        for (MapEntry me : this.uidMap.values()) {
            sii.items.add(new ConnectorInstance.ItemInfo(me.uid, me.lastMod, null));
        }
        return sii;
    }

    private CloseableHttpResponse getChangedResponse(boolean headSupported, String contentType) throws SynchException {
        try {
            if (headSupported) {
                return HttpUtil.doHead((CloseableHttpClient)this.getClient(), (URI)this.getUri(), null, (String)contentType);
            }
            return HttpUtil.doGet((CloseableHttpClient)this.getClient(), (URI)this.getUri(), null, (String)contentType);
        }
        catch (SynchException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new SynchException(t);
        }
    }

    public <T extends TextPropertyType> String getText(Class<T> cl, JAXBElement<? extends BaseComponentType> comp, QName tag) {
        TextPropertyType pt = (TextPropertyType)XcalUtil.findProperty((BaseComponentType)((BaseComponentType)comp.getValue()), (QName)tag);
        if (pt == null) {
            return null;
        }
        return pt.getText();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean getIcal(String contentType) throws SynchException {
        try {
            Headers hdrs;
            if (this.fetchedIcal != null) {
                return true;
            }
            if (this.uidMap != null && this.info.getChangeToken() != null && this.fetchedIcal != null) {
                hdrs = new Headers();
                hdrs.add("If-None-Match", this.info.getChangeToken());
            } else {
                hdrs = null;
            }
            try (CloseableHttpResponse hresp = HttpUtil.doGet((CloseableHttpClient)this.getClient(), (URI)this.getUri(), hdrs, (String)"text/calendar");){
                int rc = HttpUtil.getStatus((HttpResponse)hresp);
                this.info.setLastRefreshStatus(String.valueOf(rc));
                if (rc == 304) {
                    if (this.debug) {
                        this.debug("data unchanged");
                    }
                    boolean bl = true;
                    return bl;
                }
                if (rc != 200) {
                    if (this.debug) {
                        this.debug("Unsuccessful response from server was " + rc);
                    }
                    this.info.setLastRefreshStatus(String.valueOf(rc));
                    this.info.setChangeToken(null);
                    boolean bl = false;
                    return bl;
                }
                this.fetchedIcal = this.makeXcal(hresp.getEntity().getContent());
                this.uidMap = new HashMap<String, MapEntry>();
                this.prodid = null;
                Iterator iterator = this.fetchedIcal.getVcalendar().iterator();
                block18: while (true) {
                    VcalendarType vcal;
                    if (iterator.hasNext()) {
                        vcal = (VcalendarType)iterator.next();
                        if (this.prodid == null && vcal.getProperties() != null) {
                            for (JAXBElement pel : vcal.getProperties().getBasePropertyOrTzid()) {
                                if (!(pel.getValue() instanceof ProdidPropType)) continue;
                                this.prodid = ((ProdidPropType)pel.getValue()).getText();
                                break;
                            }
                        }
                    } else {
                        String etag = HttpUtil.getFirstHeaderValue((HttpResponse)hresp, (String)"Etag");
                        if (etag == null) return true;
                        this.info.setChangeToken(etag);
                        return true;
                    }
                    Iterator iterator2 = vcal.getComponents().getBaseComponent().iterator();
                    while (true) {
                        if (!iterator2.hasNext()) continue block18;
                        JAXBElement comp = (JAXBElement)iterator2.next();
                        UidPropType uidProp = (UidPropType)XcalUtil.findProperty((BaseComponentType)((BaseComponentType)comp.getValue()), (QName)XcalTags.uid);
                        if (uidProp == null) continue;
                        String uid = uidProp.getText();
                        MapEntry me = this.uidMap.get(uid);
                        if (me == null) {
                            me = new MapEntry();
                            me.uid = uid;
                            this.uidMap.put(uidProp.getText(), me);
                        }
                        LastModifiedPropType lm = (LastModifiedPropType)XcalUtil.findProperty((BaseComponentType)((BaseComponentType)comp.getValue()), (QName)XcalTags.lastModified);
                        String lastmod = null;
                        if (lm != null) {
                            lastmod = lm.getUtcDateTime().toXMLFormat();
                        }
                        if (Util.cmpObjval((Comparable)((Object)me.lastMod), (Comparable)((Object)lastmod)) < 0) {
                            me.lastMod = lastmod;
                        }
                        me.comps.add((JAXBElement<? extends BaseComponentType>)comp);
                    }
                    break;
                }
            }
        }
        catch (SynchException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new SynchException(t);
        }
    }

    public static class MapEntry {
        public List<JAXBElement<? extends BaseComponentType>> comps = new ArrayList<JAXBElement<? extends BaseComponentType>>();
        public String lastMod;
        public String uid;
    }
}

