/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.synch.shared.filters;

import ietf.params.xml.ns.icalendar_2.ArrayOfComponents;
import ietf.params.xml.ns.icalendar_2.ArrayOfProperties;
import ietf.params.xml.ns.icalendar_2.BaseComponentType;
import ietf.params.xml.ns.icalendar_2.BasePropertyType;
import ietf.params.xml.ns.icalendar_2.IcalendarType;
import ietf.params.xml.ns.icalendar_2.ObjectFactory;
import ietf.params.xml.ns.icalendar_2.VcalendarType;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import org.bedework.synch.shared.Subscription;
import org.bedework.synch.shared.exception.SynchException;
import org.bedework.synch.shared.filters.Filter;
import org.bedework.util.calendar.XcalUtil;
import org.bedework.util.misc.Logged;
import org.bedework.util.misc.Util;

public abstract class AbstractFilter
extends Logged
implements Filter {
    protected Subscription sub;
    protected Map<String, Object> stripMap;
    protected static final ObjectFactory icalOf = new ObjectFactory();

    protected AbstractFilter() {
        this.debug = this.getLogger().isDebugEnabled();
    }

    @Override
    public void init(Subscription sub) throws SynchException {
        this.sub = sub;
    }

    @Override
    public void addDifferSkipItems(List<Object> skipList) throws SynchException {
        Collection<Object> stripMapValues = this.getStripMap().values();
        if (Util.isEmpty(stripMapValues)) {
            return;
        }
        skipList.addAll(stripMapValues);
    }

    protected synchronized Map<String, Object> getStripMap() throws SynchException {
        if (this.stripMap != null) {
            return this.stripMap;
        }
        this.stripMap = new HashMap<String, Object>();
        return this.stripMap;
    }

    protected IcalendarType stripIcal(IcalendarType val) throws SynchException {
        try {
            Map<String, Object> stripMap = this.getStripMap();
            if (stripMap == null || stripMap.isEmpty()) {
                return val;
            }
            IcalendarType res = new IcalendarType();
            for (VcalendarType vcal : val.getVcalendar()) {
                VcalendarType v = (VcalendarType)XcalUtil.cloneComponent((BaseComponentType)vcal);
                res.getVcalendar().add(v);
                v.setProperties(this.stripProps(stripMap, (BaseComponentType)vcal));
                v.setComponents(this.stripComps(stripMap, (BaseComponentType)vcal));
            }
            return res;
        }
        catch (SynchException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new SynchException(t);
        }
    }

    private ArrayOfComponents stripComps(Map<String, Object> stripMap, BaseComponentType val) throws SynchException {
        try {
            ArrayOfComponents comps = val.getComponents();
            if (comps == null) {
                return null;
            }
            ArrayOfComponents c = new ArrayOfComponents();
            boolean stripped = false;
            for (JAXBElement jaxbCcomp : comps.getBaseComponent()) {
                BaseComponentType jcomp = (BaseComponentType)jaxbCcomp.getValue();
                if (stripMap.get(jcomp.getClass().getCanonicalName()) != null) {
                    stripped = true;
                    continue;
                }
                ArrayOfProperties p = this.stripProps(stripMap, jcomp);
                if (jcomp.getProperties() != p) {
                    stripped = true;
                    jcomp = XcalUtil.cloneComponent((BaseComponentType)jcomp);
                    jcomp.setProperties(p);
                    jaxbCcomp.setValue((Object)jcomp);
                }
                ArrayOfComponents strippedComps = this.stripComps(stripMap, jcomp);
                if (jcomp.getComponents() != strippedComps) {
                    stripped = true;
                    BaseComponentType comp = XcalUtil.cloneComponent((BaseComponentType)jcomp);
                    comp.setProperties(jcomp.getProperties());
                    comp.setComponents(strippedComps);
                    jaxbCcomp.setValue((Object)comp);
                }
                c.getBaseComponent().add(jaxbCcomp);
            }
            if (stripped) {
                return c;
            }
            return comps;
        }
        catch (SynchException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new SynchException(t);
        }
    }

    private ArrayOfProperties stripProps(Map<String, Object> stripMap, BaseComponentType val) throws SynchException {
        ArrayOfProperties props = val.getProperties();
        if (props == null) {
            return null;
        }
        ArrayOfProperties p = new ArrayOfProperties();
        boolean stripped = false;
        for (JAXBElement jprop : props.getBasePropertyOrTzid()) {
            if (stripMap.get(((BasePropertyType)jprop.getValue()).getClass().getCanonicalName()) != null) {
                stripped = true;
                continue;
            }
            p.getBasePropertyOrTzid().add(jprop);
        }
        if (stripped) {
            return p;
        }
        return props;
    }

    protected void addSkip(Map<String, Object> skipMap, Object o) {
        skipMap.put(o.getClass().getCanonicalName(), o);
    }
}

