/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.synch.web;

import java.net.URLDecoder;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilderFactory;
import org.bedework.synch.shared.SynchEngine;
import org.bedework.synch.shared.exception.SynchException;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.w3c.dom.Document;

public abstract class MethodBase
implements Logged {
    protected boolean dumpContent;
    protected SynchEngine syncher;
    private final SimpleDateFormat httpDateFormatter = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss ");
    private BwLogger logger = new BwLogger();

    public abstract void init() throws SynchException;

    public abstract void doMethod(HttpServletRequest var1, HttpServletResponse var2) throws SynchException;

    public void init(SynchEngine syncher, boolean dumpContent) throws SynchException {
        this.syncher = syncher;
        this.dumpContent = dumpContent;
        this.init();
    }

    public SynchEngine getSyncher() {
        return this.syncher;
    }

    public List<String> getResourceUri(HttpServletRequest req) {
        String uri = req.getServletPath();
        if (uri == null || uri.length() == 0) {
            uri = "/";
        }
        return MethodBase.fixPath(uri);
    }

    public static List<String> fixPath(String path) {
        Object decoded;
        if (path == null) {
            return null;
        }
        try {
            decoded = URLDecoder.decode(path, "UTF8");
        }
        catch (Throwable ignored) {
            return null;
        }
        if (decoded == null) {
            return null;
        }
        if (((String)decoded).indexOf(92) >= 0) {
            decoded = ((String)decoded).replace('\\', '/');
        }
        if (!((String)decoded).startsWith("/")) {
            decoded = "/" + (String)decoded;
        }
        while (((String)decoded).contains("//")) {
            decoded = ((String)decoded).replaceAll("//", "/");
        }
        StringTokenizer st = new StringTokenizer((String)decoded, "/");
        ArrayList<String> al = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equals(".")) continue;
            if (s.equals("..")) {
                if (al.size() == 0) {
                    return null;
                }
                al.remove(al.size() - 1);
                continue;
            }
            al.add(s);
        }
        return al;
    }

    protected void addHeaders(HttpServletResponse resp) throws SynchException {
        resp.addHeader("Allow", "POST, GET");
    }

    protected Document parseContent(HttpServletRequest req, HttpServletResponse resp) throws SynchException {
        int len = req.getContentLength();
        if (len == 0) {
            return null;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            return null;
        }
        catch (Throwable t) {
            resp.setStatus(500);
            throw new SynchException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String formatHTTPDate(Timestamp val) {
        if (val == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = this.httpDateFormatter;
        synchronized (simpleDateFormat) {
            return this.httpDateFormatter.format(val) + "GMT";
        }
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }

    public static class MethodInfo {
        private final Class<? extends MethodBase> methodClass;
        private final boolean requiresAuth;

        public MethodInfo(Class<? extends MethodBase> methodClass, boolean requiresAuth) {
            this.methodClass = methodClass;
            this.requiresAuth = requiresAuth;
        }

        public Class<? extends MethodBase> getMethodClass() {
            return this.methodClass;
        }

        public boolean getRequiresAuth() {
            return this.requiresAuth;
        }
    }
}

