/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.timezones.common;

import ietf.params.xml.ns.icalendar_2.IcalendarType;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.UnfoldingReader;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.property.LastModified;
import net.fortuna.ical4j.model.property.TzId;
import net.fortuna.ical4j.model.property.TzidAliasOf;
import org.bedework.timezones.common.CachedData;
import org.bedework.timezones.common.ExpandedMapEntry;
import org.bedework.timezones.common.ExpandedMapEntryKey;
import org.bedework.timezones.common.Stat;
import org.bedework.timezones.common.TzConfig;
import org.bedework.timezones.common.TzException;
import org.bedework.timezones.common.TzServerUtil;
import org.bedework.timezones.common.db.TzAlias;
import org.bedework.util.caching.FlushMap;
import org.bedework.util.calendar.IcalToXcal;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.bedework.util.timezones.DateTimeUtil;
import org.bedework.util.timezones.model.TimezoneType;

public abstract class AbstractCachedData
implements Logged,
CachedData {
    protected String msgPrefix;
    protected Timestamp objTimestamp;
    protected String dtstamp;
    private Map<String, String> vtzs = new HashMap<String, String>();
    private Map<String, TimeZone> timeZones = new FlushMap();
    private Map<String, IcalendarType> xtzs = new HashMap<String, IcalendarType>();
    private Map<String, String> aliasedVtzs = new HashMap<String, String>();
    private Map<String, IcalendarType> aliasedXtzs = new HashMap<String, IcalendarType>();
    private SortedSet<String> nameList;
    protected Map<ExpandedMapEntryKey, ExpandedMapEntry> expansions = new HashMap<ExpandedMapEntryKey, ExpandedMapEntry>();
    protected AliasMaps aliasMaps;
    protected TzConfig cfg;
    private List<TimezoneType> timezones;
    private Map<String, TimezoneType> timezonesMap;
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private BwLogger logger = new BwLogger();

    public AbstractCachedData(TzConfig cfg, String msgPrefix) throws TzException {
        if (cfg == null) {
            throw new TzException("No configuration data");
        }
        this.cfg = cfg;
        this.msgPrefix = msgPrefix;
    }

    @Override
    public List<Stat> getStats() throws TzException {
        ArrayList<Stat> stats = new ArrayList<Stat>();
        if (this.vtzs == null) {
            stats.add(new Stat(this.msgPrefix, " #tzs  Unavailable"));
        } else {
            stats.add(new Stat(this.msgPrefix + " #tzs", String.valueOf(this.vtzs.size())));
        }
        stats.add(new Stat(this.msgPrefix + " dtstamp", this.dtstamp));
        stats.add(new Stat(this.msgPrefix + " cached expansions", String.valueOf(this.expansions.size())));
        return stats;
    }

    public abstract List<String> findIds(String var1) throws TzException;

    @Override
    public String getDtstamp() throws TzException {
        return this.dtstamp;
    }

    @Override
    public TzAlias fromAlias(String val) throws TzException {
        return this.aliasMaps.byAlias.get(val);
    }

    @Override
    public String getAliasesStr() throws TzException {
        return this.aliasMaps.aliasesStr;
    }

    @Override
    public SortedSet<String> findAliases(String tzid) throws TzException {
        return this.aliasMaps.byTzid.get(tzid);
    }

    @Override
    public SortedSet<String> getNameList() throws TzException {
        return this.nameList;
    }

    @Override
    public void setExpanded(ExpandedMapEntryKey key, ExpandedMapEntry tzs) throws TzException {
        this.expansions.put(key, tzs);
    }

    @Override
    public ExpandedMapEntry getExpanded(ExpandedMapEntryKey key) throws TzException {
        return this.expansions.get(key);
    }

    @Override
    public String getCachedVtz(String name) throws TzException {
        return this.vtzs.get(name);
    }

    @Override
    public Collection<String> getAllCachedVtzs() throws TzException {
        return this.vtzs.values();
    }

    @Override
    public TimeZone getTimeZone(String tzid) throws TzException {
        TimeZone tz = this.timeZones.get(tzid);
        if (tz != null) {
            return tz;
        }
        Calendar cal = this.parseDef(TzServerUtil.getCalHdr() + this.getCachedVtz(tzid) + TzServerUtil.getCalTlr());
        tz = new TimeZone(this.vtzFromCal(cal));
        this.timeZones.put(tzid, tz);
        return tz;
    }

    @Override
    public IcalendarType getXTimeZone(String tzid) throws TzException {
        return this.xtzs.get(tzid);
    }

    @Override
    public IcalendarType getAliasedXTimeZone(String tzid) throws TzException {
        return this.aliasedXtzs.get(tzid);
    }

    @Override
    public String getAliasedCachedVtz(String name) throws TzException {
        return this.aliasedVtzs.get(name);
    }

    @Override
    public List<TimezoneType> getTimezones(String[] tzids) throws TzException {
        ArrayList<TimezoneType> ss = new ArrayList<TimezoneType>();
        for (String tzid : tzids) {
            TimezoneType t = this.timezonesMap.get(tzid);
            if (t == null) continue;
            ss.add(t);
        }
        return ss;
    }

    @Override
    public List<TimezoneType> getTimezones(String changedSince) throws TzException {
        if (changedSince == null) {
            return this.timezones;
        }
        ArrayList<TimezoneType> ss = new ArrayList<TimezoneType>();
        for (TimezoneType tz : this.timezones) {
            if (tz.getLastModified() == null) {
                ss.add(tz);
                continue;
            }
            String lm = DateTimeUtil.rfcDateTimeUTC((Date)tz.getLastModified());
            if (changedSince.compareTo(lm) >= 0) continue;
            ss.add(tz);
        }
        return ss;
    }

    @Override
    public List<TimezoneType> findTimezones(String name) throws TzException {
        ArrayList<TimezoneType> sums = new ArrayList<TimezoneType>();
        List<String> ids = this.findIds(name);
        for (TimezoneType tz : this.timezones) {
            if (!ids.contains(tz.getTzid())) continue;
            sums.add(tz);
        }
        return sums;
    }

    protected void processSpec(String id, String caldef, String etag, String storedDtstamp) throws TzException {
        this.processSpec(id, this.parseDef(caldef), etag, storedDtstamp);
    }

    protected void processSpec(String id, Calendar cal, String etag, String storedDtstamp) throws TzException {
        try {
            this.nameList.add(id);
            VTimeZone vtz = this.vtzFromCal(cal);
            this.vtzs.put(id, vtz.toString());
            IcalendarType xcal = IcalToXcal.fromIcal((Calendar)cal, null, (boolean)true);
            this.xtzs.put(id, xcal);
            TimezoneType tz = new TimezoneType();
            tz.setTzid(id);
            LastModified lm = vtz.getLastModified();
            if (lm != null) {
                tz.setLastModified(DateTimeUtil.fromRfcDateTimeUTC((String)lm.getValue()));
            } else if (storedDtstamp != null) {
                tz.setLastModified(DateTimeUtil.fromRfcDateTimeUTC((String)storedDtstamp));
            } else {
                tz.setLastModified(DateTimeUtil.fromRfcDateTimeUTC((String)this.dtstamp));
            }
            if (etag != null) {
                tz.setEtag(etag);
            } else if (storedDtstamp != null) {
                tz.setEtag(storedDtstamp);
            } else {
                tz.setEtag(this.dtstamp);
            }
            SortedSet<String> aliases = this.findAliases(id);
            if (aliases != null) {
                for (String a : aliases) {
                    TzAlias alias;
                    if (tz.getAliases() == null) {
                        tz.setAliases(new ArrayList());
                    }
                    tz.getAliases().add(a);
                    List<String> aliasedIds = null;
                    if (this.aliasMaps != null && (alias = this.aliasMaps.byAlias.get(a)) != null) {
                        aliasedIds = alias.getTargetIds();
                    }
                    VTimeZone avtz = this.addAlias(a, vtz, aliasedIds);
                    cal.getComponents().clear();
                    cal.getComponents().add((Object)avtz);
                    xcal = IcalToXcal.fromIcal((Calendar)cal, null, (boolean)true);
                    this.aliasedXtzs.put(id, xcal);
                }
            }
            this.timezones.add(tz);
            this.timezonesMap.put(tz.getTzid(), tz);
        }
        catch (TzException te) {
            throw te;
        }
        catch (Throwable t) {
            throw new TzException(t);
        }
    }

    protected Calendar parseDef(String caldef) throws TzException {
        try {
            CalendarBuilder cb = new CalendarBuilder();
            UnfoldingReader ufrdr = new UnfoldingReader((Reader)new StringReader(caldef), true);
            return cb.build(ufrdr);
        }
        catch (Throwable t) {
            throw new TzException(t);
        }
    }

    protected VTimeZone vtzFromCal(Calendar cal) throws TzException {
        VTimeZone vtz = (VTimeZone)cal.getComponents().getComponent("VTIMEZONE");
        if (vtz == null) {
            throw new TzException("Incorrectly stored timezone");
        }
        return vtz;
    }

    protected void resetTzs() {
        this.nameList = new TreeSet<String>();
        this.timezones = new ArrayList<TimezoneType>();
        this.timezonesMap = new HashMap<String, TimezoneType>();
    }

    protected VTimeZone addAlias(String alias, VTimeZone vtz, List<String> tzids) throws TzException {
        try {
            VTimeZone avtz = (VTimeZone)vtz.copy();
            TzId tzidProp = avtz.getTimeZoneId();
            tzidProp.setValue(alias);
            if (tzids != null) {
                for (String tzid : tzids) {
                    avtz.getProperties().add((Object)new TzidAliasOf(tzid));
                }
            }
            this.aliasedVtzs.put(alias, avtz.toString());
            return avtz;
        }
        catch (Throwable t) {
            throw new TzException(t);
        }
    }

    protected String escape(String val) {
        StringBuilder sb = new StringBuilder();
        block8: for (int i = 0; i < val.length(); ++i) {
            char ch = val.charAt(i);
            if (ch > '=' && ch < '\u007f') {
                if (ch == '\\') {
                    sb.append("\\\\");
                    continue;
                }
                sb.append(ch);
                continue;
            }
            switch (ch) {
                case ' ': {
                    if (i == 0) {
                        sb.append('\\');
                    }
                    sb.append(' ');
                    continue block8;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    sb.append('\\');
                    sb.append(ch);
                    continue block8;
                }
                default: {
                    if (ch < ' ' || ch > '~') {
                        sb.append("\\u");
                        sb.append(hex[ch >> 12 & 0xF]);
                        sb.append(hex[ch >> 8 & 0xF]);
                        sb.append(hex[ch >> 4 & 0xF]);
                        sb.append(hex[ch & 0xF]);
                        continue block8;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }

    public static class AliasMaps {
        public String aliasesStr;
        public Properties aliases;
        public Map<String, SortedSet<String>> byTzid;
        public Map<String, TzAlias> byAlias;
    }
}

