/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.timezones.common;

import ietf.params.xml.ns.icalendar_2.IcalendarType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.bedework.timezones.common.CachedData;
import org.bedework.timezones.common.TzException;
import org.bedework.util.calendar.diff.XmlIcalCompare;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.oasis_open.docs.ws_calendar.ns.soap.ComponentSelectionType;

public class Differ
implements Logged {
    private BwLogger logger = new BwLogger();

    public List<DiffListEntry> compare(CachedData newTzdata, CachedData currentTzdata) throws TzException {
        ArrayList<DiffListEntry> res = new ArrayList<DiffListEntry>();
        SortedSet<String> newNames = newTzdata.getNameList();
        NameChanges nc = this.getNameChanges(newNames, currentTzdata.getNameList());
        if (!nc.deletedNames.isEmpty()) {
            this.warn("Following ids appear to have been deleted");
            for (String id : nc.deletedNames) {
                this.warn("   " + id);
            }
        }
        if (this.debug()) {
            this.debug("Following ids appear to have been added");
            for (String id : nc.addedNames) {
                this.debug("   " + id);
            }
        }
        XmlIcalCompare comp = new XmlIcalCompare(XmlIcalCompare.defaultSkipList, null);
        for (String tzid : newNames) {
            IcalendarType currentXcal;
            DiffListEntry dle;
            if (nc.addedNames.contains(tzid)) {
                dle = new DiffListEntry();
                dle.tzid = tzid;
                dle.add = true;
                dle.tzSpec = newTzdata.getCachedVtz(tzid);
                dle.aliases = newTzdata.findAliases(tzid);
                res.add(dle);
                continue;
            }
            if (nc.deletedNames.contains(tzid)) {
                dle = new DiffListEntry();
                dle.tzid = tzid;
                dle.deleted = true;
                dle.tzSpec = currentTzdata.getCachedVtz(tzid);
                dle.aliases = currentTzdata.findAliases(tzid);
                res.add(dle);
                continue;
            }
            IcalendarType newXcal = newTzdata.getXTimeZone(tzid);
            ComponentSelectionType cst = comp.diff(newXcal, currentXcal = currentTzdata.getXTimeZone(tzid));
            if (cst == null) continue;
            if (this.debug()) {
                this.debug("Adding " + tzid);
            }
            DiffListEntry dle2 = new DiffListEntry();
            dle2.tzid = tzid;
            dle2.tzSpec = newTzdata.getCachedVtz(tzid);
            dle2.aliases = newTzdata.findAliases(tzid);
            dle2.xcal = newXcal;
            res.add(dle2);
        }
        return res;
    }

    private NameChanges getNameChanges(SortedSet<String> newList, SortedSet<String> currentList) {
        NameChanges nc = new NameChanges();
        Iterator nit = newList.iterator();
        Iterator cit = currentList.iterator();
        String nid = (String)nit.next();
        String cid = (String)cit.next();
        while (nid != null || cid != null) {
            boolean advanceNew = false;
            boolean advanceCur = false;
            if (cid == null) {
                nc.addedNames.add(nid);
                advanceNew = true;
            } else if (nid == null) {
                nc.deletedNames.add(cid);
                advanceCur = true;
            } else {
                int cmp = nid.compareTo(cid);
                if (cmp == 0) {
                    advanceNew = true;
                    advanceCur = true;
                } else if (cmp < 0) {
                    nc.addedNames.add(nid);
                    advanceNew = true;
                } else {
                    nc.deletedNames.add(cid);
                    advanceCur = true;
                }
            }
            if (advanceCur) {
                cid = cit.hasNext() ? (String)cit.next() : null;
            }
            if (!advanceNew) continue;
            if (nit.hasNext()) {
                nid = (String)nit.next();
                continue;
            }
            nid = null;
        }
        return nc;
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }

    private static class NameChanges {
        SortedSet<String> addedNames = new TreeSet<String>();
        SortedSet<String> deletedNames = new TreeSet<String>();

        private NameChanges() {
        }
    }

    public static class DiffListEntry {
        public String tzid;
        public boolean add;
        public boolean deleted;
        public String tzSpec;
        public IcalendarType xcal;
        public boolean aliasChangeOnly;
        public SortedSet<String> aliases = new TreeSet<String>();

        protected void toStringSegment(StringBuilder sb, boolean full, String indent) {
            sb.append("tzid = ");
            sb.append(this.tzid);
            if (this.add) {
                sb.append(", add");
            } else if (this.deleted) {
                sb.append(", deleted");
            } else {
                sb.append(", update");
            }
            if (this.aliasChangeOnly) {
                sb.append(", aliasChangeOnly");
            }
        }

        public String toShortString() {
            StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("{");
            this.toStringSegment(sb, false, "  ");
            sb.append("}");
            return sb.toString();
        }
    }
}

