/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.timezones.common;

import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.property.Version;
import org.bedework.timezones.common.AbstractCachedData;
import org.bedework.timezones.common.Differ;
import org.bedework.timezones.common.TzConfig;
import org.bedework.timezones.common.TzException;
import org.bedework.timezones.common.TzServerUtil;
import org.bedework.timezones.common.db.TzAlias;
import org.bedework.util.calendar.XcalUtil;
import org.bedework.util.timezones.FileTzFetcher;

public class FileCachedData
extends AbstractCachedData {
    private String source;

    public FileCachedData(TzConfig cfg) throws TzException {
        super(cfg, "File");
        this.loadData();
    }

    @Override
    public void stop() throws TzException {
    }

    @Override
    public String getSource() throws TzException {
        return this.source;
    }

    @Override
    public void checkData() throws TzException {
        this.loadData();
    }

    @Override
    public void updateData(String dtstamp, List<Differ.DiffListEntry> dles) throws TzException {
    }

    @Override
    public List<String> findIds(String val) throws TzException {
        return new ArrayList<String>();
    }

    private synchronized void loadData() throws TzException {
        try {
            long smillis = System.currentTimeMillis();
            File f = this.getdata();
            TzServerUtil.lastDataFetch = System.currentTimeMillis();
            Properties info = new Properties();
            info.load(this.getFileRdr(f, "info.properties"));
            this.dtstamp = XcalUtil.getXmlFormatDateTime((String)info.getProperty("buildTime"));
            if (info.getProperty("prodid") != null) {
                TzServerUtil.setProdid(info.getProperty("prodid"));
            }
            this.source = info.getProperty("source");
            this.aliasMaps = this.buildAliasMaps(f);
            this.fetchTzs(this.dtstamp);
            this.expansions.clear();
            this.cfg.setDtstamp(this.dtstamp);
            this.cfg.setSource(this.source);
            TzServerUtil.saveConfig();
            TzServerUtil.reloadsMillis += System.currentTimeMillis() - smillis;
            ++TzServerUtil.reloads;
        }
        catch (Throwable t) {
            throw new TzException(t);
        }
    }

    private AbstractCachedData.AliasMaps buildAliasMaps(File parent) throws TzException {
        try {
            AbstractCachedData.AliasMaps maps = new AbstractCachedData.AliasMaps();
            maps.byTzid = new HashMap<String, SortedSet<String>>();
            maps.byAlias = new HashMap<String, TzAlias>();
            maps.aliases = new Properties();
            maps.aliases.load(this.getFileRdr(parent, "aliases.properties"));
            StringBuilder aliasStr = new StringBuilder();
            for (String aliasId : maps.aliases.stringPropertyNames()) {
                String val = maps.aliases.getProperty(aliasId);
                if (val == null) continue;
                String[] vals = val.split(",");
                TzAlias alias = new TzAlias(aliasId);
                StringBuilder ids = new StringBuilder();
                String delim = "";
                for (String s : vals) {
                    ids.append(delim);
                    String id = this.escape(s);
                    ids.append(id);
                    delim = ",";
                    alias.addTargetId(s);
                    SortedSet<String> as = maps.byTzid.get(s);
                    if (as == null) {
                        as = new TreeSet<String>();
                        maps.byTzid.put(s, as);
                    }
                    as.add(aliasId);
                }
                aliasStr.append(this.escape(aliasId));
                aliasStr.append('=');
                aliasStr.append(ids.toString());
                aliasStr.append('\n');
                maps.byAlias.put(aliasId, alias);
            }
            maps.aliasesStr = aliasStr.toString();
            return maps;
        }
        catch (Throwable t) {
            throw new TzException(t);
        }
    }

    private void fetchTzs(String dtstamp) throws TzException {
        try {
            this.resetTzs();
            FileTzFetcher tzFetcher = new FileTzFetcher(this.cfg.getTzdataUrl());
            for (String id : tzFetcher.getTzids()) {
                Calendar cal = new Calendar();
                cal.getComponents().add((Object)tzFetcher.getTz(id));
                cal.getProperties().add((Object)new Version());
                this.processSpec(id, cal, null, dtstamp);
            }
        }
        catch (Throwable t) {
            throw new TzException(t);
        }
    }

    private File getdata() throws TzException {
        try {
            String dataUrl = this.cfg.getTzdataUrl();
            if (dataUrl == null) {
                throw new TzException("No data url defined");
            }
            File f = new File(dataUrl);
            if (!f.isDirectory()) {
                throw new TzException(dataUrl + " is not a directory");
            }
            return f;
        }
        catch (TzException tze) {
            throw tze;
        }
        catch (Throwable t) {
            throw new TzException(t);
        }
    }

    private LineNumberReader getFileLnr(File parent, String name) throws TzException {
        try {
            return new LineNumberReader(this.getFileRdr(parent, name));
        }
        catch (TzException tze) {
            throw tze;
        }
        catch (Throwable t) {
            throw new TzException(t);
        }
    }

    private FileReader getFileRdr(File parent, String name) throws TzException {
        try {
            File theFile = new File(parent.getAbsolutePath(), name);
            if (!theFile.exists() || !theFile.isFile()) {
                throw new TzException(name + " does not exist or is not a file. Path: " + theFile.getAbsolutePath());
            }
            return new FileReader(theFile);
        }
        catch (TzException tze) {
            throw tze;
        }
        catch (Throwable t) {
            throw new TzException(t);
        }
    }
}

