/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.timezones.common;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.UtcOffset;
import net.fortuna.ical4j.model.component.Observance;
import net.fortuna.ical4j.model.component.VTimeZone;
import org.bedework.timezones.common.CachedData;
import org.bedework.timezones.common.Differ;
import org.bedework.timezones.common.ExpandedMapEntry;
import org.bedework.timezones.common.ExpandedMapEntryKey;
import org.bedework.timezones.common.FileCachedData;
import org.bedework.timezones.common.Stat;
import org.bedework.timezones.common.TzConfig;
import org.bedework.timezones.common.TzConfigImpl;
import org.bedework.timezones.common.TzException;
import org.bedework.timezones.common.ZipCachedData;
import org.bedework.timezones.common.leveldb.LdbCachedData;
import org.bedework.util.calendar.XcalUtil;
import org.bedework.util.jmx.ConfigHolder;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.timezones.DateTimeUtil;
import org.bedework.util.timezones.model.ExpandedTimezoneType;
import org.bedework.util.timezones.model.ObservanceType;
import org.bedework.util.timezones.model.TimezoneType;

public class TzServerUtil {
    private static BwLogger logger = new BwLogger().setLoggedClass(TzServerUtil.class);
    private static String appname = "tzsvr";
    private static TzServerUtil instance;
    static ConfigHolder<TzConfigImpl> cfgHolder;
    private static Object locker;
    private static String prodid;
    static long gets;
    static long cacheHits;
    static long reads;
    static long nameLists;
    static long aliasReads;
    static long conversions;
    static long conversionsMillis;
    static long tzfetches;
    static long reloads;
    static long reloadsMillis;
    static long expandFetches;
    static long expandHits;
    static long expands;
    static long expandsMillis;
    public static final String errorNodata = "org.tserver.no.data";
    private CachedData cache;
    public static long lastDataFetch;
    private static final Calendar cal;
    private static final TimeZone utctz;

    private TzServerUtil() throws TzException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TzServerUtil getInstance() throws TzException {
        if (instance != null) {
            return instance;
        }
        Object object = locker;
        synchronized (object) {
            if (instance != null) {
                return instance;
            }
            instance = new TzServerUtil();
        }
        return instance;
    }

    public static String getAppname() {
        return appname;
    }

    public static void setTzConfigHolder(ConfigHolder<TzConfigImpl> val) {
        cfgHolder = val;
    }

    public static String getConfigDir() {
        if (cfgHolder == null) {
            return null;
        }
        return cfgHolder.getConfigUri();
    }

    public static TzConfig getTzConfig() {
        if (cfgHolder == null) {
            return null;
        }
        return (TzConfig)cfgHolder.getConfig();
    }

    public static void saveConfig() {
        if (cfgHolder != null) {
            cfgHolder.putConfig();
        }
    }

    public static String printableTime(long millis) {
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        return String.valueOf(minutes) + ":" + (seconds - minutes * 60L);
    }

    public static void fireRefresh(boolean clear) throws TzException {
        TzServerUtil tzutil = TzServerUtil.getInstance();
        if (tzutil.cache != null) {
            try {
                tzutil.cache.stop();
            }
            catch (Throwable t) {
                logger.error(t);
                logger.error("Error stopping cache");
            }
            tzutil.cache = null;
        }
        tzutil.getcache(clear);
    }

    public static void setProdid(String val) {
        prodid = val;
    }

    public static void fireCheck() throws TzException {
        TzServerUtil.getInstance().getcache().checkData();
    }

    public static List<String> updateData(String tzdataUrl) throws TzException {
        TzServerUtil util = TzServerUtil.getInstance();
        Differ diff = new Differ();
        TzConfigImpl newConfig = new TzConfigImpl();
        ((TzConfigImpl)TzServerUtil.getTzConfig()).copyTo(newConfig);
        newConfig.setTzdataUrl(tzdataUrl);
        CachedData cd = TzServerUtil.getDataSource(newConfig);
        List<Differ.DiffListEntry> dles = diff.compare(cd, util.getcache());
        ArrayList<String> out = new ArrayList<String>();
        if (dles == null) {
            out.add("No data returned");
            return out;
        }
        for (Differ.DiffListEntry dle : dles) {
            out.add(dle.toShortString());
        }
        if (dles.size() == 0) {
            return out;
        }
        try {
            DatatypeFactory dtf = DatatypeFactory.newInstance();
            XMLGregorianCalendar xgc = dtf.newXMLGregorianCalendar(new GregorianCalendar());
            xgc.setFractionalSecond(null);
            String dtstamp = xgc.normalize().toXMLFormat();
            util.getcache().updateData(dtstamp, dles);
            TzServerUtil.fireRefresh(false);
            return out;
        }
        catch (TzException te) {
            throw te;
        }
        catch (Throwable t) {
            throw new TzException(t);
        }
    }

    public static List<String> compareData(String tzdataUrl) throws TzException {
        TzServerUtil util = TzServerUtil.getInstance();
        Differ diff = new Differ();
        TzConfigImpl newConfig = new TzConfigImpl();
        ((TzConfigImpl)TzServerUtil.getTzConfig()).copyTo(newConfig);
        newConfig.setTzdataUrl(tzdataUrl);
        CachedData cd = TzServerUtil.getDataSource(newConfig);
        List<Differ.DiffListEntry> dles = diff.compare(cd, util.getcache());
        ArrayList<String> out = new ArrayList<String>();
        if (dles == null) {
            out.add("No data returned");
            return out;
        }
        for (Differ.DiffListEntry dle : dles) {
            out.add(dle.toShortString());
        }
        return out;
    }

    public static CachedData getDataSource(TzConfig config) throws TzException {
        String tzdataUrl = config.getTzdataUrl();
        if (tzdataUrl == null) {
            logger.error("No tz data url");
            return null;
        }
        if (tzdataUrl.endsWith(".zip")) {
            return new ZipCachedData(config);
        }
        return new FileCachedData(config);
    }

    public static List<Stat> getStats() throws TzException {
        ArrayList<Stat> stats = new ArrayList<Stat>();
        stats.add(new Stat("Gets", String.valueOf(gets)));
        stats.add(new Stat("Hits", String.valueOf(cacheHits)));
        stats.add(new Stat("Name lists", String.valueOf(nameLists)));
        stats.add(new Stat("Reads", String.valueOf(reads)));
        stats.add(new Stat("conversions", String.valueOf(conversions), String.valueOf(conversionsMillis)));
        stats.add(new Stat("tzfetches", String.valueOf(tzfetches)));
        stats.add(new Stat("tzreloads", String.valueOf(reloads), String.valueOf(reloadsMillis)));
        stats.add(new Stat("expands", String.valueOf(expands), String.valueOf(expandsMillis)));
        if (TzServerUtil.getInstance().getcache() != null) {
            stats.addAll(TzServerUtil.getInstance().getcache().getStats());
        }
        return stats;
    }

    public void stop() throws TzException {
        if (this.cache != null) {
            this.cache.stop();
        }
    }

    public String getDtstamp() throws TzException {
        String dtst = this.getcache().getDtstamp();
        if (dtst != null) {
            return dtst;
        }
        return DateTimeUtil.rfcDateTimeUTC((java.util.Date)new DateTime(lastDataFetch));
    }

    public SortedSet<String> getNames() throws TzException {
        ++nameLists;
        return this.getcache().getNameList();
    }

    public String getTz(String name) throws TzException {
        return this.getcache().getCachedVtz(name);
    }

    public Collection<String> getAllTzs() throws TzException {
        return this.getcache().getAllCachedVtzs();
    }

    public String getAliasedTz(String name) throws TzException {
        return this.getcache().getAliasedCachedVtz(name);
    }

    public String getAliasesStr() throws TzException {
        return this.getcache().getAliasesStr();
    }

    public SortedSet<String> findAliases(String tzid) throws TzException {
        return this.getcache().findAliases(tzid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUtc(String time, String tzid) throws Throwable {
        String utc;
        if (DateTimeUtil.isISODateTimeUTC((String)time)) {
            return time;
        }
        if (!DateTimeUtil.isISODateTime((String)time)) {
            return null;
        }
        ++conversions;
        long smillis = System.currentTimeMillis();
        net.fortuna.ical4j.model.TimeZone tz = this.fetchTimeZone(tzid);
        SimpleDateFormat formatTd = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
        formatTd.setTimeZone((TimeZone)tz);
        java.util.Date date = formatTd.parse(time);
        Calendar calendar = cal;
        synchronized (calendar) {
            cal.clear();
            cal.setTime(date);
            StringBuilder sb = new StringBuilder();
            TzServerUtil.digit4(sb, cal.get(1));
            TzServerUtil.digit2(sb, cal.get(2) + 1);
            TzServerUtil.digit2(sb, cal.get(5));
            sb.append('T');
            TzServerUtil.digit2(sb, cal.get(11));
            TzServerUtil.digit2(sb, cal.get(12));
            TzServerUtil.digit2(sb, cal.get(13));
            sb.append('Z');
            utc = sb.toString();
        }
        conversionsMillis += System.currentTimeMillis() - smillis;
        return utc;
    }

    public String convertDateTime(String dateTime, String fromTzid, String toTzid) throws Throwable {
        String UTCdt = null;
        if (DateTimeUtil.isISODateTimeUTC((String)dateTime)) {
            UTCdt = dateTime;
        } else {
            if (!DateTimeUtil.isISODateTime((String)dateTime)) {
                return null;
            }
            if (toTzid == null) {
                return null;
            }
            UTCdt = this.getUtc(dateTime, fromTzid);
            --conversions;
        }
        ++conversions;
        long smillis = System.currentTimeMillis();
        java.util.Date dt = DateTimeUtil.fromISODateTimeUTC((String)UTCdt);
        net.fortuna.ical4j.model.TimeZone tz = this.fetchTimeZone(toTzid);
        if (tz == null) {
            return null;
        }
        String cdt = DateTimeUtil.isoDateTime((java.util.Date)dt, (TimeZone)tz);
        conversionsMillis += System.currentTimeMillis() - smillis;
        return cdt;
    }

    public List<TimezoneType> getTimezones(String[] tzids) throws TzException {
        return this.getcache().getTimezones(tzids);
    }

    public List<TimezoneType> getTimezones(String changedSince) throws TzException {
        return this.getcache().getTimezones(changedSince);
    }

    public List<TimezoneType> findTimezones(String name) throws TzException {
        return this.getcache().findTimezones(name);
    }

    public ExpandedMapEntry getExpanded(String tzid, String start, String end, boolean oldForm) throws Throwable {
        ++expandFetches;
        ExpandedMapEntryKey emek = oldForm ? this.makeExpandedKey(tzid, start, end) : new ExpandedMapEntryKey(tzid, XcalUtil.getIcalFormatDateTime((String)start), XcalUtil.getIcalFormatDateTime((String)end));
        ExpandedMapEntry tzs = this.getcache().getExpanded(emek);
        if (tzs != null) {
            ++expandHits;
            return tzs;
        }
        long smillis = System.currentTimeMillis();
        net.fortuna.ical4j.model.TimeZone tz = this.fetchTimeZone(tzid);
        if (tz == null) {
            return null;
        }
        VTimeZone vtz = tz.getVTimeZone();
        DateTime dtstart = new DateTime(emek.getStart());
        DateTime dtend = new DateTime(emek.getEnd());
        dtstart.setTimeZone(tz);
        dtend.setTimeZone(tz);
        Period p = new Period(dtstart, dtend);
        ComponentList cl = vtz.getObservances();
        TreeSet<ObservanceWrapper> obws = new TreeSet<ObservanceWrapper>();
        for (Object o : cl) {
            Observance ob = (Observance)o;
            PeriodList pl = ob.calculateRecurrenceSet(p);
            for (Object po : pl) {
                Period onsetPer = (Period)po;
                ObservanceType ot = new ObservanceType();
                ot.setName(ob.getName());
                ot.setOnset(XcalUtil.getXmlFormatDateTime((String)onsetPer.getStart().toString()));
                ot.setUtcOffsetFrom((int)(ob.getOffsetFrom().getOffset().getOffset() / 1000L));
                ot.setUtcOffsetTo((int)(ob.getOffsetTo().getOffset().getOffset() / 1000L));
                obws.add(new ObservanceWrapper(ot));
            }
        }
        ExpandedTimezoneType etzt = new ExpandedTimezoneType();
        etzt.setDtstamp(this.getDtstamp());
        if (!oldForm) {
            etzt.setTzid(tzid);
        }
        for (ObservanceWrapper ow : obws) {
            if (etzt.getObservances() == null) {
                etzt.setObservances(new ArrayList());
            }
            etzt.getObservances().add(ow.ot);
        }
        tzs = new ExpandedMapEntry(String.valueOf(smillis), etzt);
        this.getcache().setExpanded(emek, tzs);
        expandsMillis += System.currentTimeMillis() - smillis;
        ++expands;
        return tzs;
    }

    private String delimited(UtcOffset val) {
        String offset = val.toString();
        int pos = 0;
        StringBuilder sb = new StringBuilder();
        if (offset.startsWith("-") || offset.startsWith("+")) {
            sb.append(offset.charAt(0));
            pos = 1;
        }
        sb.append(offset.substring(pos, pos + 2));
        sb.append(':');
        sb.append(offset.substring(pos += 2, pos + 2));
        if ((pos += 2) < offset.length()) {
            sb.append(':');
            sb.append(offset.substring(pos, pos + 2));
        }
        return sb.toString();
    }

    public net.fortuna.ical4j.model.TimeZone fetchTimeZone(String tzid) throws TzException {
        ++tzfetches;
        return this.getcache().getTimeZone(tzid);
    }

    public static String getCalHdr() {
        return "BEGIN:VCALENDAR\nVERSION:2.0\nCALSCALE:GREGORIAN\nPRODID:" + prodid + "\n";
    }

    public static String getCalTlr() {
        return "END:VCALENDAR\n";
    }

    public String getEtag() throws TzException {
        StringBuilder val = new StringBuilder();
        val.append("\"");
        val.append(this.getDtstamp());
        val.append("\"");
        return val.toString();
    }

    private ExpandedMapEntryKey makeExpandedKey(String tzid, String start, String end) throws TzException {
        String e;
        Date startDate = this.makeStartDateFromYear(start);
        String st = startDate + "T000000Z";
        if (st.compareTo(e = this.makeEndDateFromYear(startDate, end) + "T000000Z") >= 0) {
            throw new TzException(400, "badly formed date range");
        }
        return new ExpandedMapEntryKey(tzid, st, e);
    }

    private Date makeStartDateFromYear(String val) throws TzException {
        if (val == null) {
            return new Date();
        }
        try {
            return new Date(val + "0101");
        }
        catch (Throwable t) {
            throw new TzException(400, "badly formed date " + val);
        }
    }

    private Date makeEndDateFromYear(Date start, String val) throws TzException {
        if (val == null) {
            Dur dur = new Dur("P520W");
            return new Date(dur.getTime(new java.util.Date(start.getTime())));
        }
        try {
            return new Date(val + "0101");
        }
        catch (Throwable t) {
            throw new TzException(400, "badly formed date " + val);
        }
    }

    private CachedData getcache() throws TzException {
        if (this.cache == null) {
            this.getcache(false);
        }
        return this.cache;
    }

    private void getcache(boolean clear) throws TzException {
        TzConfig cfg = TzServerUtil.getTzConfig();
        if (cfg == null) {
            logger.error("No config data");
            return;
        }
        try {
            this.cache = new LdbCachedData(cfg, clear);
        }
        catch (TzException te) {
            logger.error((Throwable)te);
            this.cache = null;
        }
        if (this.cache == null) {
            this.cache = TzServerUtil.getDataSource(cfg);
        }
    }

    private static void digit2(StringBuilder sb, int val) throws Throwable {
        if (val > 99) {
            throw new Exception("Bad date");
        }
        if (val < 10) {
            sb.append("0");
        }
        sb.append(val);
    }

    private static void digit4(StringBuilder sb, int val) throws Throwable {
        if (val > 9999) {
            throw new Exception("Bad date");
        }
        if (val < 10) {
            sb.append("000");
        } else if (val < 100) {
            sb.append("00");
        } else if (val < 1000) {
            sb.append("0");
        }
        sb.append(val);
    }

    static {
        locker = new Object();
        prodid = "/bedework.org//NONSGML Bedework//EN";
        cal = Calendar.getInstance();
        try {
            utctz = net.fortuna.ical4j.model.TimeZone.getTimeZone((String)"Etc/UTC");
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to initialise UTC timezone");
        }
        cal.setTimeZone(utctz);
    }

    private static class ObservanceWrapper
    implements Comparable<ObservanceWrapper> {
        ObservanceType ot;

        ObservanceWrapper(ObservanceType ot) {
            this.ot = ot;
        }

        @Override
        public int compareTo(ObservanceWrapper o) {
            return this.ot.getOnset().compareTo(o.ot.getOnset());
        }
    }
}

