/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.timezones.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.bedework.timezones.common.AbstractCachedData;
import org.bedework.timezones.common.Differ;
import org.bedework.timezones.common.TzConfig;
import org.bedework.timezones.common.TzException;
import org.bedework.timezones.common.TzServerUtil;
import org.bedework.timezones.common.db.TzAlias;
import org.bedework.util.calendar.XcalUtil;

public class ZipCachedData
extends AbstractCachedData {
    private ZipFile tzDefsZipFile;
    private File tzDefsFile;

    public ZipCachedData(TzConfig cfg) throws TzException {
        super(cfg, "Zip");
        this.loadData();
    }

    @Override
    public void stop() throws TzException {
    }

    @Override
    public String getSource() throws TzException {
        return null;
    }

    @Override
    public void checkData() throws TzException {
        this.loadData();
    }

    @Override
    public void updateData(String dtstamp, List<Differ.DiffListEntry> dles) throws TzException {
    }

    @Override
    public List<String> findIds(String val) throws TzException {
        ArrayList<String> ids = new ArrayList<String>();
        return ids;
    }

    private synchronized void loadData() throws TzException {
        try {
            String[] infoLines;
            long smillis = System.currentTimeMillis();
            File f = this.getdata();
            ZipFile zf = new ZipFile(f);
            if (this.tzDefsZipFile != null) {
                try {
                    this.tzDefsZipFile.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.tzDefsFile != null) {
                try {
                    this.tzDefsFile.delete();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.tzDefsFile = f;
            this.tzDefsZipFile = zf;
            TzServerUtil.lastDataFetch = System.currentTimeMillis();
            ZipEntry ze = this.tzDefsZipFile.getEntry("info.txt");
            String info = this.entryToString(ze);
            for (String s : infoLines = info.split("\n")) {
                if (!s.startsWith("buildTime=")) continue;
                Object bt = s.substring("buildTime=".length());
                if (!((String)bt).endsWith("Z")) {
                    bt = (String)bt + "Z";
                }
                this.dtstamp = XcalUtil.getXmlFormatDateTime((String)bt);
            }
            this.aliasMaps = this.buildAliasMaps(this.tzDefsZipFile);
            this.unzipTzs(this.tzDefsZipFile, this.dtstamp);
            this.expansions.clear();
            TzServerUtil.reloadsMillis += System.currentTimeMillis() - smillis;
            ++TzServerUtil.reloads;
        }
        catch (Throwable t) {
            throw new TzException(t);
        }
    }

    private AbstractCachedData.AliasMaps buildAliasMaps(ZipFile tzDefsZipFile) throws TzException {
        try {
            ZipEntry ze = tzDefsZipFile.getEntry("aliases.txt");
            AbstractCachedData.AliasMaps maps = new AbstractCachedData.AliasMaps();
            maps.aliasesStr = this.entryToString(ze);
            maps.byTzid = new HashMap<String, SortedSet<String>>();
            maps.byAlias = new HashMap<String, TzAlias>();
            maps.aliases = new Properties();
            StringReader sr = new StringReader(maps.aliasesStr);
            maps.aliases.load(sr);
            for (String a : maps.aliases.stringPropertyNames()) {
                String val = maps.aliases.getProperty(a);
                if (val == null) continue;
                String[] vals = val.split(",");
                TzAlias ta = new TzAlias(a);
                for (String id : vals) {
                    ta.addTargetId(id);
                    SortedSet<String> as = maps.byTzid.get(id);
                    if (as == null) {
                        as = new TreeSet<String>();
                        maps.byTzid.put(id, as);
                    }
                    as.add(a);
                }
                maps.byAlias.put(a, ta);
            }
            return maps;
        }
        catch (Throwable t) {
            throw new TzException(t);
        }
    }

    private void unzipTzs(ZipFile tzDefsZipFile, String dtstamp) throws TzException {
        try {
            this.resetTzs();
            Enumeration<? extends ZipEntry> zes = tzDefsZipFile.entries();
            while (zes.hasMoreElements()) {
                String n;
                ZipEntry ze = zes.nextElement();
                if (ze.isDirectory() || !(n = ze.getName()).startsWith("zoneinfo/") || !n.endsWith(".ics")) continue;
                String id = n.substring(9, n.length() - 4);
                this.processSpec(id, this.entryToString(ze), null, null);
            }
        }
        catch (Throwable t) {
            throw new TzException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getdata() throws TzException {
        File file;
        String dataUrl = this.cfg.getTzdataUrl();
        if (dataUrl == null) {
            throw new TzException("No data url defined");
        }
        if (!dataUrl.startsWith("http:")) {
            return new File(dataUrl);
        }
        DefaultHttpClient client = new DefaultHttpClient();
        HttpGet get = new HttpGet(dataUrl);
        HttpResponse resp = client.execute((HttpUriRequest)get);
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            int num;
            is = resp.getEntity().getContent();
            File f = File.createTempFile("bwtzserver", "zip");
            fos = new FileOutputStream(f);
            byte[] buff = new byte[4096];
            while ((num = is.read(buff)) >= 0) {
                if (num <= 0) continue;
                fos.write(buff, 0, num);
            }
            file = f;
        }
        catch (Throwable throwable) {
            try {
                fos.close();
                is.close();
                throw throwable;
            }
            catch (Throwable t) {
                throw new TzException(t);
            }
        }
        fos.close();
        is.close();
        return file;
    }

    private String entryToString(ZipEntry ze) throws Throwable {
        int num;
        InputStreamReader is = new InputStreamReader(this.tzDefsZipFile.getInputStream(ze), "UTF-8");
        StringWriter sw = new StringWriter();
        char[] buff = new char[4096];
        while ((num = is.read(buff)) >= 0) {
            if (num <= 0) continue;
            sw.write(buff, 0, num);
        }
        is.close();
        return sw.toString();
    }
}

