/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.timezones.common.db;

import java.util.Collection;
import org.bedework.timezones.common.db.TzDbentity;
import org.bedework.util.misc.ToString;
import org.bedework.util.misc.Util;

public class LocalizedString
extends TzDbentity<LocalizedString> {
    private String lang;
    private String value;

    public LocalizedString() {
    }

    public LocalizedString(String lang, String value) {
        this.lang = lang;
        this.value = value;
    }

    public void setLang(String val) {
        this.lang = val;
    }

    public String getLang() {
        return this.lang;
    }

    public void setValue(String val) {
        this.value = val;
    }

    public String getValue() {
        return this.value;
    }

    protected static LocalizedString findLang(String lang, Collection<? extends LocalizedString> c) {
        if (c == null) {
            return null;
        }
        for (LocalizedString localizedString : c) {
            String slang = localizedString.getLang();
            if (!slang.equals(lang)) continue;
            return localizedString;
        }
        return null;
    }

    public boolean update(LocalizedString from) {
        boolean changed = false;
        if (!Util.equalsString((String)this.getLang(), (String)from.getLang())) {
            this.setLang(from.getLang());
            changed = true;
        }
        if (!Util.equalsString((String)this.getValue(), (String)from.getValue())) {
            this.setValue(from.getValue());
            changed = true;
        }
        return changed;
    }

    public boolean checkNulls() {
        boolean changed = false;
        String str = Util.checkNull((String)this.getLang());
        if (!Util.equalsString((String)str, (String)this.getLang())) {
            this.setLang(str);
            changed = true;
        }
        if (!Util.equalsString((String)(str = Util.checkNull((String)this.getValue())), (String)this.getValue())) {
            this.setValue(str);
            changed = true;
        }
        return changed;
    }

    @Override
    public int compareTo(LocalizedString that) {
        if (that == this) {
            return 0;
        }
        if (that == null) {
            return -1;
        }
        int res = Util.cmpObjval((Comparable)((Object)this.getLang()), (Comparable)((Object)that.getLang()));
        if (res != 0) {
            return res;
        }
        return Util.cmpObjval((Comparable)((Object)this.getValue()), (Comparable)((Object)that.getValue()));
    }

    @Override
    public int hashCode() {
        int hc = 7;
        if (this.getLang() != null) {
            hc *= this.getLang().hashCode();
        }
        if (this.getValue() != null) {
            hc *= this.getValue().hashCode();
        }
        return hc;
    }

    @Override
    protected void toStringSegment(ToString ts) {
        super.toStringSegment(ts);
        ts.append("lang", (Object)this.getLang());
        ts.append("value", (Object)this.getValue());
    }

    @Override
    public Object clone() {
        return new LocalizedString(this.getLang(), this.getValue());
    }
}

