/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.timezones.common.es;

import java.util.Set;
import org.bedework.timezones.common.db.LocalizedString;
import org.bedework.timezones.common.db.TzAlias;
import org.bedework.timezones.common.db.TzDbSpec;
import org.bedework.util.elasticsearch.DocBuilderBase;
import org.bedework.util.elasticsearch.EsDocInfo;
import org.bedework.util.indexing.IndexException;
import org.bedework.util.misc.Util;

public class DocBuilder
extends DocBuilderBase {
    public static final String docTypeTzAlias = "tzalias";
    public static final String docTypeTzSpec = "tzspec";

    protected DocBuilder() throws IndexException {
    }

    EsDocInfo makeDoc(TzAlias ent) throws IndexException {
        try {
            this.startObject();
            this.makeField("aliasId", ent.getAliasId());
            this.makeField("targetIds", ent.getTargetIds());
            this.endObject();
            return this.makeDocInfo(docTypeTzAlias, 0L, ent.getAliasId());
        }
        catch (IndexException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new IndexException(t);
        }
    }

    EsDocInfo makeDoc(TzDbSpec ent) throws IndexException {
        try {
            this.startObject();
            this.makeField("name", ent.getName());
            this.makeField("etag", ent.getEtag());
            this.makeField("dtstamp", ent.getDtstamp());
            this.makeField("source", ent.getSource());
            this.makeField("active", ent.getActive());
            this.makeField("vtimezone", ent.getVtimezone());
            this.makeField("displayNames", ent.getDisplayNames());
            this.endObject();
            return this.makeDocInfo(docTypeTzSpec, 0L, ent.getName());
        }
        catch (IndexException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new IndexException(t);
        }
    }

    protected void makeField(String id, Set<LocalizedString> val) throws IndexException {
        if (Util.isEmpty(val)) {
            return;
        }
        this.startArray(id);
        for (LocalizedString ls : val) {
            this.makeField(null, ls);
        }
        this.endArray();
    }

    private void makeField(String id, LocalizedString val) throws IndexException {
        if (val == null) {
            return;
        }
        if (id == null) {
            this.startObject();
        } else {
            this.startObject(id);
        }
        this.makeField("lang", val.getLang());
        this.makeField("value", val.getValue());
        this.endObject();
    }
}

