/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.timezones.common.es;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.bedework.timezones.common.db.LocalizedString;
import org.bedework.timezones.common.db.TzAlias;
import org.bedework.timezones.common.db.TzDbSpec;
import org.bedework.util.elasticsearch.EntityBuilderBase;
import org.bedework.util.indexing.IndexException;
import org.bedework.util.misc.Util;

public class EntityBuilder
extends EntityBuilderBase {
    protected EntityBuilder(Map<String, ?> fields, long version) throws IndexException {
        super(fields, version);
    }

    TzDbSpec makeSpec() throws IndexException {
        TzDbSpec spec = new TzDbSpec();
        spec.setName(this.getString("name"));
        spec.setEtag(this.getString("etag"));
        spec.setDtstamp(this.getString("dtstamp"));
        spec.setSource(this.getString("source"));
        spec.setActive(this.getBool("active"));
        spec.setVtimezone(this.getString("vtimezone"));
        spec.setDisplayNames(this.getLocalizedStrings("displayNames"));
        return spec;
    }

    TzAlias makeAlias() throws IndexException {
        TzAlias alias = new TzAlias();
        alias.setAliasId(this.getString("aliasId"));
        alias.setTargetIds(this.getStringList("targetIds"));
        return alias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<LocalizedString> getLocalizedStrings(String id) throws IndexException {
        List vals = this.getFieldValues(id);
        if (Util.isEmpty((Collection)vals)) {
            return null;
        }
        TreeSet<LocalizedString> lss = new TreeSet<LocalizedString>();
        for (Object o : vals) {
            this.pushFields(o);
            try {
                String uid = this.getString("lang");
                lss.add(new LocalizedString(this.getString("lang"), this.getString("value")));
            }
            finally {
                this.popFields();
            }
        }
        return lss;
    }
}

