/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.timezones.common.es;

import org.bedework.timezones.common.TzConfig;
import org.bedework.timezones.common.db.TzAlias;
import org.bedework.timezones.common.db.TzDbSpec;
import org.bedework.timezones.common.es.DocBuilder;
import org.bedework.util.elasticsearch.DocBuilderBase;
import org.bedework.util.elasticsearch.EsDocInfo;
import org.bedework.util.elasticsearch.EsUtil;
import org.bedework.util.elasticsearch.IndexProperties;
import org.bedework.util.indexing.IndexException;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.RestHighLevelClient;

public class Indexer
implements Logged {
    private final EsUtil utils;
    private final TzConfig config;
    private RestHighLevelClient client;
    private BwLogger logger = new BwLogger();

    public Indexer(TzConfig config) throws IndexException {
        this.utils = new EsUtil((IndexProperties)config);
        this.config = config;
    }

    public void index(Object val) throws IndexException {
        EsDocInfo edi = null;
        DocBuilder db = new DocBuilder();
        if (val instanceof DocBuilderBase.UpdateInfo) {
            edi = db.makeDoc((DocBuilderBase.UpdateInfo)val);
        }
        if (val instanceof TzAlias) {
            edi = db.makeDoc((TzAlias)val);
        }
        if (val instanceof TzDbSpec) {
            edi = db.makeDoc((TzDbSpec)val);
        }
        if (edi == null) {
            throw new IndexException("Unknown class: " + val.getClass());
        }
        IndexResponse resp = this.utils.indexDoc(edi, this.config.getIndexName());
        if (this.debug()) {
            if (resp == null) {
                this.debug("IndexResponse: resp=null");
            } else {
                this.debug("IndexResponse: index=" + resp.getIndex() + " id=" + resp.getId() + " type=" + resp.getType() + " version=" + resp.getVersion());
            }
        }
    }

    private RestHighLevelClient getClient() throws IndexException {
        if (this.client != null) {
            return this.client;
        }
        this.client = this.utils.getClient();
        return this.client;
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }
}

