/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.timezones.common.leveldb;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.bedework.timezones.common.AbstractCachedData;
import org.bedework.timezones.common.CachedData;
import org.bedework.timezones.common.Differ;
import org.bedework.timezones.common.Stat;
import org.bedework.timezones.common.TzConfig;
import org.bedework.timezones.common.TzException;
import org.bedework.timezones.common.TzServerUtil;
import org.bedework.timezones.common.db.LocalizedString;
import org.bedework.timezones.common.db.TzAlias;
import org.bedework.timezones.common.db.TzDbSpec;
import org.bedework.util.calendar.XcalUtil;
import org.bedework.util.misc.Util;
import org.bedework.util.timezones.DateTimeUtil;
import org.bedework.util.timezones.Timezones;
import org.bedework.util.timezones.TimezonesImpl;
import org.bedework.util.timezones.TzNoPrimaryException;
import org.bedework.util.timezones.TzUnknownHostException;
import org.bedework.util.timezones.model.LocalNameType;
import org.bedework.util.timezones.model.TimezoneListType;
import org.bedework.util.timezones.model.TimezoneType;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.impl.Iq80DBFactory;

public class LdbCachedData
extends AbstractCachedData {
    private boolean running;
    protected ObjectMapper mapper = new ObjectMapper();
    protected static final Object dbLock = new Object();
    protected DB db;
    private static final String timezoneSpecPrefix = "TZ:";
    private static final String aliasPrefix = "AL:";
    protected boolean open;
    private long reloads;
    private long primaryFetches;
    private long lastFetchCt;
    private String lastFetchStatus = "None";
    private String lastConfigLevelDbPath;
    private String levelDbPath;
    private UpdateThread updater;

    public LdbCachedData(TzConfig cfg, boolean clear) throws TzException {
        super(cfg, "Db");
        try {
            if (this.debug()) {
                this.mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss'Z'");
            this.mapper.setDateFormat((DateFormat)df);
            this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        catch (Throwable t) {
            throw new TzException(t);
        }
        this.info("Load leveldb timezone data");
        this.loadData(clear);
        this.running = true;
        if (!cfg.getPrimaryServer()) {
            this.info("start timezone data update thread");
            this.updater = new UpdateThread("DbdataUpdater");
            this.updater.start();
        }
    }

    @Override
    public void stop() throws TzException {
        this.running = false;
        if (!this.cfg.getPrimaryServer()) {
            if (this.updater == null) {
                this.error("Already stopped");
                return;
            }
            this.updater.interrupt();
            this.updater = null;
            this.info("************************************************************");
            this.info(" * TZdb cache updater terminated ");
            this.info("************************************************************");
        }
    }

    @Override
    public String getSource() throws TzException {
        return this.cfg.getSource();
    }

    @Override
    public List<Stat> getStats() throws TzException {
        ArrayList<Stat> stats = new ArrayList<Stat>();
        stats.addAll(super.getStats());
        stats.add(new Stat("Db reloads", String.valueOf(this.reloads)));
        stats.add(new Stat("Db primary fetches", String.valueOf(this.primaryFetches)));
        stats.add(new Stat("Db last fetch count", String.valueOf(this.lastFetchCt)));
        stats.add(new Stat("Db last fetch status", this.lastFetchStatus));
        return stats;
    }

    @Override
    public void checkData() throws TzException {
        if (this.updater != null) {
            this.updater.interrupt();
        }
    }

    @Override
    public void updateData(String dtstamp, List<Differ.DiffListEntry> dles) throws TzException {
        if (Util.isEmpty(dles)) {
            return;
        }
        try {
            AbstractCachedData.AliasMaps amaps = this.buildAliasMaps();
            for (Differ.DiffListEntry dle : dles) {
                this.updateFromDiffEntry(dtstamp, amaps, dle);
            }
            this.cfg.setDtstamp(dtstamp);
            TzServerUtil.saveConfig();
        }
        catch (TzException te) {
            this.fail();
            throw te;
        }
        catch (Throwable t) {
            this.fail();
            throw new TzException(t);
        }
    }

    @Override
    public List<String> findIds(String val) throws TzException {
        try {
            this.open();
            ArrayList<String> ids = new ArrayList<String>();
            ids.addAll(this.findTzs(val));
            List<TzAlias> as = this.findTzAliases(val);
            for (TzAlias a : as) {
                ids.addAll(a.getTargetIds());
            }
            ArrayList<String> arrayList = ids;
            return arrayList;
        }
        catch (TzException te) {
            this.fail();
            throw te;
        }
        catch (Throwable t) {
            this.fail();
            throw new TzException(t);
        }
        finally {
            this.close();
        }
    }

    public void putTzAlias(TzAlias val) throws TzException {
        this.db.put(Iq80DBFactory.bytes((String)(aliasPrefix + val.getAliasId())), this.bytesJson(val));
    }

    public void removeTzAlias(TzAlias val) throws TzException {
        this.db.delete(Iq80DBFactory.bytes((String)(aliasPrefix + val.getAliasId())));
    }

    public TzAlias getTzAlias(String val) throws TzException {
        byte[] aliasBytes = this.db.get(Iq80DBFactory.bytes((String)(aliasPrefix + val)));
        if (aliasBytes == null) {
            return null;
        }
        return this.getJson(aliasBytes, TzAlias.class);
    }

    public List<TzAlias> findTzAliases(String val) throws TzException {
        try {
            ArrayList<TzAlias> aliases = new ArrayList<TzAlias>();
            try (DBIterator it = this.db.iterator();){
                it.seekToFirst();
                while (it.hasNext()) {
                    String id;
                    String key = Iq80DBFactory.asString((byte[])((byte[])it.peekNext().getKey()));
                    if (key.startsWith(aliasPrefix) && (id = key.substring(aliasPrefix.length())).contains(val)) {
                        TzAlias alias = this.getJson((byte[])it.peekNext().getValue(), TzAlias.class);
                        aliases.add(alias);
                    }
                    it.next();
                }
            }
            return aliases;
        }
        catch (Throwable t) {
            throw new TzException(t);
        }
    }

    public List<String> findTzs(String val) throws TzException {
        try {
            ArrayList<String> ids = new ArrayList<String>();
            try (DBIterator it = this.db.iterator();){
                it.seekToFirst();
                while (it.hasNext()) {
                    String tzid;
                    String key = Iq80DBFactory.asString((byte[])((byte[])it.peekNext().getKey()));
                    if (key.startsWith(timezoneSpecPrefix) && (tzid = key.substring(timezoneSpecPrefix.length())).contains(val)) {
                        ids.add(tzid);
                    }
                    it.next();
                }
            }
            return ids;
        }
        catch (Throwable t) {
            throw new TzException(t);
        }
    }

    public void putTzSpec(TzDbSpec val) throws TzException {
        this.db.put(Iq80DBFactory.bytes((String)(timezoneSpecPrefix + val.getName())), this.bytesJson(val));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DB open() throws TzException {
        Object object = dbLock;
        synchronized (object) {
            while (true) {
                if (!this.isOpen()) {
                    this.getDb();
                    this.open = true;
                    return this.db;
                }
                if (this.debug()) {
                    this.debug("Wait for db");
                }
                try {
                    dbLock.wait(3000L);
                }
                catch (Throwable t) {
                    throw new TzException(t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        Object object = dbLock;
        synchronized (object) {
            if (this.open) {
                this.closeDb();
                this.open = false;
            }
            dbLock.notify();
        }
    }

    private void fail() {
    }

    private boolean isOpen() {
        return this.open;
    }

    protected void checkOpen() throws TzException {
        if (!this.isOpen()) {
            throw new TzException("Session call when closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadData(boolean clear) throws TzException {
        Object object = dbLock;
        synchronized (object) {
            ++this.reloads;
            try {
                block22: {
                    try {
                        this.open();
                        if (!clear) break block22;
                        try (DBIterator iterator = this.getDb().iterator();){
                            iterator.seekToFirst();
                            while (iterator.hasNext()) {
                                this.getDb().delete((byte[])iterator.peekNext().getKey());
                                iterator.next();
                            }
                        }
                    }
                    finally {
                        this.close();
                    }
                }
                if (!this.cfg.getPrimaryServer()) {
                    this.updateFromPrimary();
                } else if (clear) {
                    this.loadInitialData();
                }
                this.dtstamp = this.cfg.getDtstamp();
                TzServerUtil.lastDataFetch = System.currentTimeMillis();
                this.aliasMaps = this.buildAliasMaps();
                this.processSpecs(this.dtstamp);
                this.expansions.clear();
            }
            catch (TzException te) {
                this.fail();
                throw te;
            }
            catch (Throwable t) {
                this.fail();
                throw new TzException(t);
            }
            finally {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean updateFromPrimary() throws TzException {
        if (this.debug()) {
            this.debug("Updating from primary");
        }
        try {
            TimezoneListType tzl;
            if (this.cfg.getPrimaryServer()) {
                if (this.debug()) {
                    this.debug("We are a primary: exit");
                }
                return true;
            }
            if (this.cfg.getPrimaryUrl() == null) {
                this.warn("No primary URL: exit");
                return true;
            }
            TimezonesImpl tzs = new TimezonesImpl();
            tzs.init(this.cfg.getPrimaryUrl());
            String changedSince = this.cfg.getDtstamp();
            long startTime = System.currentTimeMillis();
            long fetchTime = 0L;
            try {
                tzl = tzs.getList(changedSince);
            }
            catch (TzNoPrimaryException tznpe) {
                this.error("Unable to contact primary: " + tznpe.getExtra());
                return false;
            }
            catch (TzUnknownHostException tuhe) {
                this.error("Unknown host exception contacting " + this.cfg.getPrimaryUrl());
                return false;
            }
            catch (Throwable t) {
                this.error("Exception contacting " + this.cfg.getPrimaryUrl());
                this.error(t);
                return false;
            }
            String svrCs = tzl.getSynctoken();
            if (changedSince == null || !svrCs.equals(changedSince)) {
                this.cfg.setDtstamp(svrCs);
                TzServerUtil.saveConfig();
            }
            ++this.primaryFetches;
            this.lastFetchCt = tzl.getTimezones().size();
            String isAre = "are";
            String theS = "s";
            if (this.lastFetchCt == 1L) {
                isAre = "is";
                theS = "";
            }
            this.info("There " + isAre + " " + this.lastFetchCt + " timezone" + theS + " to fetch");
            ArrayList<TzEntry> tzEntries = new ArrayList<TzEntry>();
            try {
                this.open();
                for (TimezoneType sum : tzl.getTimezones()) {
                    TzEntry entry = new TzEntry();
                    entry.id = sum.getTzid();
                    entry.sum = sum;
                    if (this.debug()) {
                        this.debug("Get db spec for timezone " + entry.id);
                    }
                    entry.dbspec = this.getSpec(entry.id);
                    tzEntries.add(entry);
                }
            }
            finally {
                this.close();
            }
            for (TzEntry entry : tzEntries) {
                if (this.debug()) {
                    this.debug("Fetching timezone " + entry.id);
                }
                String etag = null;
                if (entry.dbspec != null) {
                    etag = entry.dbspec.getEtag();
                }
                long startFetch = System.currentTimeMillis();
                Timezones.TaggedTimeZone ttz = tzs.getTimeZone(entry.id, etag);
                fetchTime += System.currentTimeMillis() - startFetch;
                if (ttz != null && ttz.vtz == null) continue;
                if (ttz == null) {
                    this.warn("Received timezone id " + entry.id + " but not available.");
                    continue;
                }
                entry.ttz = ttz;
            }
            AbstractCachedData.AliasMaps amaps = this.buildAliasMaps();
            try {
                this.open();
                for (TzEntry entry : tzEntries) {
                    TzAlias tza;
                    boolean add;
                    if (this.debug()) {
                        this.debug("Processing timezone " + entry.id);
                    }
                    if (entry.ttz == null) {
                        if (!this.debug()) continue;
                        this.debug("No change.");
                        continue;
                    }
                    boolean bl = add = entry.dbspec == null;
                    if (add) {
                        entry.dbspec = new TzDbSpec();
                    }
                    entry.dbspec.setName(entry.id);
                    entry.dbspec.setEtag(entry.ttz.etag);
                    entry.dbspec.setDtstamp(DateTimeUtil.rfcDateTimeUTC((Date)entry.sum.getLastModified()));
                    entry.dbspec.setSource(this.cfg.getPrimaryUrl());
                    entry.dbspec.setActive(true);
                    entry.dbspec.setVtimezone(entry.ttz.vtz);
                    if (!Util.isEmpty((Collection)entry.sum.getLocalNames())) {
                        Set<Object> dns;
                        if (add) {
                            dns = new TreeSet();
                            entry.dbspec.setDisplayNames(dns);
                        } else {
                            dns = entry.dbspec.getDisplayNames();
                            dns.clear();
                        }
                        for (LocalNameType ln : entry.sum.getLocalNames()) {
                            LocalizedString ls = new LocalizedString(ln.getLang(), ln.getValue());
                            dns.add(ls);
                        }
                    }
                    this.putTzSpec(entry.dbspec);
                    SortedSet<String> aliases = amaps.byTzid.get(entry.id);
                    if (!Util.isEmpty((Collection)entry.sum.getAliases())) {
                        for (String a : entry.sum.getAliases()) {
                            tza = amaps.byAlias.get(a);
                            if (tza == null) {
                                tza = new TzAlias(a);
                            }
                            tza.addTargetId(entry.id);
                            this.putTzAlias(tza);
                            if (aliases == null) continue;
                            aliases.remove(a);
                        }
                    }
                    if (aliases == null) continue;
                    for (String alias : aliases) {
                        tza = this.getTzAlias(alias);
                        this.removeTzAlias(tza);
                    }
                }
            }
            finally {
                this.close();
            }
            this.info("Total time: " + TzServerUtil.printableTime(System.currentTimeMillis() - startTime));
            this.info("Fetch time: " + TzServerUtil.printableTime(fetchTime));
            this.lastFetchStatus = "Success";
        }
        catch (TzException tze) {
            this.lastFetchStatus = "Failed";
            throw tze;
        }
        catch (Throwable t) {
            this.lastFetchStatus = "Failed";
            throw new TzException(t);
        }
        return true;
    }

    private void updateFromDiffEntry(String dtstamp, AbstractCachedData.AliasMaps amaps, Differ.DiffListEntry dle) throws TzException {
        try {
            this.open();
            String id = dle.tzid;
            if (!dle.aliasChangeOnly) {
                TzDbSpec dbspec = this.getSpec(id);
                if (dbspec != null) {
                    if (dle.add) {
                        throw new TzException("Inconsistent change list");
                    }
                } else {
                    if (!dle.add) {
                        throw new TzException("Inconsistent change list");
                    }
                    dbspec = new TzDbSpec();
                    dbspec.setName(id);
                }
                dbspec.setDtstamp(dtstamp);
                dbspec.setSource(this.cfg.getPrimaryUrl());
                dbspec.setActive(true);
                dbspec.setVtimezone(TzServerUtil.getCalHdr() + dle.tzSpec + TzServerUtil.getCalTlr());
                this.putTzSpec(dbspec);
            }
            if (Util.isEmpty(dle.aliases)) {
                return;
            }
            SortedSet<String> aliases = amaps.byTzid.get(id);
            for (String a : dle.aliases) {
                TzAlias alias = this.getTzAlias(a);
                if (alias == null) {
                    alias = new TzAlias(a);
                }
                alias.addTargetId(id);
                this.putTzAlias(alias);
                aliases.remove(a);
            }
            for (String alias : aliases) {
                TzAlias tza = this.getTzAlias(alias);
                this.removeTzAlias(tza);
            }
        }
        catch (TzException tze) {
            throw tze;
        }
        catch (Throwable t) {
            throw new TzException(t);
        }
        finally {
            this.close();
        }
    }

    private boolean loadInitialData() throws TzException {
        try {
            this.open();
            if (this.debug()) {
                this.debug("Loading initial data from " + this.cfg.getTzdataUrl());
            }
            CachedData cachedData = TzServerUtil.getDataSource(this.cfg);
            this.cfg.setDtstamp(cachedData.getDtstamp());
            this.cfg.setSource(cachedData.getSource());
            TzServerUtil.saveConfig();
            List<TimezoneType> tzs = cachedData.getTimezones((String)null);
            if (this.debug()) {
                this.debug("Initial load has " + tzs.size() + " timezones");
            }
            int ct = 0;
            for (TimezoneType tz : tzs) {
                if (tz.getAliases() != null) {
                    for (String a : tz.getAliases()) {
                        TzAlias alias = this.getTzAlias(a);
                        if (alias == null) {
                            alias = new TzAlias(a);
                        }
                        alias.addTargetId(tz.getTzid());
                        this.putTzAlias(alias);
                    }
                }
                TzDbSpec spec = new TzDbSpec();
                spec.setName(tz.getTzid());
                spec.setVtimezone(TzServerUtil.getCalHdr() + cachedData.getCachedVtz(tz.getTzid()) + TzServerUtil.getCalTlr());
                if (spec.getVtimezone() == null) {
                    this.error("No timezone spec for " + tz.getTzid());
                }
                spec.setDtstamp(cachedData.getDtstamp());
                spec.setEtag(cachedData.getDtstamp());
                spec.setActive(true);
                this.putTzSpec(spec);
                if (!this.debug() || ++ct % 25 != 0) continue;
                this.debug("Initial load has processed " + ct + " timezones");
            }
            if (this.debug()) {
                this.debug("Initial load processed " + ct + " timezones");
            }
            boolean bl = true;
            return bl;
        }
        catch (TzException te) {
            this.error("Unable to add tz data to db", te);
            throw te;
        }
        finally {
            this.close();
        }
    }

    private TzDbSpec getSpec(String id) throws TzException {
        byte[] specBytes = this.db.get(Iq80DBFactory.bytes((String)(timezoneSpecPrefix + id)));
        if (specBytes == null) {
            return null;
        }
        return this.getJson(specBytes, TzDbSpec.class);
    }

    private AbstractCachedData.AliasMaps buildAliasMaps() throws TzException {
        try {
            this.open();
            AbstractCachedData.AliasMaps maps = new AbstractCachedData.AliasMaps();
            maps.byTzid = new HashMap<String, SortedSet<String>>();
            maps.byAlias = new HashMap<String, TzAlias>();
            maps.aliases = new Properties();
            StringBuilder aliasStr = new StringBuilder();
            try (DBIterator it = this.db.iterator();){
                it.seekToFirst();
                while (it.hasNext()) {
                    String key = Iq80DBFactory.asString((byte[])((byte[])it.peekNext().getKey()));
                    if (key.startsWith(aliasPrefix)) {
                        TzAlias alias = this.getJson((byte[])it.peekNext().getValue(), TzAlias.class);
                        String aliasId = alias.getAliasId();
                        StringBuilder ids = new StringBuilder();
                        String delim = "";
                        for (String s : alias.getTargetIds()) {
                            ids.append(delim);
                            String id = this.escape(s);
                            ids.append(id);
                            delim = ",";
                            SortedSet<String> as = maps.byTzid.get(id);
                            if (as == null) {
                                as = new TreeSet<String>();
                                maps.byTzid.put(id, as);
                            }
                            as.add(aliasId);
                        }
                        aliasStr.append(this.escape(aliasId));
                        aliasStr.append('=');
                        aliasStr.append(ids.toString());
                        aliasStr.append('\n');
                        maps.aliases.setProperty(aliasId, ids.toString());
                        maps.byAlias.put(aliasId, alias);
                    }
                    it.next();
                }
            }
            maps.aliasesStr = aliasStr.toString();
            AbstractCachedData.AliasMaps aliasMaps = maps;
            return aliasMaps;
        }
        catch (Throwable t) {
            throw new TzException(t);
        }
        finally {
            this.close();
        }
    }

    private void processSpecs(String dtstamp) throws TzException {
        try {
            this.open();
            this.resetTzs();
            try (DBIterator it = this.db.iterator();){
                it.seekToFirst();
                while (it.hasNext()) {
                    String key = Iq80DBFactory.asString((byte[])((byte[])it.peekNext().getKey()));
                    if (key.startsWith(timezoneSpecPrefix)) {
                        TzDbSpec spec = this.getJson((byte[])it.peekNext().getValue(), TzDbSpec.class);
                        Object dt = spec.getDtstamp();
                        if (!((String)dt).endsWith("Z")) {
                            dt = (String)dt + "Z";
                        }
                        this.processSpec(spec.getName(), spec.getVtimezone(), spec.getEtag(), XcalUtil.getXmlFormatDateTime((String)dt));
                    }
                    it.next();
                }
            }
        }
        catch (TzException te) {
            throw te;
        }
        catch (Throwable t) {
            throw new TzException(t);
        }
        finally {
            this.close();
        }
    }

    private DB getDb() throws TzException {
        if (this.db != null) {
            return this.db;
        }
        try {
            if (this.lastConfigLevelDbPath == null || !this.lastConfigLevelDbPath.equals(this.cfg.getLeveldbPath())) {
                File f;
                this.lastConfigLevelDbPath = this.cfg.getLeveldbPath();
                if (this.debug()) {
                    this.debug("Try to open leveldb at " + this.lastConfigLevelDbPath);
                }
                if (!(f = new File(this.lastConfigLevelDbPath)).isAbsolute()) {
                    throw new TzException("levelDbPath must be absolute - found " + this.lastConfigLevelDbPath);
                }
                this.levelDbPath = this.lastConfigLevelDbPath;
            }
            Options options = new Options();
            options.createIfMissing(true);
            this.db = Iq80DBFactory.factory.open(new File(this.levelDbPath), options);
        }
        catch (Throwable t) {
            this.error(t);
            throw new TzException(t);
        }
        return this.db;
    }

    private void closeDb() {
        if (this.db == null) {
            return;
        }
        try {
            this.db.close();
            this.db = null;
        }
        catch (Throwable t) {
            this.warn("Error closing db: " + t.getMessage());
            this.error(t);
        }
    }

    protected void writeJson(OutputStream out, Object val) throws TzException {
        try {
            this.mapper.writeValue(out, val);
        }
        catch (Throwable t) {
            throw new TzException(t);
        }
    }

    protected byte[] bytesJson(Object val) throws TzException {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.mapper.writeValue((OutputStream)os, val);
            return os.toByteArray();
        }
        catch (Throwable t) {
            throw new TzException(t);
        }
    }

    protected <T> T getJson(byte[] value, Class<T> valueType) throws TzException {
        Object object;
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(value);
            object = this.mapper.readValue((InputStream)is, valueType);
        }
        catch (Throwable t) {
            this.warn("Unable to parse json value " + new String(value));
            throw new TzException(t);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable) {}
            }
        }
        return (T)object;
    }

    private static class TzEntry {
        String id;
        TimezoneType sum;
        TzDbSpec dbspec;
        Timezones.TaggedTimeZone ttz;

        private TzEntry() {
        }
    }

    private class UpdateThread
    extends Thread {
        boolean showedTrace;

        public UpdateThread(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (LdbCachedData.this.running) {
                long refreshWait = 9999L;
                LdbCachedData ldbCachedData = LdbCachedData.this;
                synchronized (ldbCachedData) {
                    try {
                        refreshWait = LdbCachedData.this.cfg.getRefreshDelay();
                        if (LdbCachedData.this.debug()) {
                            LdbCachedData.this.debug("Updater: About to update");
                        }
                        if (!LdbCachedData.this.updateFromPrimary()) {
                            refreshWait = Math.min(refreshWait, 600L);
                        }
                    }
                    catch (Throwable t) {
                        if (!this.showedTrace) {
                            LdbCachedData.this.error(t);
                            this.showedTrace = true;
                        } else {
                            LdbCachedData.this.error(t.getMessage());
                        }
                        try {
                            LdbCachedData.this.fail();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                if (LdbCachedData.this.debug()) {
                    LdbCachedData.this.debug("Updater: About to wait for " + refreshWait + " seconds");
                }
                if (!LdbCachedData.this.running) break;
                try {
                    Object o;
                    Object object = o = new Object();
                    synchronized (object) {
                        o.wait(refreshWait * 1000L);
                    }
                }
                catch (InterruptedException ie) {
                    if (!LdbCachedData.this.debug()) continue;
                    LdbCachedData.this.debug("Updater: Interrupted ");
                }
                catch (Throwable t) {
                    LdbCachedData.this.error(t.getMessage());
                }
            }
        }
    }
}

