/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.timezones.service;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.bedework.timezones.common.Stat;
import org.bedework.timezones.common.TzConfigImpl;
import org.bedework.timezones.common.TzServerUtil;
import org.bedework.timezones.service.TzConfMBean;
import org.bedework.util.jmx.ConfBase;
import org.bedework.util.jmx.ConfigHolder;

public class TzConf
extends ConfBase<TzConfigImpl>
implements TzConfMBean,
ConfigHolder<TzConfigImpl> {
    private static final String confuriPname = "org.bedework.tzs.confuri";

    public TzConf() {
        super("org.bedework.timezones:service=Server");
        this.setConfigPname(confuriPname);
        TzServerUtil.setTzConfigHolder(this);
    }

    @Override
    public void setDtstamp(String val) {
        ((TzConfigImpl)this.getConfig()).setDtstamp(val);
    }

    @Override
    public String getDtstamp() {
        return ((TzConfigImpl)this.getConfig()).getDtstamp();
    }

    @Override
    public void setVersion(String val) {
        ((TzConfigImpl)this.getConfig()).setVersion(val);
    }

    @Override
    public String getVersion() {
        return ((TzConfigImpl)this.getConfig()).getVersion();
    }

    @Override
    public void setTzdataUrl(String val) {
        ((TzConfigImpl)this.getConfig()).setTzdataUrl(val);
    }

    @Override
    public String getTzdataUrl() {
        return ((TzConfigImpl)this.getConfig()).getTzdataUrl();
    }

    @Override
    public void setLeveldbPath(String val) {
        ((TzConfigImpl)this.getConfig()).setLeveldbPath(val);
    }

    @Override
    public String getLeveldbPath() {
        return ((TzConfigImpl)this.getConfig()).getLeveldbPath();
    }

    @Override
    public void setPrimaryUrl(String val) {
        ((TzConfigImpl)this.getConfig()).setPrimaryUrl(val);
    }

    @Override
    public String getPrimaryUrl() {
        return ((TzConfigImpl)this.getConfig()).getPrimaryUrl();
    }

    @Override
    public void setPrimaryServer(boolean val) {
        ((TzConfigImpl)this.getConfig()).setPrimaryServer(val);
    }

    @Override
    public boolean getPrimaryServer() {
        return ((TzConfigImpl)this.getConfig()).getPrimaryServer();
    }

    @Override
    public void setSource(String val) {
        ((TzConfigImpl)this.getConfig()).setSource(val);
    }

    @Override
    public String getSource() {
        return ((TzConfigImpl)this.getConfig()).getSource();
    }

    @Override
    public void setRefreshDelay(long val) {
        ((TzConfigImpl)this.getConfig()).setRefreshDelay(val);
    }

    @Override
    public long getRefreshDelay() {
        return ((TzConfigImpl)this.getConfig()).getRefreshDelay();
    }

    public void setIndexerURL(String val) {
        ((TzConfigImpl)this.getConfig()).setIndexerURL(val);
    }

    public String getIndexerURL() {
        return ((TzConfigImpl)this.getConfig()).getIndexerURL();
    }

    public void setEmbeddedIndexer(boolean val) {
        ((TzConfigImpl)this.getConfig()).setEmbeddedIndexer(val);
    }

    public boolean getEmbeddedIndexer() {
        return ((TzConfigImpl)this.getConfig()).getEmbeddedIndexer();
    }

    public void setHttpEnabled(boolean val) {
        ((TzConfigImpl)this.getConfig()).setHttpEnabled(val);
    }

    public boolean getHttpEnabled() {
        return ((TzConfigImpl)this.getConfig()).getHttpEnabled();
    }

    public void setClusterName(String val) {
        ((TzConfigImpl)this.getConfig()).setClusterName(val);
    }

    public String getClusterName() {
        return ((TzConfigImpl)this.getConfig()).getClusterName();
    }

    public void setNodeName(String val) {
        ((TzConfigImpl)this.getConfig()).setNodeName(val);
    }

    public String getNodeName() {
        return ((TzConfigImpl)this.getConfig()).getNodeName();
    }

    public void setDataDir(String val) {
        ((TzConfigImpl)this.getConfig()).setDataDir(val);
    }

    public String getDataDir() {
        return ((TzConfigImpl)this.getConfig()).getDataDir();
    }

    @Override
    public void setIndexerConfig(String val) {
        ((TzConfigImpl)this.getConfig()).setIndexerConfig(val);
    }

    @Override
    public String getIndexerConfig() {
        return ((TzConfigImpl)this.getConfig()).getIndexerConfig();
    }

    @Override
    public void setIndexName(String val) {
        ((TzConfigImpl)this.getConfig()).setIndexName(val);
    }

    @Override
    public String getIndexName() {
        return ((TzConfigImpl)this.getConfig()).getIndexName();
    }

    @Override
    public List<Stat> getStats() {
        try {
            return TzServerUtil.getStats();
        }
        catch (Throwable t) {
            this.error("Error getting stats");
            this.error(t);
            return null;
        }
    }

    @Override
    public String refreshData() {
        try {
            ((TzConfigImpl)this.getConfig()).setDtstamp(null);
            this.saveConfig();
            TzServerUtil.fireRefresh(true);
            return "Ok";
        }
        catch (Throwable t) {
            this.error(t);
            return "Refresh error: " + t.getLocalizedMessage();
        }
    }

    @Override
    public String checkData() {
        try {
            TzServerUtil.fireCheck();
            return "Ok";
        }
        catch (Throwable t) {
            this.error(t);
            return "Update error: " + t.getLocalizedMessage();
        }
    }

    @Override
    public String compareData(String tzdataUrl) {
        StringWriter sw = new StringWriter();
        try {
            PrintWriter pw = new PrintWriter(sw);
            List<String> chgs = TzServerUtil.compareData(tzdataUrl);
            for (String s : chgs) {
                pw.println(s);
            }
        }
        catch (Throwable t) {
            t.printStackTrace(new PrintWriter(sw));
        }
        return sw.toString();
    }

    @Override
    public String updateData(String tzdataUrl) {
        StringWriter sw = new StringWriter();
        try {
            PrintWriter pw = new PrintWriter(sw);
            List<String> chgs = TzServerUtil.updateData(tzdataUrl);
            for (String s : chgs) {
                pw.println(s);
            }
        }
        catch (Throwable t) {
            t.printStackTrace(new PrintWriter(sw));
        }
        return sw.toString();
    }

    @Override
    public String loadConfig() {
        return this.loadOnlyConfig(TzConfigImpl.class);
    }

    public void putConfig() {
        this.saveConfig();
    }
}

