/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.timezones.server;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bedework.timezones.common.TzConfig;
import org.bedework.timezones.common.TzServerUtil;
import org.bedework.timezones.server.MethodBase;
import org.bedework.util.timezones.model.CapabilitiesAcceptParameterType;
import org.bedework.util.timezones.model.CapabilitiesActionType;
import org.bedework.util.timezones.model.CapabilitiesInfoType;
import org.bedework.util.timezones.model.CapabilitiesTruncatedType;
import org.bedework.util.timezones.model.CapabilitiesType;

public class CapabilitiesHandler
extends MethodBase {
    static final CapabilitiesType capabilities = new CapabilitiesType();

    private static void addAction(CapabilitiesType capabilities, String action, String uriTemplate, String description, CapabilitiesAcceptParameterType ... pars) {
        CapabilitiesActionType cot = new CapabilitiesActionType();
        cot.setName(action);
        cot.setUriTemplate(uriTemplate);
        if (pars != null) {
            for (CapabilitiesAcceptParameterType par : pars) {
                cot.getParameters().add(par);
            }
        }
        capabilities.getActions().add(cot);
    }

    private static CapabilitiesAcceptParameterType makePar(String name, boolean required, boolean multi, String value, String description) {
        CapabilitiesAcceptParameterType capt = new CapabilitiesAcceptParameterType();
        capt.setName(name);
        capt.setRequired(required);
        capt.setMulti(multi);
        capt.addValue(value);
        return capt;
    }

    @Override
    public void doMethod(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        if (this.debug()) {
            this.debug("CapabilitiesHandler: doMethod");
        }
        try {
            resp.setContentType("application/json; charset=UTF-8");
            CapabilitiesInfoType ci = new CapabilitiesInfoType();
            TzConfig cfg = TzServerUtil.getTzConfig();
            if (!cfg.getPrimaryServer()) {
                ci.setPrimarySource(TzServerUtil.getTzConfig().getPrimaryUrl());
            } else {
                ci.setSource(cfg.getSource());
            }
            ci.getFormats().add("text/calendar");
            ci.getFormats().add("application/calendar+xml");
            ci.getFormats().add("application/calendar+json");
            CapabilitiesTruncatedType ct = new CapabilitiesTruncatedType();
            ct.setAny(false);
            ct.setUntruncated(true);
            ci.setTruncated(ct);
            capabilities.setInfo(ci);
            this.writeJson(resp, capabilities);
        }
        catch (ServletException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    static {
        capabilities.setVersion(1);
        CapabilitiesHandler.addAction(capabilities, "capabilities", "/capabilities", "This action returns the capabilities of the server, allowing clients to determine if a specific feature has been deployed and/or enabled.", new CapabilitiesAcceptParameterType[0]);
        CapabilitiesHandler.addAction(capabilities, "list", "/zones{?changedsince}", "This action lists all timezone identifiers, in summary format, with optional localized data. In addition, it returns a timestamp which is the current server global last modification value. ", CapabilitiesHandler.makePar("changedsince", false, false, null, "OPTIONAL, but MUST occur only once. If present, limits the response to timezones changed since the given timestamp."));
        CapabilitiesHandler.addAction(capabilities, "get", "/zones{/tzid}{?start,end}", "This action returns a timezone. Clients must be prepared to accept a timezone with a different identifier if the requested identifier is an alias. ", CapabilitiesHandler.makePar("start", false, false, null, "OPTIONAL, and MUST occur only once.  Specifies the inclusive UTC date-time value at which the returned time zone data is truncated at its start."), CapabilitiesHandler.makePar("end", false, false, null, "OPTIONAL, and MUST occur only once.  Specifies the exclusive UTC date-time value at which the returned time zone data is truncated at its end."));
        CapabilitiesHandler.addAction(capabilities, "expand", "/zones{/tzid}/observances{?start,end}", "This action expands the specified timezone(s) into a list of onset start date/time and offset. ", CapabilitiesHandler.makePar("start", false, false, null, "OPTIONAL, and MUST occur only once.  Specifies the inclusive UTC date-time value at which the returned time zone data is truncated at its start."), CapabilitiesHandler.makePar("end", false, false, null, "OPTIONAL, and MUST occur only once.  Specifies the exclusive UTC date-time value at which the returned time zone data is truncated at its end."));
        CapabilitiesHandler.addAction(capabilities, "find", "/zones{?pattern}", "This action allows a client to query the timezone service for a matching identifier, alias or localized name.\nResponse format is the same as for list with one result element per successful match. ", CapabilitiesHandler.makePar("name", true, false, null, "REQUIRED, but MUST only occur once. Identifies the name to search for. Only partial matching is supported."), CapabilitiesHandler.makePar("lang", false, true, null, "OPTIONAL, but MUST occur only once. If present, indicates that timezone aliases should be returned in the list. "));
    }
}

