/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.timezones.server;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.bedework.timezones.convert.TzCnvSvc;
import org.bedework.timezones.server.GetMethod;
import org.bedework.timezones.server.OptionsMethod;
import org.bedework.timezones.server.PostMethod;
import org.bedework.timezones.service.TzConf;
import org.bedework.util.jmx.ConfBase;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.bedework.util.servlet.HttpServletUtils;

public class TzServer
extends HttpServlet
implements Logged,
HttpSessionListener,
ServletContextListener {
    protected boolean dumpContent;
    private final Configurator conf = new Configurator();
    private BwLogger logger = new BwLogger();

    public void init(ServletConfig config) throws ServletException {
        try {
            super.init(config);
            this.dumpContent = "true".equals(config.getInitParameter("dumpContent"));
        }
        catch (ServletException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String methodName = req.getMethod();
            if (this.debug()) {
                this.debug("entry: " + methodName);
                this.dumpRequest(req);
            }
            switch (methodName) {
                case "OPTIONS": {
                    new OptionsMethod().doMethod(req, resp);
                    return;
                }
                case "GET": {
                    new GetMethod().doMethod(req, resp);
                    return;
                }
                case "POST": {
                    new PostMethod().doMethod(req, resp);
                    return;
                }
                default: {
                    resp.setStatus(403);
                    return;
                }
            }
        }
        finally {
            try {
                HttpSession sess = req.getSession(false);
                if (sess != null) {
                    sess.invalidate();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public void dumpRequest(HttpServletRequest req) {
        try {
            String title = "Request headers";
            this.debug(title);
            HttpServletUtils.dumpHeaders((HttpServletRequest)req);
            Enumeration names = req.getParameterNames();
            title = "Request parameters";
            this.debug(title + " - global info and uris");
            this.debug("getRemoteAddr = " + req.getRemoteAddr());
            this.debug("getRequestURI = " + req.getRequestURI());
            this.debug("getRemoteUser = " + req.getRemoteUser());
            this.debug("getRequestedSessionId = " + req.getRequestedSessionId());
            this.debug("HttpUtils.getRequestURL(req) = " + req.getRequestURL());
            this.debug("contextPath=" + req.getContextPath());
            this.debug("query=" + req.getQueryString());
            this.debug("contentlen=" + req.getContentLength());
            this.debug("request=" + req);
            this.debug("parameters:");
            this.debug(title);
            while (names.hasMoreElements()) {
                String key = (String)names.nextElement();
                String val = req.getParameter(key);
                this.debug("  " + key + " = \"" + val + "\"");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void contextInitialized(ServletContextEvent sce) {
        this.conf.start();
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.conf.stop();
    }

    public void sessionCreated(HttpSessionEvent se) {
    }

    public void sessionDestroyed(HttpSessionEvent se) {
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(((Object)((Object)this)).getClass());
        }
        return this.logger;
    }

    class Configurator
    extends ConfBase {
        TzConf tzConf;
        TzCnvSvc cnv;

        public Configurator() {
            super("org.bedework.timezones:service=TzSvr");
        }

        public String loadConfig() {
            return null;
        }

        public void start() {
            try {
                Configurator.getManagementContext().start();
                this.tzConf = new TzConf();
                this.register("tzConf", "tzConf", this.tzConf);
                this.tzConf.loadConfig();
                this.cnv = new TzCnvSvc();
                this.register("tzCnvSvc", "tzCnvSvc", this.cnv);
                this.cnv.loadConfig();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        public void stop() {
            try {
                Configurator.getManagementContext().stop();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

