/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.timezones.server;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bedework.timezones.common.TzServerUtil;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.bedework.util.timezones.model.ErrorResponseType;
import org.bedework.util.timezones.model.TimezoneListType;
import org.bedework.util.timezones.model.TimezoneType;

public abstract class MethodBase
implements Logged {
    protected static final ErrorResponseType invalidTzid = new ErrorResponseType("invalid-tzid", "The \"tzid\" query parameter is not present, or appears more than once.");
    protected static final ErrorResponseType missingTzid = new ErrorResponseType("missing-tzid", "The \"tzid\" query parameter value does not map to a timezone identifier known to the server.");
    protected static final ErrorResponseType invalidStart = new ErrorResponseType("invalid-start", "The \"start\" query parameter has an incorrect value, or appears more than once.");
    protected static final ErrorResponseType invalidEnd = new ErrorResponseType("invalid-end", "The \"end\" query parameter has an incorrect value, or appears more than once, or has a value less than our equal to the \"start\" query parameter.");
    protected static final ErrorResponseType invalidChangedsince = new ErrorResponseType("invalid-changedsince", "The \"changedsince\" query parameter has an incorrect value, or appears more than once.");
    protected static final ErrorResponseType invalidListTzid = new ErrorResponseType("invalid-tzid", "The \"tzid\" query parameter is present along with the \"changedsince\", or has an incorrect value.");
    protected ObjectMapper mapper = new ObjectMapper();
    protected TzServerUtil util;
    private BwLogger logger = new BwLogger();

    public MethodBase() throws ServletException {
        try {
            if (this.debug()) {
                this.mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss'Z'");
            this.mapper.setDateFormat((DateFormat)df);
            this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            this.util = TzServerUtil.getInstance();
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    public abstract void doMethod(HttpServletRequest var1, HttpServletResponse var2) throws ServletException;

    public ResourceUri getResourceUri(HttpServletRequest req) throws ServletException {
        String uri = req.getPathInfo();
        if (uri == null || uri.length() == 0) {
            uri = "/";
        }
        if (this.debug()) {
            this.debug("uri: " + uri);
        }
        ResourceUri resourceUri = MethodBase.fixPath(uri);
        if (this.debug()) {
            this.debug("resourceUri: " + resourceUri.uri);
        }
        return resourceUri;
    }

    public static ResourceUri fixPath(String path) throws ServletException {
        Object decoded;
        if (path == null) {
            return new ResourceUri();
        }
        try {
            decoded = URLDecoder.decode(path, "UTF8");
        }
        catch (Throwable t) {
            throw new ServletException("bad path: " + path);
        }
        if (decoded == null) {
            return new ResourceUri();
        }
        if (((String)decoded).indexOf(92) >= 0) {
            decoded = ((String)decoded).replace('\\', '/');
        }
        if (!((String)decoded).startsWith("/")) {
            decoded = "/" + (String)decoded;
        }
        while (((String)decoded).contains("//")) {
            decoded = ((String)decoded).replaceAll("//", "/");
        }
        StringTokenizer st = new StringTokenizer((String)decoded, "/");
        ArrayList<String> al = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equals(".")) continue;
            if (s.equals("..")) {
                if (al.size() == 0) {
                    return new ResourceUri();
                }
                al.remove(al.size() - 1);
                continue;
            }
            al.add(s);
        }
        ResourceUri ruri = new ResourceUri();
        for (String s : al) {
            ruri.addPathElement(s);
        }
        return ruri;
    }

    protected void listResponse(HttpServletResponse resp, List<TimezoneType> tzs) throws ServletException {
        try {
            resp.setContentType("application/json; charset=UTF-8");
            TimezoneListType tzl = new TimezoneListType();
            tzl.setSynctoken(this.util.getDtstamp());
            if (tzl.getTimezones() == null) {
                tzl.setTimezones(new ArrayList());
            }
            tzl.getTimezones().addAll(tzs);
            this.writeJson(resp, tzl);
        }
        catch (ServletException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    protected void errorResponse(HttpServletResponse resp, int servletError, String errorCode, String description) throws ServletException {
        this.errorResponse(resp, servletError, new ErrorResponseType(errorCode, description));
    }

    protected void errorResponse(HttpServletResponse resp, int servletError, ErrorResponseType error) throws ServletException {
        resp.setStatus(servletError);
        this.writeJson(resp, error);
    }

    protected void writeJson(HttpServletResponse resp, Object val) throws ServletException {
        try {
            this.mapper.writeValue((OutputStream)resp.getOutputStream(), val);
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }

    public static class ResourceUri {
        public String uri;
        public final List<String> uriElements = new ArrayList<String>();

        public ResourceUri() {
            this.uri = "";
        }

        public ResourceUri(String uri) {
            this.uri = uri;
        }

        public void addPathElement(String val) {
            this.uriElements.add(val);
            this.uri = this.uri + "/" + val;
        }

        public String getPathElement(int i) {
            if (i > this.uriElements.size()) {
                return null;
            }
            return this.uriElements.get(i);
        }

        public String getElements(int i) {
            if (i >= this.uriElements.size()) {
                return null;
            }
            Object uri = "";
            for (int x = i; x < this.uriElements.size(); ++x) {
                if (x > i) {
                    uri = (String)uri + "/";
                }
                uri = (String)uri + this.uriElements.get(x);
            }
            return uri;
        }
    }
}

