/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.timezones.server;

import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bedework.timezones.common.TzServerUtil;
import org.bedework.timezones.server.MethodBase;

public class TzidHandler
extends MethodBase {
    @Override
    public void doMethod(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        if (this.debug()) {
            this.debug("TzidHandler: doMethod");
        }
        this.doTzid(resp, req.getParameter("tzid"));
    }

    void doTzid(HttpServletResponse resp, String tzid) throws ServletException {
        if (tzid == null) {
            this.errorResponse(resp, 400, invalidTzid);
            return;
        }
        try {
            resp.setContentType("text/calendar; charset=UTF-8");
            PrintWriter wtr = resp.getWriter();
            String tz = this.util.getTz(tzid);
            if (tz == null) {
                tz = this.util.getAliasedTz(tzid);
            }
            if (tz == null) {
                resp.setStatus(404);
            } else {
                resp.setHeader("ETag", "\"" + this.util.getDtstamp() + "\"");
                this.writeCalHdr(wtr);
                ((Writer)wtr).write(tz);
                this.writeCalTlr(wtr);
            }
        }
        catch (ServletException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    private void writeCalHdr(Writer wtr) throws Throwable {
        wtr.write(TzServerUtil.getCalHdr());
    }

    private void writeCalTlr(Writer wtr) throws Throwable {
        wtr.write(TzServerUtil.getCalTlr());
    }
}

