/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.dav;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.message.BasicHeader;
import org.bedework.util.http.HttpUtil;
import org.bedework.util.http.PooledHttpClient;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.bedework.util.misc.Util;
import org.bedework.util.xml.XmlEmit;
import org.bedework.util.xml.XmlUtil;
import org.bedework.util.xml.tagdefs.WebdavTags;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class DavUtil
implements Logged,
Serializable {
    public static final int SC_MULTI_STATUS = 207;
    public static final Header depth0 = new BasicHeader("depth", "0");
    public static final Header depth1 = new BasicHeader("depth", "1");
    public static final Header depthinf = new BasicHeader("depth", "infinity");
    protected List<Header> extraHeaders;
    private final Set<String> nameSpaces = new TreeSet<String>();
    private final BwLogger logger = new BwLogger();

    public DavUtil() {
        this.addNs("DAV:");
    }

    public DavUtil(List<Header> extraHeaders) {
        this();
        if (!Util.isEmpty(extraHeaders)) {
            this.extraHeaders = new ArrayList<Header>(extraHeaders);
        }
    }

    public void addNs(String val) {
        this.nameSpaces.add(val);
    }

    public MultiStatusResponse getMultiStatusResponse(String val) {
        return this.getMultiStatusResponse(new ByteArrayInputStream(val.getBytes(StandardCharsets.UTF_8)));
    }

    public MultiStatusResponse getExtMkcolResponse(String val) {
        return this.getExtMkcolResponse(new ByteArrayInputStream(val.getBytes(StandardCharsets.UTF_8)));
    }

    public MultiStatusResponse getMultiStatusResponse(InputStream in) {
        MultiStatusResponse res = new MultiStatusResponse();
        Document doc = this.parseContent(in);
        Element root = doc.getDocumentElement();
        DavUtil.expect(root, WebdavTags.multistatus);
        return this.getMsrEmcr(root, res);
    }

    public MultiStatusResponse getExtMkcolResponse(InputStream in) {
        MultiStatusResponse res = new MultiStatusResponse();
        Document doc = this.parseContent(in);
        Element root = doc.getDocumentElement();
        DavUtil.expect(root, WebdavTags.mkcolResponse);
        return this.getMsrEmcr(root, res);
    }

    private MultiStatusResponse getMsrEmcr(Element root, MultiStatusResponse res) {
        List<Element> responses = DavUtil.getChildren(root);
        int count = 0;
        for (Element resp : responses) {
            ++count;
            if (XmlUtil.nodeMatches((Node)resp, (QName)WebdavTags.responseDescription)) {
                res.responseDescription = DavUtil.getElementContent(resp);
                continue;
            }
            if (XmlUtil.nodeMatches((Node)resp, (QName)WebdavTags.syncToken)) {
                res.syncToken = DavUtil.getElementContent(resp);
                continue;
            }
            if (!XmlUtil.nodeMatches((Node)resp, (QName)WebdavTags.response)) {
                throw new RuntimeException("Bad multistatus Expected (response+, responsedescription?, sync-token) found " + resp);
            }
            MultiStatusResponseElement msre = new MultiStatusResponseElement();
            res.responses.add(msre);
            Iterator<Element> elit = DavUtil.getChildren(resp).iterator();
            Element nd = elit.next();
            if (!XmlUtil.nodeMatches((Node)nd, (QName)WebdavTags.href)) {
                throw new RuntimeException("Bad response. Expected href found " + nd);
            }
            msre.href = DavUtil.getElementContent(nd);
            boolean hadStatus = false;
            while (elit.hasNext()) {
                nd = elit.next();
                if (XmlUtil.nodeMatches((Node)nd, (QName)WebdavTags.status)) {
                    hadStatus = true;
                    if (!Util.isEmpty(msre.propstats)) {
                        throw new RuntimeException("Bad response. Expected propstat found " + nd);
                    }
                    msre.status = DavUtil.httpStatus(nd);
                    continue;
                }
                if (XmlUtil.nodeMatches((Node)nd, (QName)WebdavTags.error)) {
                    if (msre.error != null) {
                        throw new RuntimeException("Bad response. Multiple error elements");
                    }
                    msre.error = nd;
                    continue;
                }
                if (XmlUtil.nodeMatches((Node)nd, (QName)WebdavTags.responseDescription)) {
                    if (msre.responseDescription != null) {
                        throw new RuntimeException("Bad response. Multiple responseDescription elements");
                    }
                    msre.responseDescription = DavUtil.getElementContent(nd);
                    continue;
                }
                if (!XmlUtil.nodeMatches((Node)nd, (QName)WebdavTags.propstat)) {
                    throw new RuntimeException("Bad response. Expected propstat found " + nd);
                }
                if (hadStatus) {
                    throw new RuntimeException("Bad response. Cannot have status and propstat");
                }
                PropstatElement pse = new PropstatElement();
                msre.propstats.add(pse);
                Iterator<Element> propstatit = DavUtil.getChildren(nd).iterator();
                Node propnd = propstatit.next();
                if (!XmlUtil.nodeMatches((Node)propnd, (QName)WebdavTags.prop)) {
                    throw new RuntimeException("Bad response. Expected prop found " + propnd);
                }
                if (!propstatit.hasNext()) {
                    throw new RuntimeException("Bad response. Expected propstat/status");
                }
                pse.status = DavUtil.httpStatus(propstatit.next());
                if (propstatit.hasNext()) {
                    Node rdesc = propstatit.next();
                    if (!XmlUtil.nodeMatches((Node)rdesc, (QName)WebdavTags.responseDescription)) {
                        throw new RuntimeException("Bad response, expected null or responsedescription. Found: " + rdesc);
                    }
                    pse.responseDescription = DavUtil.getElementContent(resp);
                }
                pse.props = DavUtil.getChildren(propnd);
            }
        }
        return res;
    }

    public Collection<DavChild> syncReport(PooledHttpClient cl, String path, String syncToken, Collection<QName> props) {
        try {
            StringWriter sw = new StringWriter();
            XmlEmit xml = this.getXml();
            this.addNs(xml, "DAV:");
            xml.startEmit((Writer)sw);
            xml.openTag(WebdavTags.syncCollection);
            if (syncToken == null) {
                xml.emptyTag(WebdavTags.syncToken);
            } else {
                xml.property(WebdavTags.syncToken, syncToken);
            }
            xml.property(WebdavTags.synclevel, "1");
            xml.openTag(WebdavTags.prop);
            xml.emptyTag(WebdavTags.getetag);
            if (props != null) {
                for (QName pr : props) {
                    if (pr.equals(WebdavTags.getetag)) continue;
                    this.addNs(xml, pr.getNamespaceURI());
                    xml.emptyTag(pr);
                }
            }
            xml.closeTag(WebdavTags.prop);
            xml.closeTag(WebdavTags.syncCollection);
            PooledHttpClient.ResponseHolder resp = cl.report(path, "0", sw.toString(), this::processSyncResponse);
            if (resp.failed) {
                return null;
            }
            return (Collection)resp.response;
        }
        catch (HttpException e) {
            throw new RuntimeException(e);
        }
    }

    final PooledHttpClient.ResponseHolder<Collection<DavChild>> processSyncResponse(String path, CloseableHttpResponse resp) {
        try {
            int status = HttpUtil.getStatus((HttpResponse)resp);
            if (status != 207) {
                return new PooledHttpClient.ResponseHolder(status, "Failed response from server");
            }
            if (resp.getEntity() == null) {
                return new PooledHttpClient.ResponseHolder(status, "No content in response from server");
            }
            InputStream is = resp.getEntity().getContent();
            Document doc = this.parseContent(is);
            Element root = doc.getDocumentElement();
            DavUtil.expect(root, WebdavTags.multistatus);
            return new PooledHttpClient.ResponseHolder(this.processResponses(DavUtil.getChildren(root), null));
        }
        catch (Throwable t) {
            return new PooledHttpClient.ResponseHolder(t);
        }
    }

    public DavChild getProps(PooledHttpClient cl, String path, Collection<QName> props) {
        return this.makeDavChild(this.propfind(cl, this.normalizePath(path), props, "0"));
    }

    public Collection<DavChild> getChildrenUrls(PooledHttpClient cl, String parentPath, Collection<QName> props) {
        URI uri;
        String path = this.normalizePath(parentPath);
        try {
            uri = new URI(path);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return this.processResponses(this.propfind(cl, path, props, "1"), uri);
    }

    public List<Element> propfind(PooledHttpClient cl, String path, Collection<QName> props, String depth) {
        try {
            StringWriter sw = new StringWriter();
            XmlEmit xml = this.getXml();
            this.addNs(xml, "DAV:");
            xml.startEmit((Writer)sw);
            xml.openTag(WebdavTags.propfind);
            xml.openTag(WebdavTags.prop);
            xml.emptyTag(WebdavTags.displayname);
            xml.emptyTag(WebdavTags.resourcetype);
            if (props != null) {
                for (QName pr : props) {
                    if (pr.equals(WebdavTags.displayname) || pr.equals(WebdavTags.resourcetype)) continue;
                    this.addNs(xml, pr.getNamespaceURI());
                    xml.emptyTag(pr);
                }
            }
            xml.closeTag(WebdavTags.prop);
            xml.closeTag(WebdavTags.propfind);
            PooledHttpClient.ResponseHolder resp = cl.propfind(path, depth, sw.toString(), this::processPropfindResponse);
            if (resp.failed) {
                if (this.debug()) {
                    this.debug("Failed: status = " + resp.status + " msg=" + resp.message);
                }
                return null;
            }
            return (List)resp.response;
        }
        catch (HttpException e) {
            throw new RuntimeException(e);
        }
    }

    final PooledHttpClient.ResponseHolder<List<Element>> processPropfindResponse(String path, CloseableHttpResponse resp) {
        try {
            int status = HttpUtil.getStatus((HttpResponse)resp);
            if (status != 207) {
                return new PooledHttpClient.ResponseHolder(status, "Failed response from server");
            }
            if (resp.getEntity() == null) {
                return new PooledHttpClient.ResponseHolder(status, "No content in response from server");
            }
            InputStream is = resp.getEntity().getContent();
            Document doc = this.parseContent(is);
            Element root = doc.getDocumentElement();
            DavUtil.expect(root, WebdavTags.multistatus);
            return new PooledHttpClient.ResponseHolder(DavUtil.getChildren(root));
        }
        catch (Throwable t) {
            return new PooledHttpClient.ResponseHolder(t);
        }
    }

    protected XmlEmit getXml() {
        XmlEmit xml = new XmlEmit();
        for (String ns : this.nameSpaces) {
            this.addNs(xml, ns);
        }
        return xml;
    }

    protected void addNs(XmlEmit xml, String val) {
        if (xml.getNameSpace(val) == null) {
            xml.addNs(new XmlEmit.NameSpace(val, null), false);
        }
    }

    protected Document parseContent(InputStream in) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new InputSource(new InputStreamReader(in)));
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    public Element parseError(InputStream in) {
        try {
            Document doc = this.parseContent(in);
            Element root = doc.getDocumentElement();
            DavUtil.expect(root, WebdavTags.error);
            List<Element> els = DavUtil.getChildren(root);
            if (els.size() != 1) {
                return null;
            }
            return els.get(0);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    public static List<Element> getChildren(Node nd) {
        return XmlUtil.getElements((Node)nd);
    }

    public static Element[] getChildrenArray(Node nd) {
        return XmlUtil.getElementsArray((Node)nd);
    }

    public static Element getOnlyChild(Node nd) {
        return XmlUtil.getOnlyElement((Node)nd);
    }

    public static String getElementContent(Element el) {
        return XmlUtil.getElementContent((Node)el);
    }

    public static boolean isEmpty(Element el) {
        return XmlUtil.isEmpty((Element)el);
    }

    public static void expect(Element el, QName tag) {
        if (!XmlUtil.nodeMatches((Node)el, (QName)tag)) {
            throw new RuntimeException("Expected " + tag);
        }
    }

    public static int httpStatus(Element el) {
        if (!XmlUtil.nodeMatches((Node)el, (QName)WebdavTags.status)) {
            throw new RuntimeException("Bad response. Expected status found " + el);
        }
        String s = DavUtil.getElementContent(el);
        if (s == null) {
            throw new RuntimeException("Bad http status. Found null");
        }
        try {
            int start = s.indexOf(" ");
            int end = s.indexOf(" ", start + 1);
            if (end < 0) {
                return Integer.parseInt(s.substring(start + 1));
            }
            return Integer.parseInt(s.substring(start + 1, end));
        }
        catch (Throwable t) {
            throw new RuntimeException("Bad http status. Found " + s);
        }
    }

    public Collection<DavChild> processResponses(Collection<Element> responses, URI parentURI) {
        if (responses == null) {
            return null;
        }
        ArrayList<DavChild> result = new ArrayList<DavChild>();
        int count = 0;
        for (Element resp : responses) {
            URI childURI;
            DavChild dc;
            ++count;
            if (XmlUtil.nodeMatches((Node)resp, (QName)WebdavTags.responseDescription)) {
                if (responses.size() <= count) continue;
                throw new RuntimeException("Bad multstatus Expected (response+, responsedescription?)");
            }
            if (XmlUtil.nodeMatches((Node)resp, (QName)WebdavTags.syncToken)) {
                dc = new DavChild();
                DavProp dp = new DavProp();
                dp.name = WebdavTags.syncToken;
                dp.element = resp;
                dp.status = 200;
                dc.propVals.add(dp);
                dc.status = 200;
                result.add(dc);
                continue;
            }
            if (!XmlUtil.nodeMatches((Node)resp, (QName)WebdavTags.response)) {
                throw new RuntimeException("Bad multstatus Expected (response+, responsedescription?) found " + resp);
            }
            dc = this.makeDavResponse(resp);
            try {
                childURI = new URI(dc.uri);
            }
            catch (URISyntaxException use) {
                throw new RuntimeException(use);
            }
            if (parentURI != null && parentURI.getPath().equals(childURI.getPath())) continue;
            result.add(dc);
        }
        return result;
    }

    private DavChild makeDavChild(Collection<Element> responseElements) {
        if (responseElements == null) {
            return null;
        }
        DavChild dc = null;
        int count = 0;
        for (Element resp : responseElements) {
            ++count;
            if (XmlUtil.nodeMatches((Node)resp, (QName)WebdavTags.responseDescription)) {
                if (responseElements.size() <= count) continue;
                throw new RuntimeException("Bad multstatus Expected (response+, responsedescription?)");
            }
            if (!XmlUtil.nodeMatches((Node)resp, (QName)WebdavTags.response)) {
                throw new RuntimeException("Bad multstatus Expected (response+, responsedescription?) found " + resp);
            }
            if (dc != null) {
                throw new RuntimeException("Bad multstatus Expected only 1 response");
            }
            dc = this.makeDavResponse(resp);
        }
        return dc;
    }

    private DavChild makeDavResponse(Element resp) {
        Iterator<Element> elit = DavUtil.getChildren(resp).iterator();
        Element nd = elit.next();
        DavChild dc = new DavChild();
        if (!XmlUtil.nodeMatches((Node)nd, (QName)WebdavTags.href)) {
            throw new RuntimeException("Bad response. Expected href found " + nd);
        }
        dc.uri = URLDecoder.decode(DavUtil.getElementContent(nd), StandardCharsets.UTF_8);
        while (elit.hasNext()) {
            Node rdesc;
            nd = elit.next();
            if (XmlUtil.nodeMatches((Node)nd, (QName)WebdavTags.status)) {
                dc.status = DavUtil.httpStatus(nd);
                continue;
            }
            dc.status = 200;
            if (!XmlUtil.nodeMatches((Node)nd, (QName)WebdavTags.propstat)) {
                throw new RuntimeException("Bad response. Expected propstat found " + nd);
            }
            Iterator<Element> propstatit = DavUtil.getChildren(nd).iterator();
            Node propnd = propstatit.next();
            if (!XmlUtil.nodeMatches((Node)propnd, (QName)WebdavTags.prop)) {
                throw new RuntimeException("Bad response. Expected prop found " + propnd);
            }
            if (!propstatit.hasNext()) {
                throw new RuntimeException("Bad response. Expected propstat/status");
            }
            int st = DavUtil.httpStatus(propstatit.next());
            if (propstatit.hasNext() && !XmlUtil.nodeMatches((Node)(rdesc = (Node)propstatit.next()), (QName)WebdavTags.responseDescription)) {
                throw new RuntimeException("Bad response, expected null or responsedescription. Found: " + rdesc);
            }
            List<Element> respProps = DavUtil.getChildren(propnd);
            for (Element pr : respProps) {
                if (XmlUtil.nodeMatches((Node)pr, (QName)WebdavTags.resourcetype)) {
                    List<Element> rtypeProps = DavUtil.getChildren(pr);
                    for (Element rtpr : rtypeProps) {
                        if (XmlUtil.nodeMatches((Node)rtpr, (QName)WebdavTags.collection)) {
                            dc.isCollection = true;
                        }
                        dc.resourceTypes.add(XmlUtil.fromNode((Node)rtpr));
                    }
                    continue;
                }
                DavProp dp = new DavProp();
                dc.propVals.add(dp);
                dp.name = new QName(pr.getNamespaceURI(), pr.getLocalName());
                dp.status = st;
                dp.element = pr;
                if (!XmlUtil.nodeMatches((Node)pr, (QName)WebdavTags.displayname)) continue;
                dc.displayName = DavUtil.getElementContent(pr);
            }
        }
        return dc;
    }

    private String normalizePath(String path) {
        if (!path.endsWith("/")) {
            return path + "/";
        }
        return path;
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }

    public static class MultiStatusResponse {
        public List<MultiStatusResponseElement> responses = new ArrayList<MultiStatusResponseElement>();
        public String responseDescription;
        public String syncToken;
    }

    public static class MultiStatusResponseElement {
        public String href;
        public int status;
        public List<PropstatElement> propstats = new ArrayList<PropstatElement>();
        public Element error;
        public String responseDescription;
    }

    public static class PropstatElement {
        public List<Element> props;
        public int status;
        public Element error;
        public String responseDescription;
    }

    public static class DavProp {
        public QName name;
        public Element element;
        public int status;
    }

    public static class DavChild
    implements Comparable<DavChild> {
        public String uri;
        public String displayName;
        public boolean isCollection;
        public List<DavProp> propVals = new ArrayList<DavProp>();
        public List<QName> resourceTypes = new ArrayList<QName>();
        public int status;

        public DavProp findProp(QName nm) {
            if (Util.isEmpty(this.propVals)) {
                return null;
            }
            for (DavProp dp : this.propVals) {
                if (!nm.equals(dp.name)) continue;
                return dp;
            }
            return null;
        }

        @Override
        public int compareTo(DavChild that) {
            if (this.isCollection != that.isCollection) {
                if (!this.isCollection) {
                    return -1;
                }
                return 1;
            }
            if (this.displayName == null) {
                return -1;
            }
            if (that.displayName == null) {
                return 1;
            }
            return this.displayName.compareTo(that.displayName);
        }
    }
}

