/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.json;

import java.util.List;
import java.util.Map;

public class JsonUtil {
    private JsonUtil() {
    }

    public static String jsonEncode(String val) {
        if (val == null || val.length() == 0) {
            return "\"\"";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        block9: for (int i = 0; i < val.length(); ++i) {
            char ch = val.charAt(i);
            switch (ch) {
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\"': 
                case '/': 
                case '\\': {
                    sb.append('\\');
                    sb.append(ch);
                    continue block9;
                }
                case ' ': {
                    sb.append(" ");
                    continue block9;
                }
                default: {
                    if (Character.isISOControl(ch)) {
                        String str = Integer.toHexString(ch);
                        sb.append("\\u");
                        sb.append("0000".substring(str.length() - 4));
                        sb.append(str);
                        continue block9;
                    }
                    sb.append(ch);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public static String jsonNameVal(String indent, String name, String val) {
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        sb.append("\"");
        sb.append(name);
        sb.append("\": ");
        if (val != null) {
            sb.append(JsonUtil.jsonEncode(val));
        }
        return sb.toString();
    }

    public static String must(String name, Map theVals) throws Exception {
        Object val = theVals.get(name);
        if (val == null) {
            throw new Exception("missing value: " + name);
        }
        return (String)val;
    }

    public static String may(String name, Map theVals) throws Exception {
        Object val = theVals.get(name);
        if (val == null) {
            return null;
        }
        return (String)val;
    }

    public static List mustList(String name, Map theVals) throws Exception {
        Object val = theVals.get(name);
        if (val == null) {
            throw new Exception("missing value: " + name);
        }
        return (List)val;
    }

    public static List mayList(String name, Map theVals) throws Exception {
        Object val = theVals.get(name);
        if (val == null) {
            return null;
        }
        return (List)val;
    }
}

