/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bedework.util.json.JsonUtil;

public class SerializableProperties {
    private static final ObjectMapper om = new ObjectMapper();
    protected Map vals;

    public void init(Map vals) throws Exception {
        this.vals = vals;
    }

    public void setProperties(String val) throws Exception {
        this.vals = val == null ? new HashMap() : this.asMap(val);
    }

    @JsonIgnore
    public String getProperties() throws Exception {
        return this.asString();
    }

    @JsonIgnore
    public Map getVals() {
        if (this.vals == null) {
            this.vals = new HashMap();
        }
        return this.vals;
    }

    public Map<?, ?> asMap(String val) throws Exception {
        this.init((Map)om.readValue(val, Object.class));
        return this.vals;
    }

    public String asString() throws Exception {
        StringWriter sw = new StringWriter();
        om.writeValue((Writer)sw, (Object)this.getVals());
        return sw.toString();
    }

    @JsonIgnore
    public Map<?, ?> getMap(String name) throws Exception {
        Object val = this.getVals().get(name);
        if (val == null) {
            throw new Exception("missing value: " + name);
        }
        return (Map)val;
    }

    public void setBoolean(String name, Boolean val) {
        this.getVals().put(name, val);
    }

    public void setInt(String name, Integer val) {
        this.getVals().put(name, val);
    }

    public void setLong(String name, Long val) {
        this.getVals().put(name, val);
    }

    public void setString(String name, String val) {
        if (val == null) {
            this.getVals().remove(name);
        } else {
            this.getVals().put(name, val);
        }
    }

    public void setObject(String name, Object val) {
        if (val == null) {
            this.getVals().remove(name);
        } else {
            this.getVals().put(name, val);
        }
    }

    public String must(String name) throws Exception {
        return JsonUtil.must(name, this.getVals());
    }

    public List<String> mustList(String name) throws Exception {
        return JsonUtil.mustList(name, this.getVals());
    }

    public String may(String name) throws Exception {
        return JsonUtil.may(name, this.getVals());
    }

    public List mayList(String name) throws Exception {
        return JsonUtil.mayList(name, this.getVals());
    }

    public List mayList(String name, Map theVals) throws Exception {
        return JsonUtil.mayList(name, theVals);
    }

    public int mayInt(String name) throws Exception {
        Object val = this.getVals().get(name);
        if (val == null) {
            return 0;
        }
        return (Integer)val;
    }

    public long mayLong(String name) throws Exception {
        Object val = this.getVals().get(name);
        if (val == null) {
            return 0L;
        }
        return (Long)val;
    }

    public boolean mayBool(String name) throws Exception {
        Object val = this.getVals().get(name);
        if (val == null) {
            return false;
        }
        return (Boolean)val;
    }
}

