/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.options;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.bedework.util.options.OptionsException;
import org.bedework.util.options.OptionsI;
import org.bedework.util.xml.XmlEmit;
import org.bedework.util.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class Options
implements OptionsI,
Logged {
    private String globalPrefix;
    private String appPrefix;
    private QName outerTag;
    private static volatile Pattern splitPathPattern = Pattern.compile("\\.");
    private boolean useSystemwideValues = true;
    private OptionsI.OptionElement optionsRoot;
    private OptionsI.OptionElement localOptionsRoot;
    private BwLogger logger = new BwLogger();

    @Override
    public void init(String globalPrefix, String appPrefix, String optionsFile, String outerTagName) throws OptionsException {
        this.init(globalPrefix, appPrefix, this.getStream(optionsFile), outerTagName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(String globalPrefix, String appPrefix, InputStream optionsFileStream, String outerTagName) throws OptionsException {
        try {
            this.globalPrefix = globalPrefix;
            this.appPrefix = appPrefix;
            this.outerTag = new QName(null, outerTagName);
            this.optionsRoot = this.parseOptions(optionsFileStream);
        }
        finally {
            if (optionsFileStream != null) {
                try {
                    optionsFileStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private InputStream getStream(String path) throws OptionsException {
        InputStream is = null;
        try {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                is = cl.getResourceAsStream(path);
            }
            catch (Throwable cl) {
                // empty catch block
            }
            if (is == null) {
                is = Options.class.getResourceAsStream(path);
            }
            if (is == null) {
                throw new OptionsException("Unable to load options file" + path);
            }
            return is;
        }
        catch (OptionsException cee) {
            throw cee;
        }
        catch (Throwable t) {
            this.error("getEnv error", t);
            throw new OptionsException(t.getMessage());
        }
    }

    @Override
    public OptionsI.OptionElement getOptions() {
        if (!this.useSystemwideValues) {
            return null;
        }
        return this.localOptionsRoot;
    }

    public OptionsI.OptionElement parseOptions(InputStream is) throws OptionsException {
        InputStreamReader rdr = null;
        try {
            rdr = new InputStreamReader(is);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(rdr));
            Element root = doc.getDocumentElement();
            if (!root.getNodeName().equals(this.outerTag.getLocalPart())) {
                throw new OptionsException("org.bedework.bad.options");
            }
            OptionsI.OptionElement oel = new OptionsI.OptionElement();
            oel.name = "root";
            this.doChildren(oel, root, new Stack<Object>());
            OptionsI.OptionElement optionElement = oel;
            return optionElement;
        }
        catch (OptionsException ce) {
            throw ce;
        }
        catch (Throwable t) {
            throw new OptionsException(t);
        }
        finally {
            if (rdr != null) {
                try {
                    ((Reader)rdr).close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void toXml(OptionsI.OptionElement root, OutputStream str) throws OptionsException {
        Writer wtr = null;
        try {
            XmlEmit xml = new XmlEmit(true);
            wtr = new OutputStreamWriter(str);
            xml.startEmit(wtr);
            xml.openTag(this.outerTag);
            for (OptionsI.OptionElement oe : root.getChildren()) {
                Options.childToXml(oe, xml);
            }
            xml.closeTag(this.outerTag);
        }
        catch (OptionsException ce) {
            throw ce;
        }
        catch (Throwable t) {
            throw new OptionsException(t);
        }
        finally {
            if (wtr != null) {
                try {
                    wtr.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private static void childToXml(OptionsI.OptionElement subRoot, XmlEmit xml) throws OptionsException {
        try {
            Object val = subRoot.val;
            QName tag = new QName(null, subRoot.name);
            if (val instanceof String || val instanceof Integer || val instanceof Long || val instanceof Boolean) {
                xml.property(tag, String.valueOf(val));
                return;
            }
            Method meth = Options.findMethod(val, "toOptionsXml");
            if (meth != null) {
                Class<?>[] parClasses = meth.getParameterTypes();
                if (parClasses.length != 1) {
                    throw new OptionsException("org.bedework.calenv.invalid.toxml");
                }
                Object[] pars = new Object[]{xml};
                meth.invoke(val, pars);
                return;
            }
            xml.openTag(tag, "class", val.getClass().getName());
            Collection<Method> getters = Options.findGetters(val);
            for (Method m : getters) {
                Options.methodToXml(m, val, xml);
            }
            xml.closeTag(tag);
        }
        catch (OptionsException ce) {
            throw ce;
        }
        catch (Throwable t) {
            throw new OptionsException(t);
        }
    }

    private static void methodToXml(Method meth, Object val, XmlEmit xml) throws OptionsException {
        try {
            String methodName = meth.getName();
            Class<?>[] parClasses = meth.getParameterTypes();
            if (parClasses.length != 0) {
                throw new OptionsException("org.bedework.calenv.invalid.getter");
            }
            String fieldName = methodName.substring(3, 3).toLowerCase() + methodName.substring(4);
            Object methVal = meth.invoke(val, (Object[])null);
            xml.property(new QName(null, fieldName), String.valueOf(methVal));
        }
        catch (OptionsException ce) {
            throw ce;
        }
        catch (Throwable t) {
            throw new OptionsException(t);
        }
    }

    @Override
    public String getAppPrefix() {
        return this.appPrefix;
    }

    @Override
    public Object getProperty(String name) throws OptionsException {
        Object val = this.getOptProperty(name);
        if (val == null) {
            throw new OptionsException("Missing property " + name);
        }
        return val;
    }

    @Override
    public Object getOptProperty(String name) throws OptionsException {
        if (this.useSystemwideValues) {
            return Options.findValue(this.optionsRoot, Options.makePathElements(name), -1);
        }
        return Options.findValue(this.localOptionsRoot, Options.makePathElements(name), -1);
    }

    @Override
    public String getStringProperty(String name) throws OptionsException {
        Object val = this.getProperty(name);
        if (!(val instanceof String)) {
            throw new OptionsException("org.bedework.calenv.bad.option.value");
        }
        return (String)val;
    }

    @Override
    public String getOptStringProperty(String name) throws OptionsException {
        Object val = this.getOptProperty(name);
        if (val == null) {
            return null;
        }
        if (!(val instanceof String)) {
            throw new OptionsException("org.bedework.calenv.bad.option.value");
        }
        return (String)val;
    }

    @Override
    public boolean getBoolProperty(String name) throws OptionsException {
        String val = this.getStringProperty(name);
        return "true".equals(val = val.toLowerCase()) || "yes".equals(val);
    }

    @Override
    public int getIntProperty(String name) throws OptionsException {
        String val = this.getStringProperty(name);
        try {
            return Integer.valueOf(val);
        }
        catch (Throwable t) {
            throw new OptionsException("org.bedework.calenv.bad.option.value");
        }
    }

    @Override
    public Object getGlobalProperty(String name) throws OptionsException {
        return this.getProperty(this.globalPrefix + name);
    }

    @Override
    public String getGlobalStringProperty(String name) throws OptionsException {
        return this.getStringProperty(this.globalPrefix + name);
    }

    @Override
    public boolean getGlobalBoolProperty(String name) throws OptionsException {
        return this.getBoolProperty(this.globalPrefix + name);
    }

    @Override
    public int getGlobalIntProperty(String name) throws OptionsException {
        return this.getIntProperty(this.globalPrefix + name);
    }

    @Override
    public Object getAppProperty(String name) throws OptionsException {
        return this.getProperty(this.appPrefix + name);
    }

    @Override
    public String getAppStringProperty(String name) throws OptionsException {
        return this.getStringProperty(this.appPrefix + name);
    }

    @Override
    public Object getAppOptProperty(String name) throws OptionsException {
        return this.getOptProperty(this.appPrefix + name);
    }

    @Override
    public String getAppOptStringProperty(String name) throws OptionsException {
        return this.getOptStringProperty(this.appPrefix + name);
    }

    @Override
    public boolean getAppBoolProperty(String name) throws OptionsException {
        return this.getBoolProperty(this.appPrefix + name);
    }

    @Override
    public int getAppIntProperty(String name) throws OptionsException {
        return this.getIntProperty(this.appPrefix + name);
    }

    @Override
    public void setValue(String optionObjectName, String optionName, Object val) throws OptionsException {
        if (!this.useSystemwideValues) {
            throw new OptionsException("cannot.set.values");
        }
        try {
            Object opts = this.getProperty(optionObjectName);
            Method meth = this.findSetter(opts, optionName);
            Object[] pars = new Object[]{val};
            meth.invoke(opts, pars);
        }
        catch (Throwable t) {
            throw new OptionsException(t);
        }
    }

    @Override
    public Object getValue(String optionObjectName, String optionName) throws OptionsException {
        if (this.useSystemwideValues) {
            throw new OptionsException("cannot.set.values");
        }
        try {
            Object opts = this.getProperty(optionObjectName);
            Method meth = Options.findGetter(opts, optionName);
            return meth.invoke(opts, (Object[])null);
        }
        catch (OptionsException ce) {
            throw ce;
        }
        catch (Throwable t) {
            throw new OptionsException(t);
        }
    }

    @Override
    public Collection<String> getNames(String name) throws OptionsException {
        if (this.useSystemwideValues) {
            return Options.getNames(this.optionsRoot, Options.makePathElements(name), -1);
        }
        return Options.getNames(this.localOptionsRoot, Options.makePathElements(name), -1);
    }

    public Collection match(String name) throws OptionsException {
        if (this.useSystemwideValues) {
            return Options.match(this.optionsRoot, Options.makePathElements(name), -1);
        }
        return Options.match(this.localOptionsRoot, Options.makePathElements(name), -1);
    }

    private static Collection<String> getNames(OptionsI.OptionElement subroot, String[] pathElements, int pos) {
        if (pos >= 0 && !pathElements[pos].equals(subroot.name)) {
            return null;
        }
        if (subroot.isValue) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>();
        if (++pos == pathElements.length) {
            for (OptionsI.OptionElement optel : subroot.getChildren()) {
                if (!optel.isValue) continue;
                res.add(optel.name);
            }
            return res;
        }
        for (OptionsI.OptionElement optel : subroot.getChildren()) {
            Collection<String> subres = Options.getNames(optel, pathElements, pos);
            if (subres == null) continue;
            res.addAll(subres);
        }
        return res;
    }

    private static Collection match(OptionsI.OptionElement subroot, String[] pathElements, int pos) {
        if (pos >= 0 && !pathElements[pos].equals(subroot.name)) {
            return null;
        }
        if (subroot.isValue) {
            if (pos + 1 != pathElements.length) {
                return null;
            }
            ArrayList<Object> res = new ArrayList<Object>();
            res.add(subroot.val);
            return res;
        }
        ArrayList<Object> res = new ArrayList<Object>();
        if (++pos == pathElements.length) {
            for (OptionsI.OptionElement optel : subroot.getChildren()) {
                if (!optel.isValue) continue;
                res.add(optel.val);
            }
            return res;
        }
        for (OptionsI.OptionElement optel : subroot.getChildren()) {
            Collection subres = Options.match(optel, pathElements, pos);
            if (subres == null) continue;
            res.addAll(subres);
        }
        return res;
    }

    private static Object findValue(OptionsI.OptionElement subroot, String[] pathElements, int pos) {
        if (pos >= 0 && !pathElements[pos].equals(subroot.name)) {
            return null;
        }
        if (subroot.isValue) {
            if (pos + 1 != pathElements.length) {
                return null;
            }
            return subroot.val;
        }
        if (++pos == pathElements.length) {
            return null;
        }
        Object singleRes = null;
        ArrayList<Object> multiRes = null;
        for (OptionsI.OptionElement optel : subroot.getChildren()) {
            Object res = Options.findValue(optel, pathElements, pos);
            if (res == null) continue;
            if (singleRes != null) {
                multiRes = new ArrayList<Object>();
                Options.appendResult(singleRes, multiRes);
                singleRes = null;
                Options.appendResult(res, multiRes);
                continue;
            }
            if (multiRes != null) {
                Options.appendResult(res, multiRes);
                continue;
            }
            singleRes = res;
        }
        if (multiRes != null) {
            return multiRes;
        }
        return singleRes;
    }

    private static void appendResult(Object res, ArrayList<Object> multiRes) {
        if (res instanceof Collection) {
            multiRes.addAll((Collection)res);
        } else {
            multiRes.add(res);
        }
    }

    private void doChildren(OptionsI.OptionElement oel, Element subroot, Stack<Object> objStack) throws OptionsException {
        try {
            if (!XmlUtil.hasChildren((Node)subroot)) {
                String ndval = XmlUtil.getElementContent((Node)subroot);
                String name = subroot.getNodeName();
                if (objStack.empty()) {
                    oel.isValue = true;
                    oel.val = ndval;
                    return;
                }
                Object val = objStack.peek();
                Method meth = this.findSetter(val, name);
                if (meth == null) {
                    oel.isValue = true;
                    oel.val = ndval;
                    return;
                }
                Class<?>[] parClasses = meth.getParameterTypes();
                if (parClasses.length != 1) {
                    this.error("Invalid setter method " + name);
                    throw new OptionsException("org.bedework.calenv.invalid.setter");
                }
                Class<?> parClass = parClasses[0];
                Object par = null;
                if (parClass.getName().equals("java.lang.String")) {
                    par = ndval;
                } else if (parClass.getName().equals("int") || parClass.getName().equals("java.lang.Integer")) {
                    par = Integer.valueOf(ndval);
                } else if (parClass.getName().equals("long") || parClass.getName().equals("java.lang.Long")) {
                    par = Long.valueOf(ndval);
                } else if (parClass.getName().equals("boolean") || parClass.getName().equals("java.lang.Boolean")) {
                    par = Boolean.valueOf(ndval);
                } else {
                    this.error("Unsupported par class for method " + name);
                    throw new OptionsException("org.bedework.calenv.unsupported.setter");
                }
                Object[] pars = new Object[]{par};
                meth.invoke(val, pars);
                return;
            }
            for (Element el : XmlUtil.getElementsArray((Node)subroot)) {
                String className = XmlUtil.getAttrVal((Element)el, (String)"classname");
                OptionsI.OptionElement valnode = new OptionsI.OptionElement();
                valnode.name = el.getNodeName();
                oel.addChild(valnode);
                if (className != null) {
                    if (!objStack.empty()) {
                        this.error("Nested classes not yet supported for element " + valnode.name + " and class " + className);
                        throw new OptionsException("org.bedework.calenv.nested.classes.unsupported");
                    }
                    try {
                        Object val = Class.forName(className).newInstance();
                        valnode.isValue = true;
                        valnode.val = val;
                        objStack.push(val);
                    }
                    catch (Throwable t) {
                        this.info("Unable to instantiate class " + className);
                        className = null;
                    }
                }
                this.doChildren(valnode, el, objStack);
                if (className == null) continue;
                objStack.pop();
            }
        }
        catch (OptionsException ce) {
            throw ce;
        }
        catch (Throwable t) {
            throw new OptionsException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] makePathElements(String val) {
        Pattern pattern = splitPathPattern;
        synchronized (pattern) {
            return splitPathPattern.split(val, 0);
        }
    }

    private Method findSetter(Object val, String name) throws OptionsException {
        String methodName = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
        Method[] meths = val.getClass().getMethods();
        Method meth = null;
        for (int i = 0; i < meths.length; ++i) {
            Method m = meths[i];
            if (!m.getName().equals(methodName)) continue;
            if (meth != null) {
                throw new OptionsException("org.bedework.calenv.multiple.setters");
            }
            meth = m;
        }
        if (meth == null) {
            return null;
        }
        return meth;
    }

    private static Method findGetter(Object val, String name) throws OptionsException {
        String methodName = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
        Method[] meths = val.getClass().getMethods();
        Method meth = null;
        for (int i = 0; i < meths.length; ++i) {
            Method m = meths[i];
            if (!m.getName().equals(methodName)) continue;
            if (meth != null) {
                throw new OptionsException("multiple getters for " + val.getClass().getName() + "." + name);
            }
            meth = m;
        }
        if (meth == null) {
            throw new OptionsException("No getters for " + val.getClass().getName() + "." + name);
        }
        return meth;
    }

    private static Method findMethod(Object val, String methodName) throws OptionsException {
        Method[] meths = val.getClass().getMethods();
        Method meth = null;
        for (int i = 0; i < meths.length; ++i) {
            Method m = meths[i];
            if (!m.getName().equals(methodName)) continue;
            if (meth != null) {
                throw new OptionsException("org.bedework.calenv.multiple.setters");
            }
            meth = m;
        }
        if (meth == null) {
            throw new OptionsException("org.bedework.calenv.no.method");
        }
        return meth;
    }

    private static Collection<Method> findGetters(Object val) throws OptionsException {
        Method[] meths = val.getClass().getMethods();
        ArrayList<Method> getters = new ArrayList<Method>();
        for (int i = 0; i < meths.length; ++i) {
            Method m = meths[i];
            if (!m.getName().startsWith("get")) continue;
            getters.add(m);
        }
        return getters;
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }
}

