/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.security;

import java.security.PrivateKey;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.bedework.util.security.PwEncryptionIntf;
import org.bedework.util.security.pki.PKITools;

public class PwEncryptionDefault
implements PwEncryptionIntf,
Logged {
    private String privKeys;
    private String pubKeys;
    private PKITools pki;
    private BwLogger logger = new BwLogger();

    public PwEncryptionDefault() throws Throwable {
        this.pki = new PKITools();
    }

    @Override
    public void init(String privKeys, String pubKeys) throws Throwable {
        this.privKeys = privKeys;
        this.pubKeys = pubKeys;
    }

    @Override
    public String encrypt(String val) throws Throwable {
        int numKeys = this.pki.countKeys(this.privKeys);
        if (this.debug()) {
            this.debug("Number of keys: " + numKeys);
        }
        int keyNum = numKeys - 1;
        String etext = this.pki.encryptWithKeyFile(this.pubKeys, val, keyNum);
        StringBuilder sb = new StringBuilder();
        sb.append(keyNum);
        sb.append("{");
        sb.append(etext);
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean match(String plain, String encrypted) throws Throwable {
        return this.encrypt(plain).equals(encrypted);
    }

    @Override
    public String decrypt(String encrypted) throws Throwable {
        int pos = encrypted.indexOf("{");
        if (pos < 0 || encrypted.lastIndexOf("}") != encrypted.length() - 1) {
            throw new Exception("org.bedework.exception.security.badpwformat");
        }
        int keyNum = Integer.valueOf(encrypted.substring(0, pos));
        return this.pki.decryptWithKeyFile(this.privKeys, encrypted.substring(pos + 1, encrypted.length() - 1), keyNum);
    }

    @Override
    public byte[] getPublicKey() throws Throwable {
        return this.pki.getPublicKey(this.pubKeys);
    }

    @Override
    public PrivateKey getPrivateKey() throws Throwable {
        return this.pki.getPrivateKey(this.privKeys);
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }
}

