/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.security.keys;

import org.bedework.util.jmx.ConfBase;
import org.bedework.util.security.keys.GenKeysConfigImpl;
import org.bedework.util.security.keys.GenKeysMBean;
import org.bedework.util.security.pki.PKITools;

public class GenKeys
extends ConfBase<GenKeysConfigImpl>
implements GenKeysMBean {
    String testText = "A variable of array type holds a reference to an object. ";

    public GenKeys(String confuriPname) {
        this.setConfigName("genkeys");
        this.setConfigPname(confuriPname);
    }

    public String getServiceName() {
        return "org.bedework.util:service=BwGenKeys";
    }

    @Override
    public void setPrivKeyFileName(String val) {
        ((GenKeysConfigImpl)this.getConfig()).setPrivKeyFileName(val);
    }

    @Override
    public String getPrivKeyFileName() {
        return ((GenKeysConfigImpl)this.getConfig()).getPrivKeyFileName();
    }

    @Override
    public void setPublicKeyFileName(String val) {
        ((GenKeysConfigImpl)this.getConfig()).setPublicKeyFileName(val);
    }

    @Override
    public String getPublicKeyFileName() {
        return ((GenKeysConfigImpl)this.getConfig()).getPublicKeyFileName();
    }

    @Override
    public GenKeysMBean.Msg genKeys() {
        GenKeysMBean.Msg infoLines = new GenKeysMBean.Msg();
        try {
            PKITools pki = new PKITools();
            if (this.getPrivKeyFileName() == null) {
                infoLines.add("Must provide a -privkey <file> parameter");
                return infoLines;
            }
            if (this.getPublicKeyFileName() == null) {
                infoLines.add("Must provide a -pubkey <file> parameter");
                return infoLines;
            }
            PKITools.RSAKeys keys = pki.genRSAKeysIntoFiles(this.getPrivKeyFileName(), this.getPublicKeyFileName(), true);
            if (keys == null) {
                infoLines.add("Generation of keys failed");
                return infoLines;
            }
            int numKeys = pki.countKeys(this.getPrivKeyFileName());
            infoLines.add("test with---->" + this.testText);
            String etext = pki.encryptWithKeyFile(this.getPublicKeyFileName(), this.testText, numKeys - 1);
            infoLines.add("encrypts to-->" + etext);
            String detext = pki.decryptWithKeyFile(this.getPrivKeyFileName(), etext, numKeys - 1);
            infoLines.add("decrypts to-->" + detext);
            if (!this.testText.equals(detext)) {
                infoLines.add("Validity check failed: encrypt/decrypt failure");
            } else {
                infoLines.add("");
                infoLines.add("Validity check succeeded");
            }
        }
        catch (Throwable t) {
            this.error(t);
            infoLines.add("Exception - check logs: " + t.getMessage());
        }
        return infoLines;
    }

    public String loadConfig() {
        return this.loadConfig(GenKeysConfigImpl.class);
    }
}

