/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.security.pki;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;

public class PKITools
implements Logged {
    private Base64 b64 = new Base64();
    Schema[] schemas = new Schema[]{new Schema(null, null, "RSA", "RSA")};
    Schema curSchema;
    private BwLogger logger = new BwLogger();

    public PKITools() {
        this.curSchema = this.schemas[0];
        if (this.curSchema.p != null) {
            Security.addProvider(this.curSchema.p);
        }
    }

    public byte[] getPublicKey(String pubKeyFile) throws PKIException {
        int keyNum = this.countKeys(pubKeyFile) - 1;
        return this.b64.decode(this.getEncryptedKey(pubKeyFile, keyNum));
    }

    public PrivateKey getPrivateKey(String privKeyFile) throws PKIException {
        int keyNum = this.countKeys(privKeyFile) - 1;
        return this.makePrivateKey(this.b64.decode(this.getEncryptedKey(privKeyFile, keyNum)));
    }

    public RSAKeys genRSAKeysIntoFiles(String privKeyFile, String pubKeyFile, boolean append) throws PKIException {
        RSAKeys keys = this.genRSAKeys();
        if (keys == null) {
            return null;
        }
        try {
            this.writeFile(pubKeyFile, this.b64.encode(keys.publicKey), append);
            if (this.trace()) {
                this.trace("Saving Private Key...");
            }
            this.writeFile(privKeyFile, this.b64.encode(keys.privateKey), append);
            return keys;
        }
        catch (Throwable t) {
            throw new PKIException(t);
        }
    }

    public RSAKeys genRSAKeys() throws PKIException {
        RSAKeys keys = new RSAKeys();
        try {
            SecureRandom secureRandom = new SecureRandom();
            secureRandom.nextBytes(new byte[1]);
            KeyPairGenerator rsaKeyGen = this.curSchema.pName == null ? KeyPairGenerator.getInstance(this.curSchema.keyFactory) : KeyPairGenerator.getInstance(this.curSchema.keyFactory, this.curSchema.pName);
            rsaKeyGen.initialize(1024, secureRandom);
            if (this.trace()) {
                this.trace("Generating keys...");
            }
            KeyPair rsaKeyPair = rsaKeyGen.generateKeyPair();
            if (this.trace()) {
                this.trace("Saving Public Key...");
            }
            keys.privateKey = rsaKeyPair.getPrivate().getEncoded();
            keys.publicKey = rsaKeyPair.getPublic().getEncoded();
            if (this.trace()) {
                this.trace("Done...");
            }
            return keys;
        }
        catch (Throwable t) {
            throw new PKIException(t);
        }
    }

    public String encryptWithKeyFile(String pubKeyFile, String item, int keyNum) throws PKIException {
        try {
            if (this.trace()) {
                this.trace("Reading Public Key from file...");
            }
            return this.encrypt(this.b64.decode(this.getEncryptedKey(pubKeyFile, keyNum)), item);
        }
        catch (Throwable t) {
            throw new PKIException(t);
        }
    }

    public String encrypt(byte[] pubKeyBytes, String item) throws PKIException {
        byte[] encryptedItem = null;
        try {
            Cipher asymmetricCipher;
            PublicKey publicKey;
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(pubKeyBytes);
            if (this.curSchema.pName == null) {
                KeyFactory kf = KeyFactory.getInstance(this.curSchema.algorithm);
                publicKey = kf.generatePublic(publicKeySpec);
                asymmetricCipher = Cipher.getInstance(this.curSchema.algorithm);
            } else {
                KeyFactory kf = KeyFactory.getInstance(this.curSchema.algorithm, this.curSchema.pName);
                publicKey = kf.generatePublic(publicKeySpec);
                asymmetricCipher = Cipher.getInstance(this.curSchema.algorithm, this.curSchema.pName);
            }
            asymmetricCipher.init(1, publicKey);
            encryptedItem = asymmetricCipher.doFinal(item.getBytes());
        }
        catch (Throwable t) {
            throw new PKIException(t);
        }
        return new String(this.b64.encode(encryptedItem));
    }

    public String decryptWithKeyFile(String privKeyFile, String hexVal, int keyNum) throws PKIException {
        try {
            return this.decrypt(this.b64.decode(this.getEncryptedKey(privKeyFile, keyNum)), hexVal);
        }
        catch (PKIException pe) {
            throw pe;
        }
        catch (Throwable t) {
            throw new PKIException(t);
        }
    }

    public String decrypt(byte[] privKeyBytes, String hexVal) throws PKIException {
        try {
            byte[] eVal = this.b64.decode(hexVal.getBytes());
            Cipher asymmetricCipher = this.curSchema.pName == null ? Cipher.getInstance(this.curSchema.algorithm) : Cipher.getInstance(this.curSchema.algorithm, this.curSchema.pName);
            asymmetricCipher.init(2, this.makePrivateKey(privKeyBytes));
            byte[] decryptedItem = asymmetricCipher.doFinal(eVal);
            return new String(decryptedItem);
        }
        catch (Throwable t) {
            throw new PKIException(t);
        }
    }

    private PrivateKey makePrivateKey(byte[] privKeyBytes) throws PKIException {
        try {
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(privKeyBytes);
            KeyFactory kf = this.curSchema.pName == null ? KeyFactory.getInstance(this.curSchema.algorithm) : KeyFactory.getInstance(this.curSchema.algorithm, this.curSchema.pName);
            return kf.generatePrivate(privateKeySpec);
        }
        catch (Throwable t) {
            throw new PKIException(t);
        }
    }

    public int countKeys(String fileName) throws PKIException {
        byte[] keys = this.getKeys(fileName);
        int foundKeys = 0;
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] != 10) continue;
            ++foundKeys;
        }
        return foundKeys;
    }

    private byte[] getEncryptedKey(String fileName, int keyNum) throws PKIException {
        byte[] keys = this.getKeys(fileName);
        int foundKeys = 0;
        int keyStart = 0;
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] != 10) continue;
            if (keyNum != foundKeys) {
                keyStart = i + 1;
                ++foundKeys;
                continue;
            }
            int keyLen = i - keyStart;
            byte[] key = new byte[keyLen];
            System.arraycopy(keys, keyStart, key, 0, keyLen);
            return key;
        }
        throw new PKIException("Invalid key number");
    }

    private byte[] getKeys(String fileName) throws PKIException {
        FileInputStream fstr = null;
        byte[] keys = null;
        try {
            fstr = new FileInputStream(fileName);
            keys = new byte[fstr.available()];
            fstr.read(keys);
        }
        catch (Throwable t) {
            throw new PKIException(t);
        }
        finally {
            if (fstr != null) {
                try {
                    fstr.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(String fileName, byte[] bs, boolean append) throws IOException {
        try (FileOutputStream fstr = null;){
            fstr = new FileOutputStream(fileName, append);
            fstr.write(bs);
            fstr.write(10);
            fstr.flush();
        }
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }

    public class RSAKeys {
        public byte[] privateKey;
        public byte[] publicKey;
    }

    public static class PKIException
    extends Throwable {
        public PKIException(Throwable t) {
            super(t);
        }

        public PKIException(String s) {
            super(s);
        }
    }

    private static class Schema {
        Provider p;
        String pName;
        String algorithm;
        String keyFactory;

        Schema(Provider p, String pName, String algorithm, String keyFactory) {
            this.p = p;
            this.pName = pName;
            this.algorithm = algorithm;
            this.keyFactory = keyFactory;
        }
    }
}

