/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.security.pki;

import org.apache.commons.codec.binary.Base64;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.bedework.util.security.pki.PKITools;

public class PkiUtil
implements Logged {
    private boolean genKeys = false;
    private boolean encrypt = false;
    private boolean decrypt = false;
    private boolean dumppublic = false;
    private String privKeyFileName;
    private String pubKeyFileName;
    private boolean append = true;
    private String inFileName;
    private String outFileName;
    private PKITools pki;
    String testText = "A variable of array type holds a reference to an object. ";
    private BwLogger logger = new BwLogger();

    String getInFileName() {
        return this.inFileName;
    }

    String getOutFileName() {
        return this.outFileName;
    }

    boolean getGenKeys() {
        return this.genKeys;
    }

    boolean getEncrypt() {
        return this.encrypt;
    }

    boolean getDecrypt() {
        return this.decrypt;
    }

    void processArgs(String[] args) throws Exception {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-genkeys")) {
                this.genKeys = true;
                continue;
            }
            if (args[i].equals("-encrypt")) {
                this.encrypt = true;
                this.decrypt = false;
                continue;
            }
            if (args[i].equals("-decrypt")) {
                this.encrypt = false;
                this.decrypt = true;
                continue;
            }
            if (args[i].equals("-append")) {
                this.append = true;
                continue;
            }
            if (args[i].equals("-nappend")) {
                this.append = false;
                continue;
            }
            if (args[i].equals("-dumppublic")) {
                this.dumppublic = true;
                continue;
            }
            if (this.argpar("-in", args, i)) {
                this.inFileName = args[++i];
                continue;
            }
            if (this.argpar("-out", args, i)) {
                this.outFileName = args[++i];
                continue;
            }
            if (this.argpar("-key", args, i)) {
                this.privKeyFileName = args[++i];
                continue;
            }
            if (this.argpar("-privkey", args, i)) {
                this.privKeyFileName = args[++i];
                continue;
            }
            if (!this.argpar("-pubkey", args, i)) continue;
            this.pubKeyFileName = args[++i];
        }
    }

    boolean argpar(String n, String[] args, int i) throws Exception {
        if (!args[i].equals(n)) {
            return false;
        }
        if (i + 1 == args.length) {
            throw new Exception("Invalid arguments");
        }
        return true;
    }

    boolean doGenKeys() throws Throwable {
        if (this.privKeyFileName == null) {
            this.error("Must provide a -privkey <file> parameter");
            return false;
        }
        if (this.pubKeyFileName == null) {
            this.error("Must provide a -pubkey <file> parameter");
            return false;
        }
        PKITools.RSAKeys keys = this.pki.genRSAKeysIntoFiles(this.privKeyFileName, this.pubKeyFileName, this.append);
        if (keys == null) {
            this.error("Generation of keys failed");
            return false;
        }
        if (this.dumppublic && !this.dumpKey(keys.publicKey)) {
            return false;
        }
        int numKeys = this.pki.countKeys(this.privKeyFileName);
        if (this.debug()) {
            this.debug("Number of keys: " + numKeys);
        }
        System.out.println("test with---->" + this.testText);
        String etext = this.pki.encryptWithKeyFile(this.pubKeyFileName, this.testText, numKeys - 1);
        System.out.println("encrypts to-->" + etext);
        String detext = this.pki.decryptWithKeyFile(this.privKeyFileName, etext, numKeys - 1);
        System.out.println("decrypts to-->" + detext);
        if (!this.testText.equals(detext)) {
            this.error("Validity check failed: encrypt/decrypt failure");
        }
        return true;
    }

    boolean doit(String[] args) throws Throwable {
        this.processArgs(args);
        this.pki = new PKITools();
        if (this.getGenKeys()) {
            return this.doGenKeys();
        }
        return false;
    }

    private boolean dumpKey(byte[] key) throws Exception {
        byte[] encoded = Base64.encodeBase64Chunked((byte[])key);
        String encText = new String(encoded);
        System.out.println("Copy the text between the delimiters");
        System.out.println("Take all below this line ----------------------->");
        System.out.println(encText);
        System.out.println("<--------------- up to and not including this line");
        byte[] decoded = Base64.encodeBase64Chunked((byte[])encText.getBytes());
        if (decoded.length != key.length) {
            this.error("Validity check failed: lengths not equal (decoded=" + decoded.length + " key=" + key.length + ")");
            this.dumpHex(decoded);
            this.error(" ");
            this.dumpHex(key);
            return false;
        }
        for (int i = 0; i < decoded.length; ++i) {
            if (decoded[i] == key[i]) continue;
            this.error("Validity check failed: byte at position " + i + " not equal");
            this.dumpHex(decoded);
            this.error(" ");
            this.dumpHex(key);
            return false;
        }
        return true;
    }

    private void dumpHex(byte[] hex) {
        int len;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < hex.length; ++i) {
            sb.append(PkiUtil.toHex(hex[i]));
        }
        int seglen = 50;
        for (int pos = 0; pos < sb.length(); pos += len) {
            len = Math.min(seglen, sb.length() - pos);
            this.error(" " + sb.substring(pos, pos + len));
        }
    }

    private static String toHex(byte b) {
        int i = b >> 4 & 0xF;
        Object tmp = i < 10 ? Integer.toString(i) : new Character((char)(65 + i - 10)).toString();
        i = b & 0xF;
        tmp = i < 10 ? (String)tmp + Integer.toString(i) : (String)tmp + new Character((char)(65 + (i - 10))).toString();
        return tmp;
    }

    public static void main(String[] args) {
        PkiUtil pkiu = new PkiUtil();
        try {
            pkiu.doit(args);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }
}

