/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.client.web.admin;

import java.util.Collection;
import java.util.List;
import org.bedework.appcommon.ConfigCommon;
import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.BwGroup;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.svc.BwAdminGroup;
import org.bedework.calfacade.svc.BwAuthUser;
import org.bedework.calfacade.svc.BwCalSuite;
import org.bedework.calfacade.svc.prefs.BwAuthUserPrefs;
import org.bedework.calfacade.svc.wrappers.BwCalSuiteWrapper;
import org.bedework.client.admin.AdminClient;
import org.bedework.client.admin.AdminClientImpl;
import org.bedework.client.admin.AdminConfig;
import org.bedework.client.web.admin.AdminUtil;
import org.bedework.client.web.admin.BwAdminActionForm;
import org.bedework.client.web.admin.BwAdminWebGlobals;
import org.bedework.client.web.rw.RwBwModule;
import org.bedework.util.webaction.Request;
import org.bedework.webcommon.BwCallback;
import org.bedework.webcommon.BwModuleState;
import org.bedework.webcommon.BwRequest;
import org.bedework.webcommon.BwSession;
import org.bedework.webcommon.BwSessionImpl;

public class AdminBwModule
extends RwBwModule {
    public AdminBwModule(String moduleName) {
        super(moduleName);
    }

    public boolean checkClient(BwRequest request, BwSession sess, String requestedUser, boolean canSwitch, ConfigCommon conf) {
        if (!conf.getPublicAdmin()) {
            throw new CalFacadeException("Admin client called for non admin app");
        }
        BwAdminWebGlobals globals = (BwAdminWebGlobals)request.getGlobals();
        BwModuleState mstate = this.getState();
        AdminClient client = (AdminClient)this.getClient();
        BwCallback cb = BwCallback.getCb((Request)request);
        String calSuiteName = null;
        if (client != null) {
            BwCalSuiteWrapper cs = AdminUtil.findCalSuite((Request)request, client);
            globals.setCurrentCalSuite(cs);
            if (cs != null) {
                boolean adminGroupImpliesApprover;
                calSuiteName = cs.getName();
                client.setCalSuite((BwCalSuite)cs);
                List approvers = client.getCalsuitePreferences().getCalsuiteApproversList();
                if (approvers.contains(request.getCurrentUser())) {
                    globals.assignCurUserApproverUser(true);
                }
                if ((adminGroupImpliesApprover = ((AdminConfig)request.getConfig()).getAdminGroupApprovers()) && cs.getGroup() != null && cs.getGroup().getAccount().equals(client.getAdminGroupName())) {
                    globals.assignCurUserApproverUser(true);
                }
            }
            globals.setCalSuiteName(calSuiteName);
            if (this.debug()) {
                if (cs != null) {
                    this.debug("Found calSuite " + cs);
                } else {
                    this.debug("No calsuite found");
                }
            }
        }
        boolean reinitClient = false;
        try {
            if (client != null) {
                BwPrincipal currentPrincipal = client.getCurrentPrincipal();
                if (currentPrincipal == null) {
                    throw new CalFacadeException("Null user for public admin.");
                }
                boolean bl = canSwitch = canSwitch || globals.getCurUserContentAdminUser() || client.isSuperUser();
                if (!requestedUser.equals(currentPrincipal.getAccount())) {
                    if (!canSwitch) {
                        return false;
                    }
                    if (this.debug()) {
                        this.debug("Client: switch user from {} to {}", new Object[]{currentPrincipal.getPrincipalRef(), requestedUser});
                    }
                    client.endTransaction();
                    client.close();
                    reinitClient = true;
                    sess.reset((Request)request);
                    cb.close(request.getRequest(), true);
                }
                if (this.debug()) {
                    this.debug("Client interface -- Found in session for {}", new Object[]{currentPrincipal.getPrincipalRef()});
                }
                if (reinitClient) {
                    if (this.debug()) {
                        this.debug("Client-- reinit for user " + requestedUser);
                    }
                    request.getModules().flushModules(request.getModuleName());
                    ((AdminClientImpl)client).reinit(request.getCurrentUser(), requestedUser, calSuiteName);
                    cb.in((Request)request);
                    mstate.setRefresh(true);
                }
            } else {
                if (this.debug()) {
                    this.debug("Client-- getResource new object for user " + requestedUser);
                }
                client = new AdminClientImpl(conf, this.getModuleName(), request.getCurrentUser(), requestedUser, calSuiteName);
                this.setClient((Client)client);
                this.setRequest((Request)request);
                this.requestIn();
                mstate.setRefresh(true);
                sess.reset((Request)request);
            }
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
        return true;
    }

    protected int actionSetup(BwRequest request) {
        int temp;
        BwAdminWebGlobals globals = (BwAdminWebGlobals)request.getGlobals();
        AdminClient cl = (AdminClient)request.getClient();
        BwAuthUser au = cl.getAuthUser(cl.getAuthPrincipal());
        if (au == null || au.isUnauthorized()) {
            return 4;
        }
        BwAuthUserPrefs prefs = au.getPrefs();
        ((BwSessionImpl)request.getSess()).setCurAuthUserPrefs(prefs);
        if (!cl.getGroupSet()) {
            globals.assignCurUserContentAdminUser(au.isContentAdminUser());
            globals.assignCurUserApproverUser(au.isApproverUser());
        }
        if (this.debug()) {
            this.info("getGroupSet()=" + cl.getGroupSet());
            this.info("-------- isSuperUser: " + cl.isSuperUser());
        }
        if ((temp = this.checkGroup(request, true)) != 9) {
            if (this.debug()) {
                this.info("form.getGroupSet()=" + cl.getGroupSet());
            }
            return temp;
        }
        return 9;
    }

    protected boolean shouldCheckNotifications(BwRequest req) {
        AdminClient cl = (AdminClient)req.getClient();
        return cl.getGroupSet();
    }

    public int checkGroup(BwRequest request, boolean initCheck) {
        BwAdminActionForm form = (BwAdminActionForm)request.getBwForm();
        AdminClient cl = (AdminClient)request.getClient();
        if (cl.getGroupSet()) {
            return 9;
        }
        try {
            if (cl.getChoosingGroup()) {
                String reqpar = request.getReqPar("adminGroupName");
                if (reqpar == null) {
                    form.assignCalSuites(cl.getContextCalSuites());
                    return 13;
                }
                BwAdminGroup adg = (BwAdminGroup)cl.findGroup(reqpar);
                if (adg == null) {
                    if (this.debug()) {
                        this.info("No user admin group with name " + reqpar);
                    }
                    form.assignCalSuites(cl.getContextCalSuites());
                    return 13;
                }
                return this.setGroup(request, adg);
            }
            BwPrincipal p = cl.getAuthPrincipal();
            if (p == null) {
                return 4;
            }
            Collection adgs = initCheck || !cl.isSuperUser() ? cl.getGroups(p) : cl.getAllGroups(false);
            if (adgs.isEmpty()) {
                boolean noGroupAllowed = ((AdminConfig)request.getConfig()).getNoGroupAllowed();
                if (cl.isSuperUser() || noGroupAllowed) {
                    cl.setAdminGroupName(null);
                    cl.setGroupSet(true);
                    return 9;
                }
                return 14;
            }
            cl.setOneGroup(false);
            if (adgs.size() == 1) {
                cl.setOneGroup(true);
                return this.setGroup(request, (BwAdminGroup)adgs.iterator().next());
            }
            request.setSessionAttr("bw_user_admin_groups", (Object)adgs);
            form.assignCalSuites(cl.getContextCalSuites());
            cl.setChoosingGroup(true);
            return 13;
        }
        catch (Throwable t) {
            request.error(t);
            return 3;
        }
    }

    private int setGroup(BwRequest request, BwAdminGroup adg) {
        AdminClient cl = (AdminClient)request.getClient();
        cl.getMembers((BwGroup)adg);
        if (this.debug()) {
            this.info("Set admin group to " + adg);
        }
        cl.setAdminGroupName(adg.getAccount());
        cl.setGroupSet(true);
        request.getBwGlobals().reset((Client)cl);
        BwPrincipal p = cl.getPrincipal(adg.getOwnerHref());
        if (p == null || !request.getModule().checkClient(request, request.getSess(), p.getAccount(), this.isMember(adg, (Request)request), cl.getConf())) {
            return 4;
        }
        return 9;
    }

    private boolean isMember(BwAdminGroup ag, Request request) {
        return ag.isMember(String.valueOf(request.getCurrentUser()), false);
    }
}

