/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.client.web.admin;

import java.util.ArrayList;
import java.util.Set;
import org.bedework.calfacade.BwGroup;
import org.bedework.calfacade.exc.CalFacadeAccessException;
import org.bedework.calfacade.svc.BwAdminGroup;
import org.bedework.calfacade.svc.wrappers.BwCalSuiteWrapper;
import org.bedework.client.admin.AdminClient;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.webaction.Request;
import org.bedework.webcommon.BwRequest;
import org.bedework.webcommon.ForwardDefs;

public class AdminUtil
implements ForwardDefs {
    private static final BwLogger logger = new BwLogger().setLoggedClass(AdminUtil.class);

    public static void embedPreferredAdminGroups(BwRequest request) {
        AdminClient cl = (AdminClient)request.getClient();
        Set prefGroupHrefs = cl.getPreferences().getPreferredGroups();
        ArrayList<BwGroup> prefGroups = new ArrayList<BwGroup>(prefGroupHrefs.size());
        for (String href : prefGroupHrefs) {
            BwGroup group = cl.getAdminGroup(href);
            if (group == null) continue;
            prefGroups.add(group);
        }
        request.setSessionAttr("bw_preferred_admin_groups", prefGroups);
    }

    public static void embedCalsuiteAdminGroups(BwRequest request) {
        AdminClient cl = (AdminClient)request.getClient();
        request.setSessionAttr("bw_suite_admin_groups", (Object)cl.getCalsuiteAdminGroups());
    }

    public static BwCalSuiteWrapper findCalSuite(Request request, AdminClient cl) {
        String groupName = cl.getAdminGroupName();
        if (groupName == null) {
            return null;
        }
        BwAdminGroup adg = (BwAdminGroup)cl.findGroup(groupName);
        return AdminUtil.findCalSuite(request, cl, adg);
    }

    private static BwCalSuiteWrapper findCalSuite(Request request, AdminClient cl, BwAdminGroup adg) {
        if (adg == null) {
            return null;
        }
        try {
            BwCalSuiteWrapper cs = cl.getCalSuite(adg);
            if (cs != null) {
                return cs;
            }
            for (BwGroup parent : cl.findGroupParents((BwGroup)adg)) {
                cs = AdminUtil.findCalSuite(request, cl, (BwAdminGroup)parent);
                if (cs == null) continue;
                return cs;
            }
        }
        catch (CalFacadeAccessException cfe) {
            request.error("org.bedework.client.error.nocalsuiteaccess", (Object)adg.getPrincipalRef());
        }
        return null;
    }
}

